/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.messagebox.internal.registry;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.apache.axis2.databinding.utils.ConverterUtil;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.messagebox.MessageBoxException;
import org.wso2.carbon.messagebox.internal.ds.MessageBoxServiceValueHolder;
import org.wso2.carbon.messagebox.internal.utils.Utils;
import org.wso2.carbon.messagebox.queue.Queue;
import org.wso2.carbon.messagebox.queue.QueueManager;
import org.wso2.carbon.messagebox.queue.QueueRolePermission;
import org.wso2.carbon.messagebox.queue.QueueUserPermission;
import org.wso2.carbon.qpid.service.QpidService;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.user.api.UserRealm;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.api.UserStoreManager;
import org.wso2.carbon.user.core.Permission;

public class RegistryQueueManager
implements QueueManager {
    public RegistryQueueManager() throws MessageBoxException {
        this.init();
    }

    public void init() throws MessageBoxException {
        try {
            UserRegistry userRegistry = Utils.getUserRegistry();
            if (!userRegistry.resourceExists("event/queues/jms")) {
                userRegistry.put("event/queues/jms", (Resource)userRegistry.newCollection());
            }
        }
        catch (RegistryException e) {
            throw new MessageBoxException("Can not access the registry", e);
        }
    }

    @Override
    public List<Queue> getAllQueues() throws MessageBoxException {
        ArrayList<Queue> queues = new ArrayList<Queue>();
        try {
            UserRegistry userRegistry = Utils.getUserRegistry();
            Collection queuesResource = (Collection)userRegistry.get("event/queues/jms");
            for (String childResource : queuesResource.getChildren()) {
                Object queueDepth;
                String createdFrom;
                String updatedTime;
                String queueName = childResource.substring(childResource.indexOf("event/queues/jms") + "event/queues/jms".length() + 1);
                Resource queueResource = userRegistry.get(childResource);
                Queue queue = new Queue(queueName);
                String createdTime = queueResource.getProperty("createdTime");
                if (createdTime != null) {
                    queue.setCreatedTime(ConverterUtil.convertToDateTime((String)createdTime));
                }
                if ((updatedTime = queueResource.getProperty("updatedTime")) != null) {
                    queue.setUpdatedTime(ConverterUtil.convertToDateTime((String)updatedTime));
                }
                if ((createdFrom = queueResource.getProperty("createdFrom")) != null) {
                    queue.setCreatedFrom(createdFrom);
                }
                if ((queueDepth = this.getAttribute(queueName, "QueueDepth")) != null) {
                    queue.setQueueDepth((Long)queueDepth);
                } else {
                    queue.setQueueDepth(0L);
                }
                Object messageCount = this.getAttribute(queueName, "MessageCount");
                if (messageCount != null) {
                    queue.setMessageCount((Integer)messageCount);
                } else {
                    queue.setMessageCount(0);
                }
                queues.add(queue);
            }
            return queues;
        }
        catch (RegistryException e) {
            throw new MessageBoxException("Can not access the registry ", e);
        }
    }

    private Object getAttribute(String queueName, String attributeName) throws MessageBoxException {
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        QpidService qpidService = MessageBoxServiceValueHolder.getInstance().getQpidService();
        try {
            ObjectName objectName = new ObjectName("org.apache.qpid:type=VirtualHost.Queue,VirtualHost=\"" + qpidService.getVirtualHostName() + "\",name=\"" + Utils.getTenantBasedQueueName(queueName) + "\"");
            return mBeanServer.getAttribute(objectName, attributeName);
        }
        catch (MalformedObjectNameException e) {
            throw new MessageBoxException("Can not find the mbean for the queue " + queueName);
        }
        catch (InstanceNotFoundException e) {
            return null;
        }
        catch (ReflectionException e) {
            throw new MessageBoxException("Can not find the mbean for the queue " + queueName);
        }
        catch (AttributeNotFoundException e) {
            throw new MessageBoxException("Can not find the mbean for the queue " + queueName);
        }
        catch (MBeanException e) {
            throw new MessageBoxException("Can not find the mbean for the queue " + queueName);
        }
    }

    @Override
    public void addQueue(String queueName, String createdFrom) throws MessageBoxException {
        try {
            UserRegistry userRegistry = Utils.getUserRegistry();
            String resourcePath = "event/queues/jms/" + queueName;
            String ownerName = CarbonContext.getCurrentContext().getUsername();
            if (!userRegistry.resourceExists(resourcePath)) {
                Collection collection = userRegistry.newCollection();
                collection.setProperty("createdTime", ConverterUtil.convertToString((Calendar)Calendar.getInstance()));
                collection.setProperty("updatedTime", ConverterUtil.convertToString((Calendar)Calendar.getInstance()));
                collection.setProperty("createdFrom", createdFrom);
                collection.setProperty("owner", ownerName);
                userRegistry.put(resourcePath, (Resource)collection);
                UserRealm userRealm = MessageBoxServiceValueHolder.getInstance().getRealmService().getTenantUserRealm(0);
                String userName = CarbonContext.getCurrentContext().getUsername();
                UserStoreManager userStoreManager = Utils.getUserRelam().getUserStoreManager();
                if (!userStoreManager.isExistingRole(userName)) {
                    userStoreManager.addRole(userName, new String[]{userName}, (org.wso2.carbon.user.api.Permission[])new Permission[0]);
                }
                userRealm.getAuthorizationManager().authorizeRole(userName, resourcePath, "consume");
                userRealm.getAuthorizationManager().authorizeRole(userName, resourcePath, "publish");
                userRealm.getAuthorizationManager().authorizeRole(userName, resourcePath, "changePermission");
            }
        }
        catch (RegistryException e) {
            throw new MessageBoxException("Can not access the config registry");
        }
        catch (UserStoreException e) {
            throw new MessageBoxException("Can not access the user realm");
        }
    }

    @Override
    public List<QueueUserPermission> getQueueUserPermissions(String queueName) throws MessageBoxException {
        String queueResoucePath = "event/queues/jms/" + queueName;
        ArrayList<QueueUserPermission> queueUserPermissions = new ArrayList<QueueUserPermission>();
        UserRealm userRealm = CarbonContext.getCurrentContext().getUserRealm();
        try {
            for (String user : userRealm.getUserStoreManager().listUsers("*", 10)) {
                QueueUserPermission queueUserPermission = new QueueUserPermission();
                queueUserPermission.setUserName(user);
                queueUserPermission.setAllowedToConsume(userRealm.getAuthorizationManager().isUserAuthorized(user, queueResoucePath, "consume"));
                queueUserPermission.setAllowedToPublish(userRealm.getAuthorizationManager().isUserAuthorized(user, queueResoucePath, "publish"));
                queueUserPermissions.add(queueUserPermission);
            }
            return queueUserPermissions;
        }
        catch (UserStoreException e) {
            throw new MessageBoxException("Can not access the Userstore manager ", e);
        }
    }

    @Override
    public List<QueueRolePermission> getQueueRolePermissions(String queueName) throws MessageBoxException {
        String queueResourcePath = "event/queues/jms/" + queueName;
        ArrayList<QueueRolePermission> queueRolePermissions = new ArrayList<QueueRolePermission>();
        UserRealm userRealm = CarbonContext.getCurrentContext().getUserRealm();
        try {
            for (String roleName : userRealm.getUserStoreManager().getRoleNames()) {
                QueueRolePermission queueRolePermission = new QueueRolePermission();
                queueRolePermission.setRoleName(roleName);
                queueRolePermission.setAllowedToConsume(userRealm.getAuthorizationManager().isRoleAuthorized(roleName, queueResourcePath, "consume"));
                queueRolePermission.setAllowedToPublish(userRealm.getAuthorizationManager().isRoleAuthorized(roleName, queueResourcePath, "publish"));
                queueRolePermissions.add(queueRolePermission);
            }
            return queueRolePermissions;
        }
        catch (UserStoreException e) {
            throw new MessageBoxException("Can not access the UserStore manager ", e);
        }
    }

    @Override
    public void updateRolePermission(List<QueueRolePermission> queueRolePermissions, String queueName) throws MessageBoxException {
        String queueResourcePath = "event/queues/jms/" + queueName;
        UserRealm userRealm = CarbonContext.getCurrentContext().getUserRealm();
        try {
            String loggedInUser = CarbonContext.getCurrentContext().getUsername();
            if (!userRealm.getAuthorizationManager().isUserAuthorized(loggedInUser, queueResourcePath, "changePermission") && !Utils.isAdmin(loggedInUser)) {
                throw new MessageBoxException(" User " + loggedInUser + " can not change" + " the permissions of " + queueName);
            }
            for (QueueRolePermission queueRolePermission : queueRolePermissions) {
                String role = queueRolePermission.getRoleName();
                if (queueRolePermission.isAllowedToConsume()) {
                    if (!userRealm.getAuthorizationManager().isRoleAuthorized(role, queueResourcePath, "consume")) {
                        userRealm.getAuthorizationManager().authorizeRole(role, queueResourcePath, "consume");
                    }
                } else if (userRealm.getAuthorizationManager().isRoleAuthorized(role, queueResourcePath, "consume")) {
                    userRealm.getAuthorizationManager().denyRole(role, queueResourcePath, "consume");
                }
                if (queueRolePermission.isAllowedToPublish()) {
                    if (userRealm.getAuthorizationManager().isRoleAuthorized(role, queueResourcePath, "publish")) continue;
                    userRealm.getAuthorizationManager().authorizeRole(role, queueResourcePath, "publish");
                    continue;
                }
                if (!userRealm.getAuthorizationManager().isRoleAuthorized(role, queueResourcePath, "publish")) continue;
                userRealm.getAuthorizationManager().denyRole(role, queueResourcePath, "publish");
            }
            this.setQueueUpdatedTime(queueName);
        }
        catch (UserStoreException e) {
            throw new MessageBoxException("Can not access the user store manager", e);
        }
    }

    @Override
    public void updateUserPermission(List<QueueUserPermission> queueUserPermissions, String queueName) throws MessageBoxException {
        String queueResourcePath = "event/queues/jms/" + queueName;
        UserRealm userRealm = CarbonContext.getCurrentContext().getUserRealm();
        try {
            String loggedInUser = CarbonContext.getCurrentContext().getUsername();
            if (!userRealm.getAuthorizationManager().isUserAuthorized(loggedInUser, queueResourcePath, "changePermission") && !Utils.isAdmin(loggedInUser)) {
                throw new MessageBoxException(" User " + loggedInUser + " can not change" + " the permissions of " + queueName);
            }
            for (QueueUserPermission queueUserPermission : queueUserPermissions) {
                String user = queueUserPermission.getUserName();
                UserStoreManager userStoreManager = Utils.getUserRelam().getUserStoreManager();
                if (!userStoreManager.isExistingRole(user)) {
                    userStoreManager.addRole(user, new String[]{user}, (org.wso2.carbon.user.api.Permission[])new Permission[0]);
                }
                if (queueUserPermission.isAllowedToConsume()) {
                    if (!userRealm.getAuthorizationManager().isUserAuthorized(user, queueResourcePath, "consume")) {
                        userRealm.getAuthorizationManager().authorizeRole(user, queueResourcePath, "consume");
                    }
                } else if (userRealm.getAuthorizationManager().isUserAuthorized(user, queueResourcePath, "consume")) {
                    userRealm.getAuthorizationManager().denyRole(user, queueResourcePath, "consume");
                }
                if (queueUserPermission.isAllowedToPublish()) {
                    if (userRealm.getAuthorizationManager().isUserAuthorized(user, queueResourcePath, "publish")) continue;
                    userRealm.getAuthorizationManager().authorizeRole(user, queueResourcePath, "publish");
                    continue;
                }
                if (!userRealm.getAuthorizationManager().isUserAuthorized(user, queueResourcePath, "publish")) continue;
                userRealm.getAuthorizationManager().denyRole(user, queueResourcePath, "publish");
            }
            this.setQueueUpdatedTime(queueName);
        }
        catch (UserStoreException e) {
            throw new MessageBoxException("Can not access the user store manager", e);
        }
    }

    @Override
    public void deleteQueue(String queueName) throws MessageBoxException {
        try {
            UserRegistry userRegistry = Utils.getUserRegistry();
            String resourcePath = "event/queues/jms/" + queueName;
            userRegistry.delete(resourcePath);
            if (Utils.queueExists(queueName)) {
                Utils.deleteQueue(queueName);
            }
        }
        catch (RegistryException e) {
            throw new MessageBoxException("Failed to delete queue: " + queueName, e);
        }
    }

    @Override
    public void setQueueUpdatedTime(String queueName) throws MessageBoxException {
        try {
            UserRegistry userRegistry = Utils.getUserRegistry();
            String resourcePath = "event/queues/jms/" + queueName;
            if (userRegistry.resourceExists(resourcePath)) {
                Collection collection = (Collection)userRegistry.get(resourcePath);
                collection.removeProperty("updatedTime");
                collection.setProperty("updatedTime", ConverterUtil.convertToString((Calendar)Calendar.getInstance()));
                userRegistry.put(resourcePath, (Resource)collection);
            }
        }
        catch (RegistryException e) {
            throw new MessageBoxException("Failed to set queue updated time on queue: " + queueName, e);
        }
    }

    @Override
    public boolean isQueueExists(String queueName) throws MessageBoxException {
        try {
            UserRegistry userRegistry = Utils.getUserRegistry();
            String resourcePath = "event/queues/jms/" + queueName;
            return userRegistry.resourceExists(resourcePath);
        }
        catch (RegistryException e) {
            throw new MessageBoxException("Failed to delete queue: " + queueName, e);
        }
    }
}

