/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.messagebox.internal.qpid;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueConnection;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.messagebox.SQSMessage;
import org.wso2.carbon.messagebox.internal.qpid.JMSQueueHandlerException;
import org.wso2.carbon.messagebox.internal.qpid.MessageLock;
import org.wso2.carbon.messagebox.internal.qpid.MessageLockException;
import org.wso2.carbon.messagebox.internal.qpid.QueueConnectionManager;
import org.wso2.carbon.messagebox.internal.qpid.QueueConnectionManagerException;
import org.wso2.carbon.messagebox.internal.utils.Utils;

public class JMSQueueHandler {
    private static final Log log = LogFactory.getLog(JMSQueueHandler.class);

    public static void pushMessage(String queueName, SQSMessage sqsMessage, String userName) throws JMSQueueHandlerException {
        QueueConnection queueConnection = null;
        QueueSession queueSession = null;
        QueueSender queueSender = null;
        try {
            queueConnection = QueueConnectionManager.getInstance().getConnection(Utils.getTenantAwareCurrentUserName());
            queueConnection.start();
            queueSession = queueConnection.createQueueSession(false, 1);
            Queue queue = JMSQueueHandler.getDurableQueue(queueName, queueSession);
            TextMessage textMessage = queueSession.createTextMessage(sqsMessage.getBody());
            if (sqsMessage.getMd5ofMessageBody() != null) {
                textMessage.setStringProperty("MD5OfMessage", sqsMessage.getMd5ofMessageBody());
            }
            textMessage.setStringProperty("SenderId", sqsMessage.getAttribute().get("SenderId"));
            textMessage.setStringProperty("VisibilityTimeOut", Long.toString(sqsMessage.getDefaultVisibilityTimeout()));
            textMessage.setStringProperty("messageSentTimestamp", String.valueOf(System.currentTimeMillis()));
            textMessage.setStringProperty("messageId", sqsMessage.getMessageId());
            String receivedCount = sqsMessage.getAttribute().get("ApproximateReceiveCount");
            textMessage.setStringProperty("messageReceivedCount", receivedCount != null ? receivedCount : "0");
            queueSender = queueSession.createSender(queue);
            queueSender.send((Message)textMessage);
        }
        catch (QueueConnectionManagerException e) {
            throw new JMSQueueHandlerException(e);
        }
        catch (JMSException e) {
            throw new JMSQueueHandlerException(e);
        }
        finally {
            if (queueSender != null) {
                try {
                    queueSender.close();
                }
                catch (JMSException e) {
                    log.error((Object)"Failed to close queue sender.", (Throwable)e);
                }
            }
            if (queueSession != null) {
                try {
                    queueSession.close();
                }
                catch (JMSException e) {
                    log.error((Object)"Failed to close queue session.", (Throwable)e);
                }
            }
            if (queueConnection != null) {
                try {
                    QueueConnectionManager.getInstance().releaseConnection(queueConnection);
                }
                catch (QueueConnectionManagerException e) {
                    log.error((Object)"Failed to close queue connection.", (Throwable)e);
                }
            }
        }
    }

    public static String getJMSQueueName(String queueName) {
        return queueName.split("/")[1];
    }

    public static MessageLock popMessage(String messageBoxID, long visibilityTimeout) throws JMSQueueHandlerException {
        try {
            QueueConnection queueConnection = QueueConnectionManager.getInstance().getConnection(Utils.getTenantAwareCurrentUserName());
            queueConnection.start();
            QueueSession queueSession = queueConnection.createQueueSession(false, 2);
            Queue queue = JMSQueueHandler.getDurableQueue(messageBoxID, queueSession);
            QueueReceiver queueReceiver = queueSession.createReceiver(queue);
            Message message = queueReceiver.receive(50L);
            MessageLock lock = null;
            if (message != null) {
                JMSQueueHandler.setVisibilityTimeoutStringProperty(visibilityTimeout, message);
                lock = new MessageLock(queueConnection, queueSession, message, visibilityTimeout);
                lock.setMessageBoxID(messageBoxID);
                queueReceiver.close();
            } else {
                queueReceiver.close();
                queueSession.close();
                QueueConnectionManager.getInstance().releaseConnection(queueConnection);
            }
            return lock;
        }
        catch (QueueConnectionManagerException e) {
            throw new JMSQueueHandlerException(e);
        }
        catch (JMSException e) {
            throw new JMSQueueHandlerException(e);
        }
        catch (MessageLockException e) {
            throw new JMSQueueHandlerException(e);
        }
    }

    public static void setVisibilityTimeoutStringProperty(long visibilityTimeout, Message message) throws JMSQueueHandlerException {
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        try {
            Enumeration enumeration = message.getPropertyNames();
            while (enumeration.hasMoreElements()) {
                String propertyName = enumeration.nextElement().toString();
                propertyMap.put(propertyName, message.getStringProperty(propertyName));
            }
            message.clearProperties();
            for (Map.Entry entry : propertyMap.entrySet()) {
                message.setStringProperty(entry.getKey().toString(), entry.getValue().toString());
            }
            message.setStringProperty("VisibilityTimeOut", String.valueOf(visibilityTimeout + System.currentTimeMillis()));
        }
        catch (JMSException e) {
            throw new JMSQueueHandlerException(e);
        }
    }

    public static List<Message> browse(String queueName) throws JMSQueueHandlerException {
        QueueConnection queueConnection = null;
        QueueSession queueSession = null;
        QueueBrowser queueBrowser = null;
        try {
            queueConnection = QueueConnectionManager.getInstance().getConnection(Utils.getTenantAwareCurrentUserName());
            queueSession = queueConnection.createQueueSession(false, 1);
            Queue queue = JMSQueueHandler.getDurableQueue(queueName, queueSession);
            queueBrowser = queueSession.createBrowser(queue);
            queueConnection.start();
            Enumeration messageEnumeration = queueBrowser.getEnumeration();
            ArrayList<Message> messageList = new ArrayList<Message>();
            while (messageEnumeration.hasMoreElements()) {
                messageList.add((Message)messageEnumeration.nextElement());
            }
            ArrayList<Message> arrayList = messageList;
            return arrayList;
        }
        catch (QueueConnectionManagerException e) {
            throw new JMSQueueHandlerException(e);
        }
        catch (JMSException e) {
            throw new JMSQueueHandlerException(e);
        }
        finally {
            if (queueBrowser != null) {
                try {
                    queueBrowser.close();
                }
                catch (JMSException e) {
                    log.error((Object)"Failed to close queue browser.", (Throwable)e);
                }
            }
            if (queueSession != null) {
                try {
                    queueSession.close();
                }
                catch (JMSException e) {
                    log.error((Object)"Failed to close queue session.", (Throwable)e);
                }
            }
            if (queueConnection != null) {
                try {
                    QueueConnectionManager.getInstance().releaseConnection(queueConnection);
                }
                catch (QueueConnectionManagerException e) {
                    log.error((Object)"Failed to close queue connection.", (Throwable)e);
                }
            }
        }
    }

    public static void clearQueue(String queueName) throws JMSQueueHandlerException {
        QueueConnection queueConnection = null;
        QueueSession queueSession = null;
        QueueReceiver queueReceiver = null;
        try {
            queueConnection = QueueConnectionManager.getInstance().getConnection(Utils.getTenantAwareCurrentUserName());
            queueSession = queueConnection.createQueueSession(false, 1);
            Queue queue = JMSQueueHandler.getDurableQueue(queueName, queueSession);
            queueReceiver = queueSession.createReceiver(queue);
            queueConnection.start();
            while (queueReceiver.receive(50L) != null) {
            }
        }
        catch (QueueConnectionManagerException e) {
            throw new JMSQueueHandlerException(e);
        }
        catch (JMSException e) {
            throw new JMSQueueHandlerException(e);
        }
        finally {
            if (queueReceiver != null) {
                try {
                    queueReceiver.close();
                }
                catch (JMSException e) {
                    log.error((Object)"Failed to close queue receiver", (Throwable)e);
                }
            }
            if (queueSession != null) {
                try {
                    queueSession.close();
                }
                catch (JMSException e) {
                    log.error((Object)"Failed to close queue session", (Throwable)e);
                }
            }
            if (queueConnection != null) {
                try {
                    QueueConnectionManager.getInstance().releaseConnection(queueConnection);
                }
                catch (QueueConnectionManagerException e) {
                    log.error((Object)"Failed to close queue connection", (Throwable)e);
                }
            }
        }
    }

    private static Queue getDurableQueue(String queueName, QueueSession queueSession) throws JMSException {
        queueName = Utils.getTenantBasedQueueName(JMSQueueHandler.getJMSQueueName(queueName));
        return queueSession.createQueue(queueName + ";{create:always, node:{durable: True}}");
    }
}

