/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.messagebox.internal.qpid;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;
import javax.management.MBeanServer;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.qpid.management.common.mbeans.ManagedQueue;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.messagebox.MessageBoxDetails;
import org.wso2.carbon.messagebox.MessageBoxException;
import org.wso2.carbon.messagebox.MessageBoxService;
import org.wso2.carbon.messagebox.MessageDetails;
import org.wso2.carbon.messagebox.PermissionLabel;
import org.wso2.carbon.messagebox.SQSMessage;
import org.wso2.carbon.messagebox.internal.qpid.JMSQueueHandler;
import org.wso2.carbon.messagebox.internal.qpid.JMSQueueHandlerException;
import org.wso2.carbon.messagebox.internal.qpid.MessageBoxAuthorizationHandler;
import org.wso2.carbon.messagebox.internal.qpid.MessageLock;
import org.wso2.carbon.messagebox.internal.qpid.MessageLockException;
import org.wso2.carbon.messagebox.internal.qpid.RegistryMessageBoxHandler;
import org.wso2.carbon.messagebox.internal.utils.Utils;
import org.wso2.carbon.messagebox.queue.QueueManager;
import org.wso2.carbon.messagebox.queue.QueueUserPermission;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class JMSMessageBoxService
implements MessageBoxService {
    private static final Log log = LogFactory.getLog(JMSMessageBoxService.class);
    private static String QPID_VHOST_NAME = "carbon";
    private QueueManager queueManager;
    private RegistryMessageBoxHandler registryMessageBoxHandler;
    private MessageBoxAuthorizationHandler authorizationHandler;
    private ConcurrentHashMap<Integer, ConcurrentHashMap<String, MessageLock>> tenantBasedMessageLocks = new ConcurrentHashMap();

    private ConcurrentHashMap<String, MessageLock> getMessageLocks() {
        int tenantId = CarbonContext.getCurrentContext().getTenantId();
        if (!this.tenantBasedMessageLocks.containsKey(tenantId)) {
            ConcurrentHashMap messageLocks = new ConcurrentHashMap();
            this.tenantBasedMessageLocks.put(tenantId, messageLocks);
        }
        return this.tenantBasedMessageLocks.get(tenantId);
    }

    @Override
    public MessageBoxDetails[] getAllMessageBoxes() throws MessageBoxException {
        List<MessageBoxDetails> messageBoxDetailsList = this.registryMessageBoxHandler.getMessageBoxDetails();
        String username = this.getCurrentUser();
        if (Utils.isAdmin(username)) {
            for (MessageBoxDetails messageBoxDetails : messageBoxDetailsList) {
                String messageBoxId = JMSQueueHandler.getJMSQueueName(messageBoxDetails.getMessageBoxId());
                messageBoxDetails.setNumberOfMessages(this.getVisibleMessageCount(messageBoxId) + this.getHiddenMessageCount(messageBoxId));
                messageBoxDetails.setTenantDomain(CarbonContext.getCurrentContext().getTenantDomain());
            }
            return messageBoxDetailsList.toArray(new MessageBoxDetails[messageBoxDetailsList.size()]);
        }
        ArrayList<MessageBoxDetails> userMessageBoxes = new ArrayList<MessageBoxDetails>();
        for (MessageBoxDetails messageBoxDetails : messageBoxDetailsList) {
            if (!messageBoxDetails.getMessageBoxOwner().equals(username) && !this.authorizationHandler.isUserAuthorized(username, messageBoxDetails.getMessageBoxId(), "ReceiveMessage")) continue;
            String messageBoxId = JMSQueueHandler.getJMSQueueName(messageBoxDetails.getMessageBoxId());
            messageBoxDetails.setNumberOfMessages(this.getVisibleMessageCount(messageBoxId) + this.getHiddenMessageCount(messageBoxId));
            messageBoxDetails.setTenantDomain(CarbonContext.getCurrentContext().getTenantDomain());
            userMessageBoxes.add(messageBoxDetails);
        }
        return userMessageBoxes.toArray(new MessageBoxDetails[userMessageBoxes.size()]);
    }

    @Override
    public MessageDetails[] getAllAvailableMessages(String messageBoxId) throws MessageBoxException {
        String username = this.getCurrentUser();
        if (!(Utils.isAdmin(username) || this.isMessageBoxOwner(messageBoxId, username) || this.authorizationHandler.isUserAuthorized(username, messageBoxId, "ReceiveMessage"))) {
            throw new MessageBoxException("AccessDenied");
        }
        if (!this.registryMessageBoxHandler.isMessageBoxExists(messageBoxId)) {
            throw new MessageBoxException("AWS.SimpleQueueService.NonExistentQueue");
        }
        try {
            List<Message> jmsMessageList = JMSQueueHandler.browse(messageBoxId);
            MessageDetails[] messageDetailsArray = new MessageDetails[jmsMessageList.size()];
            int index = 0;
            for (Message jmsMessage : jmsMessageList) {
                messageDetailsArray[index++] = this.jmsMessageToMessageDetails(jmsMessage);
            }
            return messageDetailsArray;
        }
        catch (JMSQueueHandlerException e) {
            throw new MessageBoxException("InternalError", e);
        }
    }

    @Override
    public MessageDetails[] getAllRetrievedMessages(String messageBoxId) throws MessageBoxException {
        String username = this.getCurrentUser();
        if (!(Utils.isAdmin(username) || this.isMessageBoxOwner(messageBoxId, username) || this.authorizationHandler.isUserAuthorized(username, messageBoxId, "ReceiveMessage"))) {
            throw new MessageBoxException("AccessDenied");
        }
        if (!this.registryMessageBoxHandler.isMessageBoxExists(messageBoxId)) {
            throw new MessageBoxException("AWS.SimpleQueueService.NonExistentQueue");
        }
        ArrayList<MessageDetails> messageDetailsList = new ArrayList<MessageDetails>();
        for (MessageLock messageLock : this.getMessageLocks().values()) {
            if (!messageLock.getMessageBoxID().equals(messageBoxId)) continue;
            MessageDetails messageDetails = this.jmsMessageToMessageDetails(messageLock.getJmsMessage());
            messageDetails.setReceiptHandler(messageLock.getReceiptHandle());
            messageDetailsList.add(messageDetails);
        }
        return messageDetailsList.toArray(new MessageDetails[messageDetailsList.size()]);
    }

    @Override
    public List<PermissionLabel> getAllPermissions(String messageBoxId) throws MessageBoxException {
        String username = this.getCurrentUser();
        if (!(Utils.isAdmin(username) || this.isMessageBoxOwner(messageBoxId, username) || this.authorizationHandler.isUserAuthorized(username, messageBoxId, "ReceiveMessage"))) {
            throw new MessageBoxException("AccessDenied");
        }
        return this.registryMessageBoxHandler.getAllPermissions(messageBoxId);
    }

    @Override
    public String createMessageBox(String messageBoxName, long defaultVisibilityTimeout) throws MessageBoxException {
        String username = this.getCurrentUser();
        defaultVisibilityTimeout *= 1000L;
        if (this.registryMessageBoxHandler.isMessageBoxExists(username, messageBoxName)) {
            MessageBoxDetails messageBoxDetails = this.registryMessageBoxHandler.getMessageBoxDetails(username + "/" + messageBoxName);
            if (messageBoxDetails.getDefaultVisibilityTimeout() != defaultVisibilityTimeout) {
                throw new MessageBoxException("message box already exists with the name, " + messageBoxName + " for user " + username);
            }
        } else {
            this.registryMessageBoxHandler.createMessageBox(username, messageBoxName, defaultVisibilityTimeout);
        }
        this.queueManager.addQueue(messageBoxName, "sqsClient");
        String messageBoxId = username + "/" + messageBoxName;
        this.authorizationHandler.allowAllPermissionsToAdminRole(messageBoxId);
        this.authorizationHandler.allowAllPermissionsToUser(messageBoxId, username);
        this.allowQueuePermissionOnCreateQueue(username, JMSQueueHandler.getJMSQueueName(messageBoxId));
        return messageBoxId;
    }

    private void allowQueuePermissionOnCreateQueue(String username, String messageBoxId) throws MessageBoxException {
        ArrayList<QueueUserPermission> userPermissions = new ArrayList<QueueUserPermission>();
        QueueUserPermission queueUserPermission = new QueueUserPermission();
        queueUserPermission.setUserName(username);
        queueUserPermission.setAllowedToConsume(true);
        queueUserPermission.setAllowedToPublish(true);
        userPermissions.add(queueUserPermission);
        this.queueManager.updateUserPermission(userPermissions, messageBoxId);
    }

    @Override
    public String deleteMessageBox(String messageBoxId) throws MessageBoxException {
        String username = this.getCurrentUser();
        if (!Utils.isAdmin(username) && !this.isMessageBoxOwner(messageBoxId, username)) {
            throw new MessageBoxException("AccessDenied");
        }
        if (!this.registryMessageBoxHandler.isMessageBoxExists(messageBoxId)) {
            throw new MessageBoxException("AWS.SimpleQueueService.NonExistentQueue");
        }
        try {
            JMSQueueHandler.clearQueue(messageBoxId);
        }
        catch (JMSQueueHandlerException e) {
            throw new MessageBoxException("InternalError", e);
        }
        List<PermissionLabel> permissionLabels = this.registryMessageBoxHandler.getAllPermissions(messageBoxId);
        for (PermissionLabel permissionLabel : permissionLabels) {
            this.authorizationHandler.removePermission(messageBoxId, permissionLabel);
        }
        this.authorizationHandler.denyAllPermissionsToUser(messageBoxId, username);
        this.registryMessageBoxHandler.deleteMessageBox(messageBoxId);
        this.queueManager.deleteQueue(messageBoxId.split("/")[1]);
        return messageBoxId;
    }

    private boolean isMessageBoxOwner(String messageBoxID, String username) {
        return messageBoxID.split("/")[0].equals(username);
    }

    @Override
    public SQSMessage putMessage(String messageBoxID, SQSMessage sqsMessage) throws MessageBoxException {
        if (!this.authorizationHandler.isAuthorized(messageBoxID, "SendMessage")) {
            throw new MessageBoxException("AccessDenied");
        }
        if (!this.registryMessageBoxHandler.isMessageBoxExists(messageBoxID)) {
            throw new MessageBoxException("AWS.SimpleQueueService.NonExistentQueue");
        }
        try {
            JMSQueueHandler.pushMessage(messageBoxID, sqsMessage, sqsMessage.getAttribute().get("SenderId"));
            this.queueManager.setQueueUpdatedTime(JMSQueueHandler.getJMSQueueName(messageBoxID));
            return sqsMessage;
        }
        catch (JMSQueueHandlerException e) {
            throw new MessageBoxException("InternalError", e);
        }
    }

    @Override
    public List<SQSMessage> receiveMessage(String messageBoxId, int maximumNumberOfMessages, long visibilityTimeout, Map<String, String> attributes) throws MessageBoxException {
        if (!this.authorizationHandler.isAuthorized(messageBoxId, "ReceiveMessage")) {
            throw new MessageBoxException("AccessDenied");
        }
        if (!this.registryMessageBoxHandler.isMessageBoxExists(messageBoxId)) {
            throw new MessageBoxException("AWS.SimpleQueueService.NonExistentQueue");
        }
        if (visibilityTimeout == 0L) {
            visibilityTimeout = this.registryMessageBoxHandler.getMessageBoxDetails(messageBoxId).getDefaultVisibilityTimeout();
        }
        try {
            MessageLock messageLock;
            ArrayList<SQSMessage> sqsMessageList = new ArrayList<SQSMessage>();
            while (0 < maximumNumberOfMessages && (messageLock = JMSQueueHandler.popMessage(messageBoxId, visibilityTimeout)) != null) {
                messageLock.setLockStore(this.getMessageLocks());
                this.getMessageLocks().put(messageLock.getReceiptHandle(), messageLock);
                SQSMessage sqsMessage = this.jmsMessageToSQSMessage(messageLock.getJmsMessage());
                sqsMessage.setReceiptHandle(messageLock.getReceiptHandle());
                if (sqsMessage.getDefaultVisibilityTimeout() == 0L) {
                    MessageBoxDetails messageBoxDetails = this.registryMessageBoxHandler.getMessageBoxDetails(messageBoxId);
                    sqsMessage.setDefaultVisibilityTimeout(messageBoxDetails.getDefaultVisibilityTimeout());
                }
                sqsMessage.setDefaultVisibilityTimeout(visibilityTimeout);
                sqsMessageList.add(sqsMessage);
                --maximumNumberOfMessages;
            }
            this.queueManager.setQueueUpdatedTime(JMSQueueHandler.getJMSQueueName(messageBoxId));
            return sqsMessageList;
        }
        catch (JMSQueueHandlerException e) {
            throw new MessageBoxException("InternalError", e);
        }
    }

    @Override
    public void deleteMessage(String messageBoxId, String receiptHandler) throws MessageBoxException {
        if (!this.authorizationHandler.isAuthorized(messageBoxId, "DeleteMessage")) {
            throw new MessageBoxException("AccessDenied");
        }
        if (!this.registryMessageBoxHandler.isMessageBoxExists(messageBoxId)) {
            throw new MessageBoxException("AWS.SimpleQueueService.NonExistentQueue");
        }
        try {
            MessageLock messageLock = this.getMessageLocks().get(receiptHandler);
            if (messageLock != null) {
                messageLock.deleteMessage();
                this.queueManager.setQueueUpdatedTime(JMSQueueHandler.getJMSQueueName(messageBoxId));
            }
        }
        catch (MessageLockException e) {
            throw new MessageBoxException("InternalError", e);
        }
    }

    @Override
    public List<String> listQueues(String qnamePrefix) throws MessageBoxException {
        return this.registryMessageBoxHandler.getMessageBoxURISuffixes(qnamePrefix);
    }

    @Override
    public void changeVisibility(String messageBoxId, String receiptHandler, long extension) throws MessageBoxException {
        if (!this.authorizationHandler.isAuthorized(messageBoxId, "ChangeMessageVisibility")) {
            throw new MessageBoxException("AccessDenied");
        }
        if (!this.registryMessageBoxHandler.isMessageBoxExists(messageBoxId)) {
            throw new MessageBoxException("AWS.SimpleQueueService.NonExistentQueue");
        }
        try {
            MessageLock messageLock = this.getMessageLocks().get(receiptHandler);
            if (null != messageLock) {
                messageLock.changeMessageVisibility(extension);
                JMSQueueHandler.setVisibilityTimeoutStringProperty(messageLock.getVisibilityTimeout(), messageLock.getJmsMessage());
                this.queueManager.setQueueUpdatedTime(JMSQueueHandler.getJMSQueueName(messageBoxId));
            }
        }
        catch (MessageLockException e) {
            throw new MessageBoxException("ExceedVisibilityTimeout", e);
        }
        catch (JMSQueueHandlerException e) {
            throw new MessageBoxException("ExceedVisibilityTimeout", e);
        }
    }

    @Override
    public Map<String, String> getMessageBoxAttributes(String messageBoxId) throws MessageBoxException {
        if (!this.authorizationHandler.isAuthorized(messageBoxId, "GetQueueAttributes")) {
            throw new MessageBoxException("AccessDenied");
        }
        if (!this.registryMessageBoxHandler.isMessageBoxExists(messageBoxId)) {
            throw new MessageBoxException("AWS.SimpleQueueService.NonExistentQueue");
        }
        HashMap<String, String> attributeMap = new HashMap<String, String>();
        MessageBoxDetails messageBoxDetails = this.registryMessageBoxHandler.getMessageBoxDetails(messageBoxId);
        attributeMap.put("CreatedTimestamp", Long.toString(messageBoxDetails.getCreatedTimeStamp()));
        attributeMap.put("VisibilityTimeout", Long.toString(messageBoxDetails.getDefaultVisibilityTimeout()));
        attributeMap.put("ApproximateNumberOfMessages", Integer.toString(this.getVisibleMessageCount(messageBoxId)));
        attributeMap.put("ApproximateNumberOfMessagesNotVisible", Integer.toString(this.getHiddenMessageCount(messageBoxId)));
        return attributeMap;
    }

    @Override
    public void setMessageBoxAttributes(String messageBoxId, Map<String, String> attributes) throws MessageBoxException {
        String username = this.getCurrentUser();
        if (!Utils.isAdmin(username) && !this.isMessageBoxOwner(messageBoxId, username)) {
            throw new MessageBoxException("AccessDenied");
        }
        if (!this.registryMessageBoxHandler.isMessageBoxExists(messageBoxId)) {
            throw new MessageBoxException("AWS.SimpleQueueService.NonExistentQueue");
        }
        this.registryMessageBoxHandler.setMessageBoxDetails(messageBoxId, attributes);
        this.queueManager.setQueueUpdatedTime(JMSQueueHandler.getJMSQueueName(messageBoxId));
    }

    @Override
    public void removePermission(String messageBoxId, String permissionLabelName) throws MessageBoxException {
        String username = this.getCurrentUser();
        if (!Utils.isAdmin(username) && !this.isMessageBoxOwner(messageBoxId, username)) {
            throw new MessageBoxException("AccessDenied");
        }
        if (!this.registryMessageBoxHandler.isMessageBoxExists(messageBoxId)) {
            throw new MessageBoxException("AWS.SimpleQueueService.NonExistentQueue");
        }
        PermissionLabel removedPermissionLabel = this.registryMessageBoxHandler.getPermission(messageBoxId, permissionLabelName);
        this.registryMessageBoxHandler.removePermission(messageBoxId, permissionLabelName);
        List<PermissionLabel> allPermissions = this.registryMessageBoxHandler.getAllPermissions(messageBoxId);
        ArrayList<PermissionLabel> otherAllowedPermissions = new ArrayList<PermissionLabel>();
        for (String removedSharedUser : removedPermissionLabel.getSharedUsers()) {
            for (PermissionLabel permissionLabel : allPermissions) {
                if (!permissionLabel.getSharedUsers().contains(removedSharedUser)) continue;
                for (String removedOperation : removedPermissionLabel.getOperations()) {
                    if (!permissionLabel.getOperations().contains(removedOperation)) continue;
                    ArrayList<String> duplicatedSharedUsers = new ArrayList<String>();
                    duplicatedSharedUsers.add(removedSharedUser);
                    ArrayList<String> duplicatedOperations = new ArrayList<String>();
                    duplicatedOperations.add(removedOperation);
                    PermissionLabel duplicatedPermissions = new PermissionLabel("DuplicatedPermissions", duplicatedSharedUsers, duplicatedOperations);
                    otherAllowedPermissions.add(duplicatedPermissions);
                }
            }
        }
        this.authorizationHandler.removePermission(messageBoxId, removedPermissionLabel);
        List<String> removePermissionOperations = removedPermissionLabel.getOperations();
        for (String sharedUser : removedPermissionLabel.getSharedUsers()) {
            QueueUserPermission queueUserPermission = new QueueUserPermission();
            this.setPublishPermission(removePermissionOperations, queueUserPermission, false);
            this.setConsumePermission(removePermissionOperations, queueUserPermission, false);
            queueUserPermission.setUserName(sharedUser);
            ArrayList<QueueUserPermission> userPermissions = new ArrayList<QueueUserPermission>();
            userPermissions.add(queueUserPermission);
            this.queueManager.updateUserPermission(userPermissions, JMSQueueHandler.getJMSQueueName(messageBoxId));
        }
        for (PermissionLabel permissionLabel : otherAllowedPermissions) {
            this.authorizationHandler.addPermission(messageBoxId, permissionLabel);
            for (String sharedUser : permissionLabel.getSharedUsers()) {
                QueueUserPermission queueUserPermission = new QueueUserPermission();
                this.setPublishPermission(removePermissionOperations, queueUserPermission, true);
                this.setConsumePermission(removePermissionOperations, queueUserPermission, true);
                queueUserPermission.setUserName(sharedUser);
                ArrayList<QueueUserPermission> userPermissions = new ArrayList<QueueUserPermission>();
                userPermissions.add(queueUserPermission);
                this.queueManager.updateUserPermission(userPermissions, JMSQueueHandler.getJMSQueueName(messageBoxId));
            }
        }
        this.queueManager.setQueueUpdatedTime(JMSQueueHandler.getJMSQueueName(messageBoxId));
    }

    @Override
    public void addPermission(String messageBoxId, List<String> operationsList, String permissionLabelName, List<String> sharedUsers) throws MessageBoxException {
        String username = this.getCurrentUser();
        if (!Utils.isAdmin(username) && !this.isMessageBoxOwner(messageBoxId, username)) {
            throw new MessageBoxException("AccessDenied");
        }
        if (!this.registryMessageBoxHandler.isMessageBoxExists(messageBoxId)) {
            throw new MessageBoxException("AWS.SimpleQueueService.NonExistentQueue");
        }
        sharedUsers = this.registryMessageBoxHandler.getSharedUsers(sharedUsers.toArray(new String[sharedUsers.size()]));
        PermissionLabel permissionLabel = new PermissionLabel(permissionLabelName, sharedUsers, operationsList);
        this.registryMessageBoxHandler.addPermission(messageBoxId, permissionLabel);
        this.authorizationHandler.addPermission(messageBoxId, permissionLabel);
        List<String> operationList = permissionLabel.getOperations();
        for (String sharedUser : sharedUsers) {
            QueueUserPermission queueUserPermission = new QueueUserPermission();
            this.setPublishPermission(operationList, queueUserPermission, true);
            this.setConsumePermission(operationList, queueUserPermission, true);
            queueUserPermission.setUserName(sharedUser);
            ArrayList<QueueUserPermission> userPermissions = new ArrayList<QueueUserPermission>();
            userPermissions.add(queueUserPermission);
            this.queueManager.updateUserPermission(userPermissions, JMSQueueHandler.getJMSQueueName(messageBoxId));
        }
        this.queueManager.setQueueUpdatedTime(JMSQueueHandler.getJMSQueueName(messageBoxId));
    }

    private void setConsumePermission(List<String> operationList, QueueUserPermission queueUserPermission, boolean allowConsume) {
        if (operationList.contains("ChangeMessageVisibility") || operationList.contains("GetQueueAttributes") || operationList.contains("ReceiveMessage") || operationList.contains("DeleteMessage") || operationList.contains("*")) {
            queueUserPermission.setAllowedToConsume(allowConsume);
        }
    }

    private void setPublishPermission(List<String> operationList, QueueUserPermission queueUserPermission, boolean allowPublish) {
        if (operationList.contains("*") || operationList.contains("SendMessage")) {
            queueUserPermission.setAllowedToPublish(allowPublish);
        }
    }

    private String getCurrentUser() {
        return MultitenantUtils.getTenantAwareUsername((String)CarbonContext.getCurrentContext().getUsername());
    }

    private int getHiddenMessageCount(String messageBoxID) {
        int count = 0;
        for (MessageLock messageLock : this.getMessageLocks().values()) {
            if (!messageBoxID.equals(messageLock.getMessageBoxID())) continue;
            ++count;
        }
        return count;
    }

    private int getVisibleMessageCount(String messageBoxID) throws MessageBoxException {
        try {
            int count = 0;
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            ObjectName objectName = new ObjectName("org.apache.qpid:type=VirtualHost.Queue,VirtualHost=\"" + QPID_VHOST_NAME + "\"," + "name=\"" + Utils.getTenantBasedQueueName(messageBoxID) + "\",*");
            Set<ObjectName> set = mBeanServer.queryNames(objectName, null);
            if (set.size() > 0) {
                ManagedQueue managedQueue = MBeanServerInvocationHandler.newProxyInstance(mBeanServer, (ObjectName)set.toArray()[0], ManagedQueue.class, false);
                count = managedQueue.getMessageCount();
            }
            return count;
        }
        catch (MalformedObjectNameException e) {
            throw new MessageBoxException(e);
        }
        catch (IOException e) {
            throw new MessageBoxException(e);
        }
    }

    public SQSMessage jmsMessageToSQSMessage(Message jmsMessage) throws MessageBoxException {
        SQSMessage sqsMessage = new SQSMessage();
        TextMessage textMessage = (TextMessage)jmsMessage;
        try {
            sqsMessage.setDefaultVisibilityTimeout(Long.parseLong(textMessage.getStringProperty("VisibilityTimeOut")));
            sqsMessage.setMd5ofMessageBody(textMessage.getStringProperty("MD5OfMessage"));
            sqsMessage.setBody(textMessage.getText());
            sqsMessage.setMessageId(textMessage.getStringProperty("messageId"));
            sqsMessage.getAttribute().put("SenderId", textMessage.getStringProperty("SenderId"));
            sqsMessage.getAttribute().put("SentTimestamp", textMessage.getStringProperty("SentTimestamp"));
            sqsMessage.getAttribute().put("ApproximateFirstReceiveTimestamp", textMessage.getStringProperty("ApproximateFirstReceiveTimestamp"));
            sqsMessage.getAttribute().put("ApproximateReceiveCount", textMessage.getStringProperty("messageReceivedCount"));
            return sqsMessage;
        }
        catch (JMSException e) {
            String error = "Failed to convert JMS Message to SQSMessage";
            log.error((Object)error);
            throw new MessageBoxException(error, e);
        }
    }

    public MessageDetails jmsMessageToMessageDetails(Message jmsMessage) throws MessageBoxException {
        try {
            MessageDetails messageDetails = new MessageDetails();
            TextMessage textMessage = (TextMessage)jmsMessage;
            messageDetails.setMessageBody(textMessage.getText());
            messageDetails.setMessageId(textMessage.getStringProperty("messageId"));
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(Long.parseLong(textMessage.getStringProperty("VisibilityTimeOut")));
            messageDetails.setDefaultVisibilityTimeout(calendar.getTime().toString());
            String receivedCount = textMessage.getStringProperty("messageReceivedCount");
            messageDetails.setReceivedCount(null != receivedCount ? receivedCount : "0");
            calendar.setTimeInMillis(Long.parseLong(textMessage.getStringProperty("messageSentTimestamp")));
            messageDetails.setSentTimestamp(calendar.getTime().toString());
            return messageDetails;
        }
        catch (JMSException e) {
            String error = "Failed to convert JMS Message to MessageDetails";
            log.error((Object)error);
            throw new MessageBoxException(error, e);
        }
    }

    @Override
    public QueueManager getQueueManager() throws MessageBoxException {
        return this.queueManager;
    }

    public void setQueueManager(QueueManager queueManager) {
        this.queueManager = queueManager;
    }

    public void setRegistryMessageBoxHandler(RegistryMessageBoxHandler registryMessageBoxHandler) {
        this.registryMessageBoxHandler = registryMessageBoxHandler;
    }

    public void setAuthorizationHandler(MessageBoxAuthorizationHandler authorizationHandler) {
        this.authorizationHandler = authorizationHandler;
    }
}

