/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.messagebox.internal.inmemory;

import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingDeque;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.messagebox.MessageBoxDetails;
import org.wso2.carbon.messagebox.MessageBoxException;
import org.wso2.carbon.messagebox.MessageDetails;
import org.wso2.carbon.messagebox.SQSMessage;
import org.wso2.carbon.messagebox.internal.inmemory.PermissionLabel;
import org.wso2.carbon.messagebox.internal.inmemory.VisibilityTimeoutChecker;

public class MessageBox {
    private static final Log log = LogFactory.getLog(MessageBox.class);
    private String queueId;
    private Deque<SQSMessage> SQSMessageQueue;
    private Map<String, SQSMessage> receivedMessages;
    private VisibilityTimeoutChecker timeoutChecker;
    private MessageBoxDetails messageBoxDetails;
    private Map<String, PermissionLabel> permissionLabelMap;
    private Map<String, String> queueAttributes;

    public MessageBox(String owner, String messageBoxName, long defaultVisibilityTimeout) {
        this.queueId = messageBoxName;
        this.SQSMessageQueue = new LinkedBlockingDeque<SQSMessage>();
        this.receivedMessages = new ConcurrentHashMap<String, SQSMessage>();
        this.queueAttributes = new ConcurrentHashMap<String, String>();
        this.messageBoxDetails = new MessageBoxDetails(messageBoxName, owner, defaultVisibilityTimeout, 0);
        this.permissionLabelMap = new ConcurrentHashMap<String, PermissionLabel>();
        this.timeoutChecker = new VisibilityTimeoutChecker(this);
        new Thread(this.timeoutChecker).start();
        String createdTime = Long.toString(System.currentTimeMillis() / 1000L);
        this.queueAttributes.put("CreatedTimestamp", createdTime);
    }

    public List<String> getSharedUsers() {
        HashSet<String> sharedUsersSet = new HashSet<String>();
        for (String permissionLabel : this.permissionLabelMap.keySet()) {
            sharedUsersSet.addAll(this.permissionLabelMap.get(permissionLabel).getSharedUserList());
        }
        return new ArrayList<String>(sharedUsersSet);
    }

    public synchronized void addPermission(String permissionLabelName, List<String> sharedUsersList, List<String> operationsList) {
        PermissionLabel permissionLabel = new PermissionLabel(sharedUsersList, operationsList);
        this.permissionLabelMap.put(permissionLabelName, permissionLabel);
    }

    public synchronized void removePermission(String permissionLabelName) {
        this.permissionLabelMap.remove(permissionLabelName);
    }

    public synchronized void setLastModifiedTimestamp() {
        this.queueAttributes.put("LastModifiedTimestamp", Long.toString(System.currentTimeMillis() / 1000L));
    }

    public synchronized MessageBoxDetails getMessageBoxDetails() {
        this.messageBoxDetails.setNumberOfMessages(this.SQSMessageQueue.size());
        this.messageBoxDetails.setSharedUsersList(this.getSharedUsers());
        return this.messageBoxDetails;
    }

    public synchronized void setQueueAttributes(Map<String, String> queueAttributes) throws MessageBoxException {
        for (Map.Entry<String, String> pairs : queueAttributes.entrySet()) {
            String attributeName = pairs.getKey();
            String attributeValue = pairs.getValue();
            if (this.queueAttributes.containsKey(attributeName)) {
                if (attributeValue != null) {
                    this.queueAttributes.put(attributeName, attributeValue);
                    continue;
                }
                if (log.isWarnEnabled()) {
                    log.warn((Object)(attributeName + " attribute value can not be null."));
                }
                throw new MessageBoxException("InvalidAttributeValue ", "Unknown attributeValue ");
            }
            if (log.isWarnEnabled()) {
                log.warn((Object)(attributeName + " attribute is not supported."));
            }
            throw new MessageBoxException("InvalidAttributeName ", "Unknown attribute ");
        }
    }

    public synchronized Map<String, String> getQueueAttributes() {
        this.queueAttributes.put("ApproximateNumberOfMessages", Integer.toString(this.SQSMessageQueue.size()));
        this.queueAttributes.put("ApproximateNumberOfMessagesNotVisible", Integer.toString(this.receivedMessages.size()));
        this.queueAttributes.put("VisibilityTimeout", Long.toString(this.messageBoxDetails.getDefaultVisibilityTimeout()));
        return this.queueAttributes;
    }

    public synchronized void putMessage(SQSMessage SQSMessage2) {
        SQSMessage2.setDefaultVisibilityTimeout(this.messageBoxDetails.getDefaultVisibilityTimeout());
        SQSMessage2.setSentTimestamp();
        this.SQSMessageQueue.push(SQSMessage2);
        this.setLastModifiedTimestamp();
    }

    public synchronized List<SQSMessage> receiveMessage(int numberofMaximumMessages, long visibilityTimeout, Map<String, String> attributes) {
        ArrayList<SQSMessage> SQSMessageList = new ArrayList<SQSMessage>();
        if (this.SQSMessageQueue.size() < numberofMaximumMessages) {
            numberofMaximumMessages = this.SQSMessageQueue.size();
        }
        for (int messageCount = 0; messageCount < numberofMaximumMessages; ++messageCount) {
            SQSMessage SQSMessage2 = this.SQSMessageQueue.pollFirst();
            SQSMessage2.setFirstReceivedTimestamp();
            SQSMessage2.setReceiveCount();
            SQSMessage2.setReceivedTimeStamp(System.currentTimeMillis());
            SQSMessage2.setDefaultVisibilityTimeout(visibilityTimeout);
            String receiptHandler = UUID.randomUUID().toString();
            SQSMessage2.setReceiptHandle(receiptHandler);
            SQSMessageList.add(SQSMessage2);
            this.receivedMessages.put(receiptHandler, SQSMessage2);
        }
        this.setLastModifiedTimestamp();
        return SQSMessageList;
    }

    public synchronized MessageDetails[] getAllMessages() {
        ArrayList<MessageDetails> messageList = new ArrayList<MessageDetails>();
        for (SQSMessage SQSMessage2 : this.SQSMessageQueue) {
            MessageDetails messageDetails = new MessageDetails();
            messageDetails.setMessageBody(SQSMessage2.getBody());
            messageDetails.setMessageId(SQSMessage2.getMessageId());
            if (SQSMessage2.getAttribute().get("ApproximateReceiveCount") != null) {
                messageDetails.setReceivedCount(SQSMessage2.getAttribute().get("ApproximateReceiveCount"));
            } else {
                messageDetails.setReceivedCount("0");
            }
            messageList.add(messageDetails);
        }
        return messageList.toArray(new MessageDetails[messageList.size()]);
    }

    public synchronized SQSMessage deleteMessage(String receiptHandler) {
        this.setLastModifiedTimestamp();
        return this.receivedMessages.remove(receiptHandler);
    }

    public synchronized SQSMessage changeVisibilityTimeout(String receiptHandler, long visibilityTimeout) {
        SQSMessage SQSMessage2 = this.receivedMessages.get(receiptHandler);
        SQSMessage2.setDefaultVisibilityTimeout(visibilityTimeout);
        this.setLastModifiedTimestamp();
        return this.receivedMessages.put(receiptHandler, SQSMessage2);
    }

    public synchronized void checkTimeoutMessages() {
        for (Map.Entry<String, SQSMessage> pairs : this.receivedMessages.entrySet()) {
            SQSMessage SQSMessage2 = pairs.getValue();
            long currentTimeStampDifference = System.currentTimeMillis() - SQSMessage2.getReceivedTimeStamp();
            if (currentTimeStampDifference <= SQSMessage2.getDefaultVisibilityTimeout()) continue;
            String receiptHandler = pairs.getKey();
            this.SQSMessageQueue.addFirst(SQSMessage2);
            this.receivedMessages.remove(receiptHandler);
        }
    }

    public boolean isSharedForOperation(String loggedInUser, String operation) {
        for (String permissionLabel : this.permissionLabelMap.keySet()) {
            if (!this.permissionLabelMap.get(permissionLabel).isSharedForOperation(loggedInUser, operation)) continue;
            return true;
        }
        return false;
    }
}

