/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.messagebox.internal.ds;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.core.multitenancy.SuperTenantCarbonContext;
import org.wso2.carbon.messagebox.MessageBoxConfigurationException;
import org.wso2.carbon.messagebox.MessageBoxService;
import org.wso2.carbon.messagebox.internal.builder.Axis2ConfigurationContextObserverImpl;
import org.wso2.carbon.messagebox.internal.builder.MessageBoxServiceBuilder;
import org.wso2.carbon.messagebox.internal.ds.MessageBoxServiceValueHolder;
import org.wso2.carbon.messagebox.internal.qpid.QueueConnectionManager;
import org.wso2.carbon.messagebox.internal.qpid.QueueConnectionManagerException;
import org.wso2.carbon.qpid.service.QpidService;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.Axis2ConfigurationContextObserver;
import org.wso2.carbon.utils.ConfigurationContextService;

public class MessageBoxServiceComponent {
    private static Log log = LogFactory.getLog(MessageBoxServiceComponent.class);

    protected void activate(ComponentContext context) {
        try {
            SuperTenantCarbonContext.startTenantFlow();
            SuperTenantCarbonContext.getCurrentContext().setTenantId(-1234);
            MessageBoxService messageBoxService = MessageBoxServiceBuilder.createMessageBoxService();
            context.getBundleContext().registerService(MessageBoxService.class.getName(), (Object)messageBoxService, null);
            context.getBundleContext().registerService(Axis2ConfigurationContextObserver.class.getName(), (Object)new Axis2ConfigurationContextObserverImpl(), null);
        }
        catch (MessageBoxConfigurationException e) {
            log.error((Object)"MessageBoxService bundle activation is failed.", (Throwable)e);
        }
    }

    protected void deactivate(ComponentContext context) {
        try {
            QueueConnectionManager.getInstance().closeAllConnections();
        }
        catch (QueueConnectionManagerException e) {
            log.warn((Object)("Error while closing QueueConnectionManager connections : " + e.getLocalizedMessage()));
        }
    }

    protected void setQpidService(QpidService qpidService) {
        MessageBoxServiceValueHolder.getInstance().registerQpidService(qpidService);
    }

    protected void unsetQpidService(QpidService qpidService) {
    }

    protected void setRealmService(RealmService realmService) {
        MessageBoxServiceValueHolder.getInstance().registerRealmService(realmService);
    }

    protected void unsetRealmService(RealmService realmService) {
    }

    protected void setRegistryService(RegistryService registryService) {
        MessageBoxServiceValueHolder.getInstance().registerRegistryService(registryService);
    }

    protected void unsetRegistryService(RegistryService registryService) {
    }

    protected void setConfigurationContextService(ConfigurationContextService configurationContextService) {
        MessageBoxServiceValueHolder.getInstance().registerConfigurationContextService(configurationContextService);
    }

    protected void unsetConfigurationContextService(ConfigurationContextService configurationContextService) {
    }
}

