/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.message.processor.ui.utils;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.synapse.config.xml.MessageProcessorFactory;
import org.apache.synapse.config.xml.MessageStoreFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageProcessorData {
    private String name;
    private String clazz;
    private String messageStore;
    private Map<String, String> params = new HashMap<String, String>();

    public MessageProcessorData(String xml) throws XMLStreamException {
        this.populate(xml);
    }

    public String getName() {
        return this.name;
    }

    public String getMessageStore() {
        return this.messageStore;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public String getClazz() {
        return this.clazz;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setClazz(String provider) {
        this.clazz = provider;
    }

    public void setMessageStore(String store) {
        this.messageStore = store;
    }

    private void populate(String xml) throws XMLStreamException {
        ByteArrayInputStream in = new ByteArrayInputStream(xml.getBytes());
        OMElement elem = new StAXOMBuilder((InputStream)in).getDocumentElement();
        OMAttribute attElem = elem.getAttribute(MessageProcessorFactory.CLASS_Q);
        if (attElem != null) {
            this.clazz = attElem.getAttributeValue();
        }
        if ((attElem = elem.getAttribute(MessageProcessorFactory.NAME_Q)) != null) {
            this.name = attElem.getAttributeValue();
        }
        if ((attElem = elem.getAttribute(MessageProcessorFactory.MESSAGE_STORE_Q)) != null) {
            this.messageStore = attElem.getAttributeValue();
        }
        Iterator it = elem.getChildrenWithName(MessageStoreFactory.PARAMETER_Q);
        while (it.hasNext()) {
            OMElement paramElem = (OMElement)it.next();
            OMAttribute nameAtt = paramElem.getAttribute(MessageStoreFactory.NAME_Q);
            assert (nameAtt != null);
            String name = nameAtt.getAttributeValue();
            String value = paramElem.getText();
            this.params.put(name, value);
        }
    }
}

