/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.viewflows.service;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.engine.Phase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.viewflows.AxisConfigData;
import org.wso2.carbon.viewflows.HandlerData;
import org.wso2.carbon.viewflows.PhaseData;
import org.wso2.carbon.viewflows.PhaseOrderData;

public class AxisConfigAdminService
extends AbstractAdmin {
    private static final Log log = LogFactory.getLog(AxisConfigAdminService.class);

    public AxisConfigData getAxisConfigData() {
        AxisConfigData axisConfigData = new AxisConfigData();
        AxisConfiguration axisConfiguration = this.getAxisConfig();
        axisConfigData.setInflowPhaseOrder(this.getPhaseOrderData(axisConfiguration.getInFlowPhases(), null, false));
        axisConfigData.setOutflowPhaseOrder(this.getPhaseOrderData(axisConfiguration.getOutFlowPhases(), null, true));
        axisConfigData.setInfaultflowPhaseOrder(this.getPhaseOrderData(axisConfiguration.getInFaultFlowPhases(), null, false));
        axisConfigData.setOutfaultPhaseOrder(this.getPhaseOrderData(axisConfiguration.getOutFaultFlowPhases(), null, true));
        return axisConfigData;
    }

    private PhaseOrderData getPhaseOrderData(List globalPhaseList, List localPhaseList, boolean invert) {
        PhaseOrderData phaseOrderData = new PhaseOrderData();
        int globalPhases = globalPhaseList == null ? 0 : globalPhaseList.size();
        int localPhases = localPhaseList == null ? 0 : localPhaseList.size();
        PhaseData[] phaseData = new PhaseData[globalPhases + localPhases];
        if (globalPhaseList != null) {
            this.setPhaseDataArray(globalPhaseList, phaseData, true, 0, invert);
        }
        if (localPhaseList != null) {
            this.setPhaseDataArray(localPhaseList, phaseData, false, globalPhases, invert);
        }
        phaseOrderData.setPhases(phaseData);
        return phaseOrderData;
    }

    private void setPhaseDataArray(List phaseList, PhaseData[] phaseData, boolean isGlobalPhase, int offset, boolean invert) {
        for (int i = 0; i < phaseList.size(); ++i) {
            Phase phase = (Phase)phaseList.get(i);
            phaseData[offset + i] = this.getPhaseData(phase, isGlobalPhase, invert);
        }
    }

    private PhaseData getPhaseData(Phase phase, boolean isGlobalPhase, boolean invert) {
        PhaseData phaseData = new PhaseData(phase.getPhaseName());
        phaseData.setIsGlobalPhase(isGlobalPhase);
        HandlerData[] handlers = new HandlerData[phase.getHandlerCount()];
        if (invert) {
            int i = phase.getHandlers().size() - 1;
            int j = 0;
            while (i >= 0) {
                Handler handler = (Handler)phase.getHandlers().get(i);
                handlers[j] = this.getHandlerData(handler);
                --i;
                ++j;
            }
        } else {
            for (int i = 0; i < phase.getHandlers().size(); ++i) {
                Handler handler = (Handler)phase.getHandlers().get(i);
                handlers[i] = this.getHandlerData(handler);
            }
        }
        phaseData.setHandlers(handlers);
        log.debug((Object)("Setting phase ==> " + phaseData.getName()));
        return phaseData;
    }

    private HandlerData getHandlerData(Handler handler) {
        HandlerData handlerData = new HandlerData(handler.getName());
        handlerData.setClassName(handler.getHandlerDesc().getClassName());
        handlerData.setPhaseLast(handler.getHandlerDesc().getRules().isPhaseLast());
        return handlerData;
    }

    public AxisConfigData getOperationAxisConfigData(String serviceId, String operationId) throws AxisFault {
        log.debug((Object)("Getting handler details for service " + serviceId + " operation " + operationId));
        AxisConfigData axisConfigData = new AxisConfigData();
        AxisConfiguration axisConfiguration = this.getAxisConfig();
        AxisService axisService = axisConfiguration.getService(serviceId);
        AxisOperation axisOperation = axisService.getOperation(new QName(operationId));
        axisConfigData.setInflowPhaseOrder(this.getPhaseOrderData(axisConfiguration.getInFlowPhases(), axisOperation.getRemainingPhasesInFlow(), false));
        axisConfigData.setOutflowPhaseOrder(this.getPhaseOrderData(axisOperation.getPhasesOutFlow(), axisConfiguration.getOutFlowPhases(), true));
        axisConfigData.setInfaultflowPhaseOrder(this.getPhaseOrderData(axisConfiguration.getInFaultFlowPhases(), axisOperation.getPhasesInFaultFlow(), false));
        axisConfigData.setOutfaultPhaseOrder(this.getPhaseOrderData(axisOperation.getPhasesOutFaultFlow(), axisConfiguration.getOutFaultFlowPhases(), true));
        return axisConfigData;
    }

    public ArrayList getHandlerNamesForPhase(String flow, String phase) {
        ArrayList handlerNames = new ArrayList();
        return handlerNames;
    }
}

