/*
 * Decompiled with CFR 0.152.
 */
package com.sun.script.scheme;

import com.sun.script.scheme.SchemeScriptEngineFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Properties;
import javax.script.AbstractScriptEngine;
import javax.script.Bindings;
import javax.script.Invocable;
import javax.script.ScriptContext;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import sisc.data.Expression;
import sisc.data.Procedure;
import sisc.data.Quantity;
import sisc.data.SchemeBoolean;
import sisc.data.SchemeCharacter;
import sisc.data.SchemeString;
import sisc.data.SchemeVoid;
import sisc.data.Symbol;
import sisc.data.Value;
import sisc.interpreter.AppContext;
import sisc.interpreter.Context;
import sisc.interpreter.ContinuationException;
import sisc.interpreter.Interpreter;
import sisc.interpreter.SchemeCaller;
import sisc.interpreter.SchemeException;
import sisc.modules.s2j.JavaObject;
import sisc.modules.s2j.Util;
import sisc.nativefun.FixableProcedure;
import sisc.reader.SourceReader;
import sisc.ser.BufferedRandomAccessInputStream;
import sisc.ser.MemoryRandomAccessInputStream;
import sisc.ser.SeekableDataInputStream;
import sisc.ser.SeekableInputStream;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemeScriptEngine
extends AbstractScriptEngine
implements Invocable {
    private ScriptEngineFactory factory;
    private AppContext appContext;
    private static final String SCHEME_HEAP_FILE = "sisc.shp";
    private static long sequence = 0L;
    private static final /* synthetic */ Class class$com$sun$script$scheme$SchemeScriptEngine;
    private static final /* synthetic */ Class class$java$lang$Object;

    public SchemeScriptEngine(Properties props) {
        this.appContext = new AppContext(props);
        Context.register((String)SchemeScriptEngine.uniqueName(), (AppContext)this.appContext);
        this.initApp();
    }

    public SchemeScriptEngine() {
        this(System.getProperties());
    }

    @Override
    public Object invokeFunction(String name, Object ... args) throws ScriptException, NoSuchMethodException {
        return this.invokeImpl(null, name, args);
    }

    @Override
    public Object invokeMethod(Object obj, String name, Object ... args) throws ScriptException, NoSuchMethodException {
        if (obj == null) {
            throw new IllegalArgumentException("script object is null");
        }
        return this.invokeImpl(obj, name, args);
    }

    private Object invokeImpl(Object obj, final String name, final Object ... args) throws ScriptException, NoSuchMethodException {
        if (name == null) {
            throw new NullPointerException("method name is null");
        }
        Value tmp = null;
        if (obj != null) {
            tmp = obj instanceof Value ? (Value)obj : SchemeScriptEngine.java2scheme(obj);
        }
        final Value thiz = tmp;
        try {
            return Context.execute((AppContext)this.appContext, (SchemeCaller)new SchemeCaller(){

                public Object execute(Interpreter interp) {
                    try {
                        return SchemeScriptEngine.access$000(SchemeScriptEngine.this, interp, thiz, name, args);
                    }
                    catch (ScriptException exp) {
                        throw new RuntimeException(exp);
                    }
                    catch (NoSuchMethodException exp) {
                        throw new RuntimeException(exp);
                    }
                }
            });
        }
        catch (SchemeException se) {
            throw new ScriptException((Exception)((Object)se));
        }
        catch (RuntimeException re) {
            this.handleRuntimeException2(re);
            return null;
        }
    }

    @Override
    public <T> T getInterface(Object obj, Class<T> clazz) {
        if (obj == null) {
            throw new IllegalArgumentException("script object is null");
        }
        return this.makeInterface(obj, clazz);
    }

    @Override
    public <T> T getInterface(Class<T> clazz) {
        return this.makeInterface(null, clazz);
    }

    private <T> T makeInterface(Object obj, Class<T> clazz) {
        if (clazz == null || !clazz.isInterface()) {
            throw new IllegalArgumentException("interface Class expected");
        }
        final Object thiz = obj;
        return (T)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, new InvocationHandler(){

            public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
                return SchemeScriptEngine.access$100(SchemeScriptEngine.this, thiz, m.getName(), args);
            }
        });
    }

    @Override
    public Object eval(String str, ScriptContext ctx) throws ScriptException {
        return this.eval((Reader)new StringReader(str), ctx);
    }

    @Override
    public Object eval(final Reader reader, final ScriptContext ctx) throws ScriptException {
        try {
            return Context.execute((AppContext)this.appContext, (SchemeCaller)new SchemeCaller(){

                public Object execute(Interpreter interp) {
                    try {
                        return SchemeScriptEngine.access$200(SchemeScriptEngine.this, interp, reader, ctx);
                    }
                    catch (ScriptException exp) {
                        throw new RuntimeException(exp);
                    }
                }
            });
        }
        catch (SchemeException se) {
            throw new ScriptException((Exception)((Object)se));
        }
        catch (RuntimeException re) {
            this.handleRuntimeException(re);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScriptEngineFactory getFactory() {
        SchemeScriptEngine schemeScriptEngine = this;
        synchronized (schemeScriptEngine) {
            if (this.factory == null) {
                this.factory = new SchemeScriptEngineFactory();
            }
        }
        return this.factory;
    }

    @Override
    public Bindings createBindings() {
        return new SimpleBindings();
    }

    void setFactory(ScriptEngineFactory factory) {
        this.factory = factory;
    }

    static Object scheme2java(Value value) {
        if (value instanceof JavaObject) {
            return ((JavaObject)value).get();
        }
        if (value instanceof SchemeVoid) {
            return null;
        }
        if (value instanceof SchemeBoolean) {
            return value.equals((Object)SchemeBoolean.TRUE) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (value instanceof SchemeCharacter) {
            return new Character(((SchemeCharacter)value).c);
        }
        if (value instanceof SchemeString) {
            return ((SchemeString)value).asString();
        }
        return value;
    }

    static Value java2scheme(Object jobj) {
        if (jobj instanceof Value) {
            return (Value)jobj;
        }
        if (jobj instanceof Boolean) {
            return jobj.equals(Boolean.TRUE) ? SchemeBoolean.TRUE : SchemeBoolean.FALSE;
        }
        if (jobj instanceof Character) {
            return new SchemeCharacter(((Character)jobj).charValue());
        }
        if (jobj instanceof String) {
            return new SchemeString((String)jobj);
        }
        if (jobj instanceof Number) {
            if (jobj instanceof Long) {
                return Quantity.valueOf((long)((Long)jobj));
            }
            if (jobj instanceof BigInteger) {
                return Quantity.valueOf((BigInteger)((BigInteger)jobj));
            }
            if (jobj instanceof BigDecimal) {
                return Quantity.valueOf((BigDecimal)((BigDecimal)jobj));
            }
            return Quantity.valueOf((double)((Number)jobj).doubleValue());
        }
        Class jclass = jobj == null ? (class$java$lang$Object == null ? (class$java$lang$Object = SchemeScriptEngine.class$("java.lang.Object")) : class$java$lang$Object) : jobj.getClass();
        return Util.makeJObj((Object)jobj, (Class)jclass);
    }

    static Value[] wrapArguments(Object[] args) {
        if (args == null) {
            return new Value[0];
        }
        Value[] res = new Value[args.length];
        for (int i = 0; i < args.length; ++i) {
            res[i] = SchemeScriptEngine.java2scheme(args[i]);
        }
        return res;
    }

    private Object eval(Interpreter interp, Reader reader, ScriptContext ctx) throws ScriptException {
        try {
            this.initContext(interp, ctx);
            Value res = interp.evalInput((PushbackReader)new SourceReader((Reader)new BufferedReader(reader), SchemeScriptEngine.getFileName(ctx)));
            return SchemeScriptEngine.scheme2java(res);
        }
        catch (Exception exp) {
            throw new ScriptException(exp);
        }
    }

    private Object invoke(Interpreter interp, Value thiz, String name, Object[] args) throws ScriptException, NoSuchMethodException {
        try {
            Symbol procName = interp.getSymbol(name);
            Expression expr = interp.lookup(procName, Util.TOPLEVEL);
            if (expr instanceof Procedure) {
                if (thiz != null) {
                    args = args == null ? new Object[]{} : args;
                    Object[] tmp = new Object[args.length + 1];
                    System.arraycopy(args, 0, tmp, 1, args.length);
                    tmp[0] = thiz;
                    args = tmp;
                }
                Value[] arguments = SchemeScriptEngine.wrapArguments(args);
                this.initContext(interp, this.context);
                Value res = interp.eval((Procedure)expr, arguments);
                return SchemeScriptEngine.scheme2java(res);
            }
            throw new NoSuchMethodException(name);
        }
        catch (SchemeException exp) {
            throw new ScriptException((Exception)((Object)exp));
        }
    }

    private void initContext(Interpreter interp, ScriptContext ctx) {
        ctx.setAttribute("context", ctx, 100);
        ContextProc ctxProc = new ContextProc(ctx);
        this.initContext(interp, (Value)ctxProc);
    }

    private void initContext(Interpreter interp, Value ctxProc) {
        interp.define(Symbol.get((String)"context"), ctxProc, Util.TOPLEVEL);
        interp.define(Symbol.get((String)"var"), ctxProc, Util.TOPLEVEL);
    }

    private void handleRuntimeException(RuntimeException re) throws ScriptException {
        Throwable cause = re.getCause();
        if (cause instanceof ScriptException) {
            throw (ScriptException)cause;
        }
        throw re;
    }

    private void handleRuntimeException2(RuntimeException re) throws ScriptException, NoSuchMethodException {
        Throwable cause = re.getCause();
        if (cause instanceof ScriptException) {
            throw (ScriptException)cause;
        }
        if (cause instanceof NoSuchMethodException) {
            throw (NoSuchMethodException)cause;
        }
        throw re;
    }

    private SeekableInputStream findHeap() {
        try {
            InputStream heapIS = (class$com$sun$script$scheme$SchemeScriptEngine == null ? (class$com$sun$script$scheme$SchemeScriptEngine = SchemeScriptEngine.class$("com.sun.script.scheme.SchemeScriptEngine")) : class$com$sun$script$scheme$SchemeScriptEngine).getResourceAsStream("/sisc.shp");
            if (heapIS == null) {
                String home = System.getProperty("sisc.home");
                if (home == null) {
                    return null;
                }
                String location = new StringBuffer().append(home).append(File.separator).append(SCHEME_HEAP_FILE).toString();
                return new BufferedRandomAccessInputStream(location, "r", 1, 8192);
            }
            return new MemoryRandomAccessInputStream(heapIS);
        }
        catch (IOException exp) {
            return null;
        }
    }

    private void initApp() {
        try {
            SeekableInputStream his = this.findHeap();
            SeekableDataInputStream in = new SeekableDataInputStream(his);
            this.appContext.loadEnv(in);
        }
        catch (IOException ie) {
            throw new RuntimeException(ie);
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException(cnfe);
        }
    }

    private static synchronized String uniqueName() {
        return new StringBuffer().append("com.sun.script.scheme.AppContext@").append(Long.toString(sequence++)).toString();
    }

    private static String getFileName(ScriptContext ctx) {
        Object name = ctx.getAttribute("javax.script.filename");
        if (name instanceof String) {
            return name.toString();
        }
        return "<unknown>";
    }

    static Object access$000(SchemeScriptEngine x0, Interpreter x1, Value x2, String x3, Object[] x4) throws ScriptException, NoSuchMethodException {
        return x0.invoke(x1, x2, x3, x4);
    }

    static Object access$100(SchemeScriptEngine x0, Object x1, String x2, Object[] x3) throws ScriptException, NoSuchMethodException {
        return x0.invokeImpl(x1, x2, x3);
    }

    static Object access$200(SchemeScriptEngine x0, Interpreter x1, Reader x2, ScriptContext x3) throws ScriptException {
        return x0.eval(x1, x2, x3);
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }

    private static class ContextProc
    extends FixableProcedure {
        private ScriptContext ctx;

        ContextProc(ScriptContext ctx) {
            this.ctx = ctx;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized Value apply() throws ContinuationException {
            ScriptContext scriptContext = this.ctx;
            synchronized (scriptContext) {
                return SchemeScriptEngine.java2scheme(this.ctx.getAttribute("context", 100));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized Value apply(Value v1) throws ContinuationException {
            String name = Util.symval((Value)v1);
            ScriptContext scriptContext = this.ctx;
            synchronized (scriptContext) {
                int scope = this.ctx.getAttributesScope(name);
                if (scope == -1) {
                    return VOID;
                }
                return SchemeScriptEngine.java2scheme(this.ctx.getAttribute(name, scope));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized Value apply(Value v1, Value v2) throws ContinuationException {
            String name = Util.symval((Value)v1);
            ScriptContext scriptContext = this.ctx;
            synchronized (scriptContext) {
                int scope = this.ctx.getAttributesScope(name);
                if (scope == -1) {
                    scope = 100;
                }
                this.ctx.setAttribute(name, SchemeScriptEngine.scheme2java(v2), scope);
            }
            return v2;
        }
    }
}

