/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediator.xquery;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.synapse.config.xml.SynapseXPathFactory;
import org.apache.synapse.config.xml.SynapseXPathSerializer;
import org.apache.synapse.config.xml.ValueFactory;
import org.apache.synapse.config.xml.ValueSerializer;
import org.apache.synapse.mediators.Value;
import org.apache.synapse.util.xpath.SynapseXPath;
import org.jaxen.JaxenException;
import org.wso2.carbon.mediator.service.MediatorException;
import org.wso2.carbon.mediator.service.ui.AbstractListMediator;
import org.wso2.carbon.mediator.service.ui.Mediator;
import org.wso2.carbon.mediator.service.util.MediatorProperty;
import org.wso2.carbon.mediator.xquery.Variable;

public class XQueryMediator
extends AbstractListMediator {
    public static final QName ATT_NAME_Q = new QName("", "name");
    public static final QName ATT_VALUE_Q = new QName("", "value");
    public static final QName ATT_EXPR_Q = new QName("", "expression");
    public static final QName ATT_KEY_Q = new QName("", "key");
    public static final QName ATT_TYPE_Q = new QName("", "type");
    private Value queryKey = null;
    private String querySource = null;
    private SynapseXPath target = null;
    private final List<MediatorProperty> dataSourceProperties = new ArrayList<MediatorProperty>();
    private final List<Variable> variables = new ArrayList<Variable>();

    public String getTagLocalName() {
        return "xquery";
    }

    public OMElement serialize(OMElement parent) {
        OMElement xquery = fac.createOMElement("xquery", synNS);
        if (this.queryKey != null) {
            ValueSerializer keySerializer = new ValueSerializer();
            keySerializer.serializeValue(this.queryKey, "key", xquery);
        }
        XQueryMediator.saveTracingState((OMElement)xquery, (Mediator)this);
        if (this.target != null) {
            SynapseXPathSerializer.serializeXPath((SynapseXPath)this.target, (OMElement)xquery, (String)"target");
        }
        if (this.dataSourceProperties != null && !this.dataSourceProperties.isEmpty()) {
            OMElement dataSource = fac.createOMElement("dataSource", synNS);
            this.serializeMediatorProperties(dataSource, this.dataSourceProperties, PROP_Q);
            xquery.addChild((OMNode)dataSource);
        }
        if (this.variables != null && !this.variables.isEmpty()) {
            for (Variable variable : this.variables) {
                SynapseXPath expression;
                QName name;
                if (variable.getVariableType() == 1) {
                    name = variable.getName();
                    String value = variable.getValue();
                    if (name == null || value == null) continue;
                    OMElement baseElement = fac.createOMElement("variable", synNS);
                    baseElement.addAttribute(fac.createOMAttribute("name", nullNS, name.getLocalPart()));
                    baseElement.addAttribute(fac.createOMAttribute("value", nullNS, value));
                    String type = null;
                    int varibelType = variable.getType();
                    if (13 == varibelType) {
                        type = "INT";
                    } else if (14 == varibelType) {
                        type = "INTEGER";
                    } else if (11 == varibelType) {
                        type = "BOOLEAN";
                    } else if (32 == varibelType) {
                        type = "BYTE";
                    } else if (19 == varibelType) {
                        type = "DOUBLE";
                    } else if (15 == varibelType) {
                        type = "SHORT";
                    } else if (16 == varibelType) {
                        type = "LONG";
                    } else if (21 == varibelType) {
                        type = "FLOAT";
                    } else if (30 == varibelType) {
                        type = "STRING";
                    } else if (4 == varibelType) {
                        type = "DOCUMENT";
                    } else if (5 == varibelType) {
                        type = "DOCUMENT_ELEMENT";
                    } else if (6 == varibelType) {
                        type = "ELEMENT";
                    } else {
                        throw new MediatorException("Unknown Type " + varibelType);
                    }
                    if (type != null) {
                        baseElement.addAttribute(fac.createOMAttribute("type", nullNS, type));
                    }
                    xquery.addChild((OMNode)baseElement);
                    continue;
                }
                if (variable.getVariableType() != 2 || (name = variable.getName()) == null) continue;
                OMElement customElement = fac.createOMElement("variable", synNS);
                customElement.addAttribute(fac.createOMAttribute("name", nullNS, name.getLocalPart()));
                String regkey = variable.getRegKey();
                if (regkey != null) {
                    customElement.addAttribute(fac.createOMAttribute("key", nullNS, regkey));
                }
                if ((expression = variable.getExpression()) != null) {
                    SynapseXPathSerializer.serializeXPath((SynapseXPath)expression, (OMElement)customElement, (String)"expression");
                }
                String type = null;
                int varibelType = variable.getType();
                if (4 == varibelType) {
                    type = "DOCUMENT";
                } else if (5 == varibelType) {
                    type = "DOCUMENT_ELEMENT";
                } else if (6 == varibelType) {
                    type = "ELEMENT";
                } else if (13 == varibelType) {
                    type = "INT";
                } else if (14 == varibelType) {
                    type = "INTEGER";
                } else if (11 == varibelType) {
                    type = "BOOLEAN";
                } else if (32 == varibelType) {
                    type = "BYTE";
                } else if (19 == varibelType) {
                    type = "DOUBLE";
                } else if (15 == varibelType) {
                    type = "SHORT";
                } else if (16 == varibelType) {
                    type = "LONG";
                } else if (21 == varibelType) {
                    type = "FLOAT";
                } else if (30 == varibelType) {
                    type = "STRING";
                } else {
                    throw new MediatorException("Unknown Type " + varibelType);
                }
                if (type != null) {
                    customElement.addAttribute(fac.createOMAttribute("type", nullNS, type));
                }
                xquery.addChild((OMNode)customElement);
            }
        }
        if (parent != null) {
            parent.addChild((OMNode)xquery);
        }
        return xquery;
    }

    public void build(OMElement elem) {
        String targetValue;
        OMAttribute xqueryKey = elem.getAttribute(new QName("", "key"));
        OMAttribute attrTarget = elem.getAttribute(new QName("", "target"));
        if (xqueryKey == null) {
            throw new MediatorException("The 'key' attribute is required for the XQuery mediator");
        }
        ValueFactory keyFactory = new ValueFactory();
        this.queryKey = keyFactory.createValue("key", elem);
        if (attrTarget != null && (targetValue = attrTarget.getAttributeValue()) != null && !"".equals(targetValue)) {
            try {
                this.querySource = targetValue;
                this.target = SynapseXPathFactory.getSynapseXPath((OMElement)elem, (QName)ATT_TARGET);
            }
            catch (JaxenException e) {
                throw new MediatorException("Invalid XPath specified for the target attribute : " + targetValue);
            }
        }
        this.processAuditStatus((Mediator)this, elem);
        OMElement dataSource = elem.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "dataSource"));
        if (dataSource != null) {
            this.dataSourceProperties.addAll(XQueryMediator.getMediatorProperties((OMElement)dataSource));
        }
        Iterator it = elem.getChildrenWithName(new QName("http://ws.apache.org/ns/synapse", "variable"));
        while (it.hasNext()) {
            Variable variable;
            String type;
            OMElement variableOM = (OMElement)it.next();
            String name = variableOM.getAttributeValue(ATT_NAME_Q);
            if (name == null || "".equals(name) || (type = variableOM.getAttributeValue(ATT_TYPE_Q)) == null || "".equals(type)) continue;
            String value = variableOM.getAttributeValue(ATT_VALUE_Q);
            if (value != null && !"".equals(value)) {
                variable = new Variable(new QName(name.trim()));
                variable.setValue(value.trim());
                variable.setType(1);
            } else {
                String key = variableOM.getAttributeValue(ATT_KEY_Q);
                String expr = variableOM.getAttributeValue(ATT_EXPR_Q);
                variable = new Variable(new QName(name.trim()));
                variable.setVariableType(2);
                if (key != null) {
                    variable.setRegKey(key.trim());
                }
                if (expr != null && !"".equals(expr)) {
                    try {
                        variable.setExpression(SynapseXPathFactory.getSynapseXPath((OMElement)variableOM, (QName)MediatorProperty.ATT_EXPR_Q));
                    }
                    catch (JaxenException e) {
                        throw new MediatorException("Invalid XPath specified for the expression attribute : " + expr);
                    }
                }
            }
            if ("INT".equals(type.trim())) {
                variable.setType(13);
            } else if ("INTEGER".equals(type.trim())) {
                variable.setType(14);
            } else if ("BOOLEAN".equals(type.trim())) {
                variable.setType(11);
            } else if ("BYTE".equals(type.trim())) {
                variable.setType(32);
            } else if ("DOUBLE".equals(type.trim())) {
                variable.setType(19);
            } else if ("SHORT".equals(type.trim())) {
                variable.setType(15);
            } else if ("LONG".equals(type.trim())) {
                variable.setType(16);
            } else if ("FLOAT".equals(type.trim())) {
                variable.setType(21);
            } else if ("STRING".equals(type.trim())) {
                variable.setType(30);
            } else if ("DOCUMENT".equals(type.trim())) {
                variable.setType(4);
            } else if ("DOCUMENT_ELEMENT".equals(type.trim())) {
                variable.setType(5);
            } else if ("ELEMENT".equals(type.trim())) {
                variable.setType(6);
            } else {
                throw new MediatorException("Unsupported Type");
            }
            this.variables.add(variable);
        }
    }

    public Value getQueryKey() {
        return this.queryKey;
    }

    public void setQueryKey(Value queryKey) {
        this.queryKey = queryKey;
    }

    public String getQuerySource() {
        return this.querySource;
    }

    public void setQuerySource(String querySource) {
        this.querySource = querySource;
    }

    public void addAllVariables(List<Variable> list) {
        this.variables.addAll(list);
    }

    public void addVariable(Variable variable) {
        this.variables.add(variable);
    }

    public List<MediatorProperty> getDataSourceProperties() {
        return this.dataSourceProperties;
    }

    public List<Variable> getVariables() {
        return this.variables;
    }

    public SynapseXPath getTarget() {
        return this.target;
    }

    public void setTarget(SynapseXPath source) {
        this.target = source;
    }

    public void addAllDataSourceProperties(List<MediatorProperty> list) {
        this.dataSourceProperties.addAll(list);
    }
}

