/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediator.urlrewrite;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.synapse.config.xml.SynapseXPathFactory;
import org.apache.synapse.util.xpath.SynapseXPath;
import org.jaxen.JaxenException;
import org.wso2.carbon.mediator.service.MediatorException;

public class URLRewriteActions {
    private SynapseXPath xpath;
    private String value;
    private String fragment;
    private String regex;
    public static final String TYPE_APPEND = "append";
    public static final String TYPE_PREPEND = "prepend";
    public static final String TYPE_REPLACE = "replace";
    public static final String TYPE_REMOVE = "remove";
    public static final String TYPE_SET = "set";
    private String type = "set";
    public static final String FRAGMENT_PROTOCOL = "protocol";
    public static final String FRAGMENT_HOST = "host";
    public static final String FRAGMENT_PORT = "port";
    public static final String FRAGMENT_PATH = "path";
    public static final String FRAGMENT_QUERY = "query";
    public static final String FRAGMENT_REF = "ref";
    public static final String FRAGMENT_USER = "user";
    public static final String FRAGMENT_FULL = "full";
    private String url = "full";

    public void setAction(String type) {
        this.type = type;
    }

    public String getAction() {
        return this.type;
    }

    public void setURL(String url) {
        this.url = url;
    }

    public String getURL() {
        return this.url;
    }

    public SynapseXPath getXpath() {
        ArrayList<String> nsUriList = new ArrayList<String>();
        if (this.xpath != null) {
            for (Object o : this.xpath.getNamespaces().keySet()) {
                int i = 0;
                String prefix = (String)o;
                String uri = this.xpath.getNamespaceContext().translateNamespacePrefixToUri(prefix);
                for (int j = 0; j <= i; ++j) {
                    if (nsUriList.size() > 0) {
                        if (uri.equals(((String)nsUriList.get(j)).toString())) {
                            this.xpath.getNamespaces().remove(prefix);
                            continue;
                        }
                        nsUriList.add(uri);
                        continue;
                    }
                    nsUriList.add(uri);
                }
                ++i;
            }
        }
        return this.xpath;
    }

    public void setXpath(SynapseXPath xpath) {
        this.xpath = xpath;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getFragment() {
        return this.fragment;
    }

    public void setFragment(String fragment) {
        this.fragment = fragment;
    }

    public String getRegex() {
        return this.regex;
    }

    public void setRegex(String regex) {
        this.regex = regex;
    }

    public static List<URLRewriteActions> getAllActions(OMElement elem) {
        QName VALUE_Q = new QName("value");
        QName XPATH_Q = new QName("xpath");
        QName REGEX_Q = new QName("regex");
        QName FRAGMENT_Q = new QName("fragment");
        QName TYPE_Q = new QName("type");
        QName ACTION_Q = new QName("http://ws.apache.org/ns/synapse", "action");
        ArrayList<URLRewriteActions> actionList = new ArrayList<URLRewriteActions>();
        Iterator itr = elem.getChildrenWithName(ACTION_Q);
        while (itr.hasNext()) {
            OMElement actionEle = (OMElement)itr.next();
            OMAttribute xpathAttr = actionEle.getAttribute(XPATH_Q);
            OMAttribute valueAttr = actionEle.getAttribute(VALUE_Q);
            OMAttribute regexAttr = actionEle.getAttribute(REGEX_Q);
            OMAttribute fragmentAttr = actionEle.getAttribute(FRAGMENT_Q);
            OMAttribute typeAttr = actionEle.getAttribute(TYPE_Q);
            URLRewriteActions urlRewriteActions = new URLRewriteActions();
            if (TYPE_SET.equals(typeAttr.getAttributeValue()) || TYPE_APPEND.equals(typeAttr.getAttributeValue()) || TYPE_PREPEND.equals(typeAttr.getAttributeValue()) || TYPE_REPLACE.equals(typeAttr.getAttributeValue())) {
                if (valueAttr == null && xpathAttr == null) {
                    String msg = "The 'value'/'xpath' attribute is required for the configuration for the 'set'/'append'/'prepend' or repalce action";
                    throw new MediatorException(msg);
                }
                if (valueAttr != null && valueAttr.getAttributeValue() != null) {
                    urlRewriteActions.setValue(valueAttr.getAttributeValue());
                }
                if (xpathAttr != null && xpathAttr.getAttributeValue() != null) {
                    try {
                        urlRewriteActions.setXpath(SynapseXPathFactory.getSynapseXPath((OMElement)actionEle, (QName)XPATH_Q));
                    }
                    catch (JaxenException e) {
                        throw new MediatorException("Could not construct the xpath");
                    }
                }
            }
            if (TYPE_REPLACE.equals(typeAttr.getAttributeValue())) {
                if (regexAttr == null) {
                    String msg = "The 'regex' attribute is required for the configuration for the 'replace' action";
                    throw new MediatorException(msg);
                }
                urlRewriteActions.setRegex(regexAttr.getAttributeValue());
            }
            if (typeAttr.getAttributeValue() != null) {
                urlRewriteActions.setAction(typeAttr.getAttributeValue());
            }
            if (fragmentAttr != null) {
                urlRewriteActions.setFragment(fragmentAttr.getAttributeValue());
            }
            if (valueAttr != null) {
                urlRewriteActions.setValue(valueAttr.getAttributeValue());
            } else if (xpathAttr != null) {
                try {
                    urlRewriteActions.setXpath(SynapseXPathFactory.getSynapseXPath((OMElement)actionEle, (QName)XPATH_Q));
                }
                catch (JaxenException e) {
                    String msg = "Invalid XPapth expression : " + xpathAttr.getAttributeValue();
                    throw new MediatorException(msg);
                }
            }
            actionList.add(urlRewriteActions);
        }
        return actionList;
    }
}

