/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediator.smooks.ui;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.synapse.config.xml.SynapseXPathFactory;
import org.apache.synapse.config.xml.SynapseXPathSerializer;
import org.apache.synapse.util.xpath.SynapseXPath;
import org.jaxen.JaxenException;
import org.wso2.carbon.mediator.service.MediatorException;
import org.wso2.carbon.mediator.service.ui.AbstractMediator;
import org.wso2.carbon.mediator.service.ui.Mediator;

public class SmooksMediator
extends AbstractMediator {
    private String configKey = null;
    private static final QName ATT_CONFIG_KEY = new QName("config-key");
    private String inputType = "xml";
    private SynapseXPath inputExpression = null;
    private String outputType = "xml";
    private SynapseXPath outputExpression = null;
    private String outputProperty = null;
    private String outputAction = null;

    public String getConfigKey() {
        return this.configKey;
    }

    public void setConfigKey(String configKey) {
        this.configKey = configKey;
    }

    public String getTagLocalName() {
        return "smooks";
    }

    public OMElement serialize(OMElement parent) {
        OMElement smooksEle = fac.createOMElement("smooks", synNS);
        SmooksMediator.saveTracingState((OMElement)smooksEle, (Mediator)this);
        if (this.configKey == null) {
            throw new MediatorException("config-key not specified");
        }
        smooksEle.addAttribute(fac.createOMAttribute("config-key", nullNS, this.configKey));
        smooksEle.addChild((OMNode)this.serializeInput());
        smooksEle.addChild((OMNode)this.serializeOutput());
        if (parent != null) {
            parent.addChild((OMNode)smooksEle);
        }
        return smooksEle;
    }

    public void build(OMElement elem) {
        OMAttribute key = elem.getAttribute(ATT_CONFIG_KEY);
        if (key == null) {
            String msg = "The 'config-key' attribute is required";
            throw new MediatorException(msg);
        }
        this.configKey = key.getAttributeValue();
        OMElement inputElement = elem.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "input"));
        if (inputElement != null) {
            this.processInput(inputElement);
        }
        OMElement outputElement = elem.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "output"));
        if (inputElement != null) {
            this.processOutput(outputElement);
        }
        this.processAuditStatus((Mediator)this, elem);
    }

    private void processInput(OMElement input) {
        OMAttribute typeAttr = input.getAttribute(new QName("type"));
        if (typeAttr != null) {
            String typeValue = typeAttr.getAttributeValue();
            this.setInputType(typeValue);
        }
        if (input.getAttribute(new QName("expression")) != null) {
            try {
                this.setInputExpression(SynapseXPathFactory.getSynapseXPath((OMElement)input, (QName)new QName("expression")));
            }
            catch (JaxenException jaxenException) {
                // empty catch block
            }
        }
    }

    private void processOutput(OMElement output) {
        OMAttribute propertyAttr;
        OMAttribute typeAttr = output.getAttribute(new QName("type"));
        if (typeAttr != null) {
            String typeValue = typeAttr.getAttributeValue();
            this.setOutputType(typeValue);
        }
        if (output.getAttribute(new QName("expression")) != null) {
            try {
                this.setOutputExpression(SynapseXPathFactory.getSynapseXPath((OMElement)output, (QName)new QName("expression")));
            }
            catch (JaxenException ignored) {
                // empty catch block
            }
            OMAttribute actionAttr = output.getAttribute(new QName("action"));
            if (actionAttr != null && actionAttr.getAttributeValue() != null) {
                this.setOutputAction(actionAttr.getAttributeValue());
            }
        }
        if ((propertyAttr = output.getAttribute(new QName("property"))) != null && propertyAttr.getAttributeValue() != null) {
            this.setOutputProperty(propertyAttr.getAttributeValue());
        }
    }

    private OMElement serializeInput() {
        OMElement inputElement = fac.createOMElement("input", synNS);
        inputElement.addAttribute(fac.createOMAttribute("type", nullNS, this.inputType));
        if (this.getInputExpression() != null) {
            SynapseXPathSerializer.serializeXPath((SynapseXPath)this.getInputExpression(), (OMElement)inputElement, (String)"expression");
        }
        return inputElement;
    }

    private OMElement serializeOutput() {
        OMElement outputElement = fac.createOMElement("output", synNS);
        outputElement.addAttribute(fac.createOMAttribute("type", nullNS, this.outputType));
        if (this.getOutputExpression() != null) {
            SynapseXPathSerializer.serializeXPath((SynapseXPath)this.getOutputExpression(), (OMElement)outputElement, (String)"expression");
            if (this.getOutputAction() != null) {
                outputElement.addAttribute(fac.createOMAttribute("action", nullNS, this.getOutputAction()));
            }
        } else if (this.getOutputProperty() != null) {
            outputElement.addAttribute(fac.createOMAttribute("property", nullNS, this.getOutputProperty()));
        }
        return outputElement;
    }

    public String getInputType() {
        return this.inputType;
    }

    public SynapseXPath getInputExpression() {
        return this.inputExpression;
    }

    public String getOutputType() {
        return this.outputType;
    }

    public SynapseXPath getOutputExpression() {
        return this.outputExpression;
    }

    public String getOutputProperty() {
        return this.outputProperty;
    }

    public String getOutputAction() {
        return this.outputAction;
    }

    public void setInputType(String inputType) {
        this.inputType = inputType;
    }

    public void setInputExpression(SynapseXPath inputExpression) {
        this.inputExpression = inputExpression;
    }

    public void setOutputType(String outputType) {
        this.outputType = outputType;
    }

    public void setOutputExpression(SynapseXPath outputExpression) {
        this.outputExpression = outputExpression;
    }

    public void setOutputProperty(String outputProperty) {
        this.outputProperty = outputProperty;
    }

    public void setOutputAction(String outputAction) {
        this.outputAction = outputAction;
    }
}

