/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediator.transform;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.Persistence;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.axis2.AxisFault;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseLog;
import org.apache.synapse.config.Entry;
import org.apache.synapse.config.SynapseConfigUtils;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.mediators.AbstractMediator;
import org.milyn.Smooks;
import org.milyn.container.ExecutionContext;
import org.milyn.payload.JavaResult;
import org.milyn.persistence.util.PersistenceUtil;
import org.milyn.scribe.adapter.jpa.EntityManagerRegister;
import org.milyn.scribe.register.DaoRegister;
import org.wso2.carbon.mediator.transform.Input;
import org.wso2.carbon.mediator.transform.Output;
import org.xml.sax.SAXException;

public class SmooksMediator
extends AbstractMediator {
    private Smooks smooks = null;
    private String configKey = null;
    private volatile Lock lock = new ReentrantLock();
    private Input input = null;
    private Output output = null;
    private String persistenceUnitName = null;
    private EntityTransaction transaction = null;
    private boolean transactionStarted = false;
    private EntityManagerFactory emf;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean mediate(MessageContext synCtx) {
        SynapseLog synLog;
        block16: {
            synLog = this.getLog(synCtx);
            if (synLog.isTraceOrDebugEnabled()) {
                synLog.traceOrDebug((Object)"Start : Smooks mediator");
                if (synLog.isTraceTraceEnabled()) {
                    synLog.traceTrace((Object)("Message : " + synCtx.getEnvelope()));
                }
            }
            this.lock.lock();
            try {
                if (this.isCreationOrRecreationRequired(synCtx.getConfiguration())) {
                    this.smooks = this.createSmooksConfig(synCtx);
                }
            }
            finally {
                this.lock.unlock();
            }
            StreamSource streamSource = this.input.process(synCtx, synLog);
            ExecutionContext executionContext = this.smooks.createExecutionContext();
            try {
                if (this.persistenceUnitName != null) {
                    this.startTransaction(synCtx, executionContext);
                }
                if (this.output.getType().equals((Object)TYPES.JAVA)) {
                    JavaResult result = new JavaResult();
                    this.smooks.filterSource(executionContext, (Source)streamSource, new Result[]{result});
                    this.output.process(null, synCtx, synLog, result);
                } else {
                    ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                    StreamResult streamResult = new StreamResult(outputStream);
                    this.smooks.filterSource(executionContext, (Source)streamSource, new Result[]{streamResult});
                    this.output.process(outputStream, synCtx, synLog, null);
                }
                if (this.transactionStarted) {
                    this.commitTransaction();
                    this.transactionStarted = false;
                }
            }
            catch (AxisFault e) {
                this.handleException("Error occured while processing smooks output", (Exception)((Object)e), synCtx);
            }
            catch (Exception e) {
                this.handleException("Error occured while processing transaction", e, synCtx);
                if (!this.transactionStarted) break block16;
                this.transaction.rollback();
            }
        }
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug((Object)"End : Smooks mediator");
            if (synLog.isTraceTraceEnabled()) {
                synLog.traceTrace((Object)("Message : " + synCtx.getEnvelope()));
            }
        }
        return true;
    }

    private void startTransaction(MessageContext synCtx, ExecutionContext executionContext) {
        if (this.emf == null) {
            this.emf = Persistence.createEntityManagerFactory((String)this.persistenceUnitName);
        }
        EntityManager em = this.emf.createEntityManager();
        PersistenceUtil.setDAORegister((ExecutionContext)executionContext, (DaoRegister)new EntityManagerRegister(em));
        this.transaction = em.getTransaction();
        this.transaction.begin();
        this.transactionStarted = true;
    }

    private void commitTransaction() {
        this.transaction.commit();
    }

    private Smooks createSmooksConfig(MessageContext synCtx) {
        InputStream in;
        SynapseLog log = this.getLog(synCtx);
        Object o = synCtx.getEntry(this.configKey);
        if (o == null) {
            this.handleException("Cannot find the object for smooks config key: " + this.configKey, synCtx);
        }
        if ((in = SynapseConfigUtils.getInputStream((Object)o)) == null) {
            this.handleException("Cannot get the input stream from the config key: " + this.configKey, synCtx);
        }
        try {
            Smooks smooks = new Smooks(in);
            if (log.isTraceOrDebugEnabled()) {
                log.traceOrDebug((Object)("Smooks configuration is created from the config key: " + this.configKey));
            }
            return smooks;
        }
        catch (IOException e) {
            this.handleException("I/O error occurred while creating the Smooks configuration from the config key: " + this.configKey, e, synCtx);
        }
        catch (SAXException e) {
            this.handleException("XML error occurred while creating the Smooks configuration from the config key: " + this.configKey, e, synCtx);
        }
        return null;
    }

    private boolean isCreationOrRecreationRequired(SynapseConfiguration synCfg) {
        boolean shouldRecreate;
        if (this.smooks == null) {
            return true;
        }
        Entry dp = synCfg.getEntryDefinition(this.configKey);
        boolean bl = shouldRecreate = dp != null && dp.isDynamic() && (!dp.isCached() || dp.isExpired());
        if (shouldRecreate) {
            this.smooks.close();
        }
        return shouldRecreate;
    }

    public String getConfigKey() {
        return this.configKey;
    }

    public void setConfigKey(String configKey) {
        this.configKey = configKey;
    }

    public Input getInput() {
        return this.input;
    }

    public Output getOutput() {
        return this.output;
    }

    public void setInput(Input input) {
        this.input = input;
    }

    public void setOutput(Output output) {
        this.output = output;
    }

    public void setPersistenceUnitAttr(String persistenceUnitName) {
        this.persistenceUnitName = persistenceUnitName;
    }

    public String getPersistenceUnitName() {
        return this.persistenceUnitName;
    }

    public static enum TYPES {
        TEXT,
        XML,
        JAVA;

    }
}

