/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediator.transform;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axis2.AxisFault;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.SynapseLog;
import org.apache.synapse.util.xpath.SynapseXPath;
import org.jaxen.JaxenException;
import org.milyn.payload.JavaResult;
import org.wso2.carbon.mediator.transform.SmooksMediator;

public class Output {
    public static final String ACTION_REPLACE = "replace";
    public static final String ACTION_ADD_CHILD = "child";
    public static final String ACTION_ADD_SIBLING = "sibling";
    public static final String AXIOMPAYLOADNS = "http://ws.apache.org/commons/ns/payload";
    public static final QName TEXTELT = new QName("http://ws.apache.org/commons/ns/payload", "text", "ax");
    private SmooksMediator.TYPES type = SmooksMediator.TYPES.XML;
    private SynapseXPath expression = null;
    private String property = null;
    private String action = null;

    public void process(ByteArrayOutputStream outputStream, MessageContext synCtx, SynapseLog synLog, JavaResult result) throws AxisFault {
        block27: {
            ByteArrayInputStream inputStream = null;
            if (outputStream != null && outputStream.size() > 0) {
                inputStream = new ByteArrayInputStream(outputStream.toByteArray());
            }
            if (inputStream != null && this.type == SmooksMediator.TYPES.XML) {
                try {
                    StAXOMBuilder builder = new StAXOMBuilder((InputStream)inputStream);
                    OMElement transformedElement = builder.getDocumentElement();
                    if (this.property != null) {
                        synCtx.setProperty(this.property, (Object)transformedElement);
                        break block27;
                    }
                    if (this.expression != null) {
                        Object targetObj = this.expression.selectSingleNode((Object)synCtx);
                        if (targetObj instanceof OMElement) {
                            OMElement targetElem = (OMElement)targetObj;
                            this.insertElement((OMNode)transformedElement, targetElem, synLog);
                        } else if (targetObj instanceof OMText) {
                            OMText targetText = (OMText)targetObj;
                            OMContainer targetParent = targetText.getParent();
                            if (targetParent instanceof OMElement) {
                                targetText.detach();
                                ((OMElement)targetParent).addChild((OMNode)transformedElement);
                            }
                        } else {
                            this.handleException("Invalid Target object to be enrich.", synLog);
                        }
                        break block27;
                    }
                    Output.setXMLPayload(synCtx, transformedElement);
                }
                catch (XMLStreamException e) {
                    this.handleException("Error creating the  parser form the result of smooks", synLog, e);
                }
                catch (JaxenException e) {
                    this.handleException("Error evaluating the Xpath expression: " + this.expression, synLog, (Exception)((Object)e));
                }
            } else if (inputStream != null && this.type == SmooksMediator.TYPES.TEXT) {
                if (this.expression != null) {
                    Object targetObj = null;
                    try {
                        targetObj = this.expression.selectSingleNode((Object)synCtx);
                    }
                    catch (JaxenException e) {
                        this.handleException("Error evaluating the XPath: " + this.expression, synLog, (Exception)((Object)e));
                    }
                    if (targetObj instanceof OMElement) {
                        ((OMElement)targetObj).setText(this.byteArrayIStoString(inputStream));
                    } else if (targetObj instanceof OMText) {
                        OMContainer parent;
                        OMText targetText = (OMText)targetObj;
                        if (targetText.getParent() != null && (parent = targetText.getParent()) instanceof OMElement) {
                            ((OMElement)parent).setText(this.byteArrayIStoString(inputStream));
                        }
                    } else {
                        this.handleException("Invalid Target object to be enrich.", synLog);
                    }
                } else if (this.property != null) {
                    synCtx.setProperty(this.property, (Object)this.byteArrayIStoString(inputStream));
                } else {
                    Output.setTextPayload(synCtx, this.byteArrayIStoString(inputStream));
                }
            } else if (this.type == SmooksMediator.TYPES.JAVA && this.property != null) {
                synCtx.setProperty(this.property, (Object)result);
            }
        }
    }

    public String byteArrayIStoString(ByteArrayInputStream is) {
        int size = is.available();
        char[] theChars = new char[size];
        byte[] bytes = new byte[size];
        is.read(bytes, 0, size);
        int i = 0;
        while (i < size) {
            theChars[i] = (char)(bytes[i++] & 0xFF);
        }
        return new String(theChars);
    }

    private void insertElement(OMNode source, OMElement e, SynapseLog synLog) {
        if (this.action.equals(ACTION_REPLACE)) {
            boolean isInserted = false;
            if (source instanceof OMElement) {
                e.insertSiblingAfter(source);
                isInserted = true;
            } else if (source instanceof OMText) {
                e.setText(((OMText)source).getText());
            } else {
                this.handleException("Invalid Source object to be inserted.", synLog);
            }
            if (isInserted) {
                e.detach();
            }
        } else if (this.action.equals(ACTION_ADD_CHILD)) {
            if (source instanceof OMElement) {
                e.addChild(source);
            }
        } else if (this.action.equals(ACTION_ADD_SIBLING) && source instanceof OMElement) {
            e.insertSiblingAfter(source);
        }
    }

    public SmooksMediator.TYPES getType() {
        return this.type;
    }

    public SynapseXPath getExpression() {
        return this.expression;
    }

    public String getProperty() {
        return this.property;
    }

    public String getAction() {
        return this.action;
    }

    public void setType(SmooksMediator.TYPES type) {
        this.type = type;
    }

    public void setExpression(SynapseXPath expression) {
        this.expression = expression;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public void setAction(String action) {
        this.action = action;
    }

    private void handleException(String message, SynapseLog log) {
        log.error((Object)message);
        throw new SynapseException(message);
    }

    private void handleException(String message, SynapseLog log, Exception e) {
        log.error((Object)message);
        throw new SynapseException(message, (Throwable)e);
    }

    public static void setXMLPayload(MessageContext synCtx, OMElement element) throws AxisFault {
        SOAPEnvelope envelope = synCtx.getEnvelope();
        SOAPEnvelope newElement = Output.getNewSOAPEnvelope(envelope);
        newElement.getBody().addChild((OMNode)element);
        synCtx.setEnvelope(newElement);
    }

    public static void setTextPayload(MessageContext synCtx, String text) throws AxisFault {
        SOAPEnvelope envelope = synCtx.getEnvelope();
        OMFactory fac = envelope.getOMFactory();
        OMElement textElt = envelope.getOMFactory().createOMElement(TEXTELT);
        OMText textNode = fac.createOMText(text);
        textElt.addChild((OMNode)textNode);
        Output.setXMLPayload(synCtx, textElt);
    }

    public static SOAPEnvelope getNewSOAPEnvelope(SOAPEnvelope envelope) {
        OMNamespace namespace = envelope.getNamespace();
        String nsURI = namespace.getNamespaceURI();
        SOAPFactory soapFactory = null;
        if (nsURI.equals("http://schemas.xmlsoap.org/soap/envelope/")) {
            soapFactory = OMAbstractFactory.getSOAP11Factory();
        } else if (nsURI.equals("http://www.w3.org/2003/05/soap-envelope")) {
            soapFactory = OMAbstractFactory.getSOAP12Factory();
        }
        if (soapFactory != null) {
            SOAPEnvelope new_envelope = soapFactory.createSOAPEnvelope();
            SOAPHeader header = envelope.getHeader();
            if (header != null) {
                soapFactory.createSOAPHeader(new_envelope);
                SOAPHeader new_header = new_envelope.getHeader();
                Iterator itr = header.getChildElements();
                while (itr.hasNext()) {
                    OMElement element = (OMElement)itr.next();
                    new_header.addChild((OMNode)element);
                }
            }
            soapFactory.createSOAPBody(new_envelope);
            return new_envelope;
        }
        return null;
    }
}

