/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.ant;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.resources.FileResource;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.milyn.ResourceMerger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceMergerTask
extends Task {
    private String jarName;
    private List<String> resourcesPaths = new ArrayList<String>();
    private List<String> classes = new ArrayList<String>();
    private FileSet fileSet;
    private boolean overwrite;
    private File manifest;

    public void execute() throws BuildException {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            this.mergeJars();
        }
        catch (IOException e) {
            throw new BuildException(e.getMessage(), (Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    private void mergeJars() throws IOException {
        this.log("Building " + this.jarName);
        List<File> jars = this.getJarsFromFileSet();
        ResourceMerger resourceMerger = new ResourceMerger(this.resourcesPaths);
        Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        JavaArchive mergedJar = resourceMerger.mergeJars(this.jarName, ResourceMerger.fromFiles(jars));
        mergedJar.setManifest(this.manifest);
        this.addAllClasses(mergedJar);
        File newJar = this.exportJarFile(mergedJar, this.jarName);
        this.log("Produced [" + newJar.getAbsolutePath());
    }

    private File exportJarFile(JavaArchive jar, String jarname) {
        File newJar = new File(this.jarName);
        if (newJar.exists()) {
            newJar.delete();
        }
        ((ZipExporter)jar.as(ZipExporter.class)).exportZip(newJar, this.overwrite);
        return newJar;
    }

    private List<File> getJarsFromFileSet() {
        ArrayList<File> jars = new ArrayList<File>();
        Iterator iterator = this.fileSet.iterator();
        while (iterator.hasNext()) {
            jars.add(((FileResource)iterator.next()).getFile());
        }
        return jars;
    }

    private void addAllClasses(JavaArchive to) {
        for (String className : this.classes) {
            to.addClass(className.trim());
        }
    }

    public void addFileSet(FileSet jars) {
        this.fileSet = jars;
    }

    public void setJarName(String jarName) {
        this.jarName = jarName;
    }

    public void setResources(String resources) {
        String[] split;
        for (String resource : split = resources.split(",")) {
            this.resourcesPaths.add(resource.trim());
        }
    }

    public void setManifest(File manifest) {
        this.manifest = manifest;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public void setClasses(String classes) {
        String[] split = classes.split(",");
        this.classes.addAll(Arrays.asList(split));
    }
}

