/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediator.script;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.llom.OMTextImpl;
import org.apache.synapse.config.xml.ValueFactory;
import org.apache.synapse.config.xml.ValueSerializer;
import org.apache.synapse.mediators.Value;
import org.wso2.carbon.mediator.service.MediatorException;
import org.wso2.carbon.mediator.service.ui.AbstractMediator;
import org.wso2.carbon.mediator.service.ui.Mediator;

public class ScriptMediator
extends AbstractMediator {
    private static final QName INCLUDE_Q = new QName("http://ws.apache.org/ns/synapse", "include");
    private Value key;
    private String language;
    private Map<String, Object> includes = new TreeMap<String, Object>();
    private String function = "";
    private String scriptSourceCode;

    public String getLanguage() {
        return this.language;
    }

    public Value getKey() {
        return this.key;
    }

    public String getFunction() {
        return this.function;
    }

    public String getScriptSrc() {
        return this.scriptSourceCode;
    }

    public String getTagLocalName() {
        return "script";
    }

    public String getScriptSourceCode() {
        return this.scriptSourceCode;
    }

    public Map<String, Object> getIncludes() {
        return this.includes;
    }

    public void setIncludes(Map<String, Object> includes) {
        this.includes = includes;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public void setFunction(String function) {
        this.function = function;
    }

    public void setScriptSourceCode(String scriptSourceCode) {
        this.scriptSourceCode = scriptSourceCode;
    }

    public void setKey(Value key) {
        this.key = key;
    }

    public OMElement serialize(OMElement parent) {
        OMElement script = fac.createOMElement("script", synNS);
        if (this.key != null) {
            script.addAttribute(fac.createOMAttribute("language", nullNS, this.language));
            ValueSerializer keySerializer = new ValueSerializer();
            keySerializer.serializeValue(this.key, "key", script);
            if (!this.function.equals("mediate")) {
                script.addAttribute(fac.createOMAttribute("function", nullNS, this.function));
            }
        } else {
            script.addAttribute(fac.createOMAttribute("language", nullNS, this.language));
            OMTextImpl textData = (OMTextImpl)fac.createOMText(this.scriptSourceCode.trim());
            textData.setType(12);
            script.addChild((OMNode)textData);
        }
        Map<String, Object> includeMap = this.includes;
        for (String includeKey : includeMap.keySet()) {
            if (includeKey == null || includeKey.length() == 0) continue;
            OMElement includeKeyElement = fac.createOMElement("include", synNS);
            includeKeyElement.addAttribute(fac.createOMAttribute("key", nullNS, includeKey));
            script.addChild((OMNode)includeKeyElement);
        }
        ScriptMediator.saveTracingState((OMElement)script, (Mediator)this);
        if (parent != null) {
            parent.addChild((OMNode)script);
        }
        return script;
    }

    public void build(OMElement elem) {
        this.includes.clear();
        OMAttribute keyAtt = elem.getAttribute(new QName("", "key"));
        OMAttribute langAtt = elem.getAttribute(new QName("", "language"));
        OMAttribute funcAtt = elem.getAttribute(new QName("", "function"));
        if (langAtt == null) {
            throw new MediatorException("The 'language' attribute is required for a script mediator");
        }
        if (keyAtt == null && funcAtt != null) {
            throw new MediatorException("Cannot use 'function' attribute without 'key' attribute for a script mediator");
        }
        this.getIncludeKeysMap(elem);
        if (keyAtt != null) {
            String functionName = funcAtt == null ? null : funcAtt.getAttributeValue();
            this.language = langAtt.getAttributeValue();
            this.function = functionName;
            ValueFactory keyFactory = new ValueFactory();
            this.key = keyFactory.createValue("key", elem);
        } else {
            this.language = langAtt.getAttributeValue();
            this.scriptSourceCode = elem.getText();
        }
        this.processAuditStatus((Mediator)this, elem);
    }

    private void getIncludeKeysMap(OMElement elem) {
        Iterator iter = elem.getChildrenWithName(INCLUDE_Q);
        while (iter.hasNext()) {
            OMElement includeElem = (OMElement)iter.next();
            OMAttribute key = includeElem.getAttribute(new QName("", "key"));
            if (key == null) {
                throw new MediatorException("Cannot use 'include' element without 'key' attribute for a script mediator");
            }
            String keyText = key.getAttributeValue();
            this.includes.put(keyText, null);
        }
    }
}

