/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediators.router.impl;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.SynapseLog;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.mediators.eip.Target;
import org.apache.synapse.util.xpath.SynapseXPath;
import org.jaxen.JaxenException;

public class Route {
    public static final int ROUTE_NOT_MACHING_STATE = 0;
    public static final int ROUTED_WITH_BREAK_STATE = 1;
    public static final int ROUTED_WITH_CONTINUE_STATE = 2;
    public static final int ROUTED_AND_DROPPED_STATE = 3;
    public static final int UNEXPECTED_ROUTING_STATE = 4;
    private SynapseXPath expression;
    private Pattern match;
    private boolean breakRouter = true;
    private Target target;
    private static final Log log = LogFactory.getLog(Route.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isMatching(MessageContext synCtx, SynapseLog synLog) {
        if (this.expression == null) {
            this.handleException("Couldn't find the routing expression", synCtx);
            return false;
        }
        if (this.match == null) {
            try {
                return this.expression.booleanValueOf((Object)synCtx.getEnvelope());
            }
            catch (JaxenException e) {
                this.handleException("Error evaluating XPath expression : " + this.expression, (Exception)((Object)e), synCtx);
                return false;
            }
        }
        String sourceString = this.expression.stringValueOf(synCtx);
        if (sourceString == null) {
            if (!synLog.isTraceOrDebugEnabled()) return false;
            synLog.traceOrDebug((Object)("Source String : " + this.expression + " evaluates to null"));
            return false;
        }
        Matcher matcher = this.match.matcher(sourceString);
        if (matcher != null) return matcher.matches();
        if (!synLog.isTraceTraceEnabled()) return false;
        synLog.traceOrDebug((Object)("Regex pattern matcher for : " + this.match.pattern() + "against source : " + sourceString + " is null"));
        return false;
    }

    public int doRoute(MessageContext synCtx, SynapseLog synLog) {
        if (this.isMatching(synCtx, synLog)) {
            if (this.target != null) {
                boolean mediationResult = true;
                this.target.setAsynchronous(false);
                this.target.mediate(synCtx);
                return this.breakRouter ? 1 : 2;
            }
        } else {
            return 0;
        }
        this.handleException("Couldn't find the route target for the message", synCtx);
        return 4;
    }

    private void sendToEndpoint(MessageContext synCtx) {
        Endpoint epr;
        if (this.target.getEndpoint() != null) {
            this.target.getEndpoint().send(synCtx);
        } else if (this.target.getEndpointRef() != null && (epr = synCtx.getConfiguration().getEndpoint(this.target.getEndpointRef())) != null) {
            epr.send(synCtx);
        }
    }

    public Pattern getMatch() {
        return this.match;
    }

    public void setMatch(Pattern match) {
        this.match = match;
    }

    public SynapseXPath getExpression() {
        return this.expression;
    }

    public void setExpression(SynapseXPath expression) {
        this.expression = expression;
    }

    public boolean isBreakRouter() {
        return this.breakRouter;
    }

    public void setBreakRouter(boolean breakRouter) {
        this.breakRouter = breakRouter;
    }

    public Target getTarget() {
        return this.target;
    }

    public void setTarget(Target target) {
        this.target = target;
    }

    private void handleException(String msg, Exception e, MessageContext msgContext) {
        log.error((Object)msg, (Throwable)e);
        if (msgContext.getServiceLog() != null) {
            msgContext.getServiceLog().error((Object)msg, (Throwable)e);
        }
        throw new SynapseException(msg, (Throwable)e);
    }

    private void handleException(String msg, MessageContext msgContext) {
        log.error((Object)msg);
        if (msgContext.getServiceLog() != null) {
            msgContext.getServiceLog().error((Object)msg);
        }
        throw new SynapseException(msg);
    }
}

