/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediator.rmsequence;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.xml.SynapseXPathFactory;
import org.apache.synapse.config.xml.SynapseXPathSerializer;
import org.apache.synapse.util.xpath.SynapseXPath;
import org.jaxen.JaxenException;
import org.wso2.carbon.mediator.service.MediatorException;
import org.wso2.carbon.mediator.service.ui.AbstractMediator;
import org.wso2.carbon.mediator.service.ui.Mediator;

public class RMSequenceMediator
extends AbstractMediator {
    private static final QName ATT_CORR = new QName("correlation");
    private static final QName ATT_LASTMSG = new QName("last-message");
    private static final QName ATT_VERSION = new QName("version");
    private static final QName ATT_SINGLE = new QName("single");
    private SynapseXPath correlation = null;
    private SynapseXPath lastMessage = null;
    private Boolean single = null;
    private String version = null;

    public String getTagLocalName() {
        return "RMSequence";
    }

    public OMElement serialize(OMElement parent) {
        OMElement sequence = fac.createOMElement("RMSequence", synNS);
        RMSequenceMediator.saveTracingState((OMElement)sequence, (Mediator)this);
        if (this.single.booleanValue() && this.correlation != null) {
            throw new MediatorException("Invalid RMSequence mediator. A RMSequence can't have both a single attribute value of true and a correlation attribute specified.");
        }
        if (this.single.booleanValue() && this.lastMessage != null) {
            throw new MediatorException("Invalid RMSequence mediator. A RMSequence can't have both a single attribute value of true and a last-message attribute specified.");
        }
        if (this.single.booleanValue()) {
            sequence.addAttribute(fac.createOMAttribute("single", nullNS, String.valueOf(this.single)));
        } else if (this.correlation != null) {
            SynapseXPathSerializer.serializeXPath((SynapseXPath)this.correlation, (OMElement)sequence, (String)"correlation");
        } else {
            throw new MediatorException("Invalid RMSequence mediator. Specify a single message sequence or a correlation attribute.");
        }
        if (this.lastMessage != null) {
            SynapseXPathSerializer.serializeXPath((SynapseXPath)this.lastMessage, (OMElement)sequence, (String)"last-message");
        }
        if (this.version != null) {
            sequence.addAttribute(fac.createOMAttribute("version", nullNS, this.version));
        }
        if (parent != null) {
            parent.addChild((OMNode)sequence);
        }
        return sequence;
    }

    public void build(OMElement elem) {
        OMAttribute correlation = elem.getAttribute(ATT_CORR);
        OMAttribute lastMessage = elem.getAttribute(ATT_LASTMSG);
        OMAttribute single = elem.getAttribute(ATT_SINGLE);
        OMAttribute version = elem.getAttribute(ATT_VERSION);
        if (single == null && correlation == null) {
            String msg = "The 'single' attribute value of true or a 'correlation' attribute is required for the configuration of a RMSequence mediator";
            throw new MediatorException(msg);
        }
        if (correlation != null) {
            if (correlation.getAttributeValue() != null && correlation.getAttributeValue().trim().length() == 0) {
                String msg = "Invalid attribute value specified for correlation";
                throw new MediatorException(msg);
            }
            try {
                this.correlation = SynapseXPathFactory.getSynapseXPath((OMElement)elem, (QName)ATT_CORR);
                this.single = false;
            }
            catch (JaxenException e) {
                String msg = "Invalid XPath expression for attribute correlation : " + correlation.getAttributeValue();
                throw new MediatorException(msg);
            }
        }
        if (single != null) {
            this.single = Boolean.valueOf(single.getAttributeValue());
        }
        if (this.single.booleanValue() && this.correlation != null) {
            String msg = "Invalid RMSequence mediator. A RMSequence can't have both a single attribute value of true and a correlation attribute specified.";
            throw new MediatorException(msg);
        }
        if (!this.single.booleanValue() && correlation == null) {
            String msg = "Invalid RMSequence mediator. A RMSequence must have a single attribute value of true or a correlation attribute specified.";
            throw new SynapseException(msg);
        }
        if (lastMessage != null) {
            if (lastMessage.getAttributeValue() != null && lastMessage.getAttributeValue().trim().length() == 0) {
                String msg = "Invalid attribute value specified for last-message";
                throw new MediatorException(msg);
            }
            try {
                this.lastMessage = SynapseXPathFactory.getSynapseXPath((OMElement)elem, (QName)ATT_LASTMSG);
            }
            catch (JaxenException e) {
                String msg = "Invalid XPath expression for attribute last-message : " + lastMessage.getAttributeValue();
                throw new MediatorException(msg);
            }
        }
        if (this.single.booleanValue() && this.lastMessage != null) {
            String msg = "Invalid RMSequence mediator. A RMSequence can't have both a single attribute value of true and a last-message attribute specified.";
            throw new SynapseException(msg);
        }
        if (version != null) {
            if (!"1.0".equals(version.getAttributeValue()) && !"1.1".equals(version.getAttributeValue())) {
                String msg = "Only '1.0' or '1.1' values are allowed for attribute version for a RMSequence mediator, Unsupported version " + version.getAttributeValue();
                throw new MediatorException(msg);
            }
            this.version = version.getAttributeValue();
        }
        this.processAuditStatus((Mediator)this, elem);
    }

    public boolean isSingle() {
        return this.getSingle() != null && this.getSingle() != false;
    }

    public SynapseXPath getCorrelation() {
        return this.correlation;
    }

    public void setCorrelation(SynapseXPath correlation) {
        this.correlation = correlation;
    }

    public SynapseXPath getLastMessage() {
        return this.lastMessage;
    }

    public void setLastMessage(SynapseXPath lastMessage) {
        this.lastMessage = lastMessage;
    }

    public Boolean getSingle() {
        return this.single;
    }

    public void setSingle(Boolean single) {
        this.single = single;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }
}

