/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediator.fault.ui.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.llom.util.AXIOMUtil;
import org.wso2.carbon.mediator.fault.FaultMediator;
import org.wso2.carbon.sequences.ui.util.ns.XPathFactory;

public class FaultUtil {
    public static void populateFautlMediator(HttpServletRequest request, HttpSession session, FaultMediator faultMediator) {
        FaultUtil.populateSoapVersion(request, faultMediator);
        if (1 == faultMediator.getSoapVersion()) {
            FaultUtil.populateFaultCode(request, faultMediator);
            FaultUtil.populateFaultString(request, session, faultMediator);
            FaultUtil.populateFaultActor(request, faultMediator);
            FaultUtil.populateFaultDetail(request, faultMediator);
        } else if (2 == faultMediator.getSoapVersion()) {
            FaultUtil.populateFaultCode(request, faultMediator);
            FaultUtil.populateFaultReason(request, session, faultMediator);
            FaultUtil.populateRole(request, faultMediator);
            FaultUtil.populateNode(request, faultMediator);
            FaultUtil.populateFaultDetail(request, faultMediator);
        }
    }

    private static void populateSoapVersion(HttpServletRequest request, FaultMediator faultMediator) {
        faultMediator.setSoapVersion(Integer.parseInt(request.getParameter("soap_version")));
    }

    private static void populateFaultCode(HttpServletRequest request, FaultMediator faultMediator) {
        String prefix;
        String faultCode;
        String namespace;
        if (faultMediator.getSoapVersion() == 2) {
            namespace = "http://www.w3.org/2003/05/soap-envelope";
            faultCode = request.getParameter("fault_code2");
            prefix = "soap12Env";
        } else {
            namespace = "http://schemas.xmlsoap.org/soap/envelope/";
            faultCode = request.getParameter("fault_code1");
            prefix = "soap11Env";
        }
        faultMediator.setFaultCodeValue(new QName(namespace, faultCode, prefix));
    }

    private static void populateFaultString(HttpServletRequest request, HttpSession session, FaultMediator faultMediator) {
        String faultStringType = request.getParameter("fault_string");
        if ("value".equals(faultStringType)) {
            String faultString = request.getParameter("name_space");
            faultMediator.setFaultReasonValue(faultString);
            faultMediator.setFaultReasonExpr(null);
        } else if ("expression".equals(faultStringType)) {
            XPathFactory xPathFactory = XPathFactory.getInstance();
            faultMediator.setFaultReasonExpr(xPathFactory.createSynapseXPath("name_space", request, session));
            faultMediator.setFaultReasonValue(null);
        }
    }

    private static void populateFaultReason(HttpServletRequest request, HttpSession session, FaultMediator faultMediator) {
        String faultStringType = request.getParameter("fault_string");
        if ("value".equals(faultStringType)) {
            String faultString = request.getParameter("name_space");
            faultMediator.setFaultReasonValue(faultString);
            faultMediator.setFaultReasonExpr(null);
        } else if ("expression".equals(faultStringType)) {
            XPathFactory xPathFactory = XPathFactory.getInstance();
            faultMediator.setFaultReasonExpr(xPathFactory.createSynapseXPath("name_space", request, session));
            faultMediator.setFaultReasonValue(null);
        }
    }

    private static void populateFaultActor(HttpServletRequest request, FaultMediator faultMediator) {
        try {
            if (request.getParameter("fault_actor") != null) {
                URI faultActor = new URI(request.getParameter("fault_actor"));
                faultMediator.setFaultRole(faultActor);
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
    }

    private static void populateFaultDetail(HttpServletRequest request, FaultMediator faultMediator) {
        String faultDetail = request.getParameter("detail");
        faultDetail = faultDetail.trim();
        faultMediator.setFaultDetail(null);
        faultMediator.getFaultDetailElements().clear();
        faultMediator.setFaultDetailExpr(null);
        if (!faultDetail.equals("")) {
            faultDetail = faultDetail.trim();
            try {
                OMElement element = AXIOMUtil.stringToOM((String)faultDetail);
                if (element.getChildElements().hasNext()) {
                    Iterator it = element.getChildElements();
                    while (it.hasNext()) {
                        faultMediator.addFaultDetailElement((OMElement)it.next());
                    }
                } else if (element.getText() != null) {
                    faultMediator.setFaultDetail(element.getText());
                }
            }
            catch (Exception e) {
                faultMediator.setFaultDetail(faultDetail);
            }
        }
    }

    private static void populateRole(HttpServletRequest request, FaultMediator faultMediator) {
        try {
            if (request.getParameter("fault_actor") != null) {
                URI faultActor = new URI(request.getParameter("fault_actor"));
                faultMediator.setFaultRole(faultActor);
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
    }

    private static void populateNode(HttpServletRequest request, FaultMediator faultMediator) {
        try {
            if (request.getParameter("node") != null) {
                URI faultActor = new URI(request.getParameter("node"));
                faultMediator.setFaultNode(faultActor);
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
    }

    public static String repalceDoubleQuotation(String in) {
        return in.replaceAll("\"", "'");
    }
}

