/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediator.enqueue;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.wso2.carbon.mediator.service.MediatorException;
import org.wso2.carbon.mediator.service.ui.AbstractMediator;
import org.wso2.carbon.mediator.service.ui.Mediator;

public class EnqueueMediator
extends AbstractMediator {
    private String executor;
    private int priority = 0;
    private String sequence;

    public String getExecutor() {
        return this.executor;
    }

    public int getPriority() {
        return this.priority;
    }

    public String getSequence() {
        return this.sequence;
    }

    public void setExecutor(String executor) {
        this.executor = executor;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public void setSequence(String sequence) {
        this.sequence = sequence;
    }

    public OMElement serialize(OMElement parent) {
        OMElement enqueue = fac.createOMElement("enqueue", synNS);
        EnqueueMediator.saveTracingState((OMElement)enqueue, (Mediator)this);
        if (this.executor == null) {
            throw new MediatorException("executor not specified");
        }
        enqueue.addAttribute(fac.createOMAttribute("executor", nullNS, this.executor));
        enqueue.addAttribute(fac.createOMAttribute("priority", nullNS, Integer.toString(this.priority)));
        if (this.sequence == null) {
            throw new MediatorException("sequence not specified");
        }
        enqueue.addAttribute(fac.createOMAttribute("sequence", nullNS, this.sequence));
        if (parent != null) {
            parent.addChild((OMNode)enqueue);
        }
        return enqueue;
    }

    public void build(OMElement elem) {
        OMAttribute sequence = elem.getAttribute(new QName("sequence"));
        OMAttribute priority = elem.getAttribute(new QName("priority"));
        OMAttribute executor = elem.getAttribute(new QName("executor"));
        if (sequence == null) {
            String msg = "The 'sequence' attribute is required for the configuration of a enqueue mediator";
            throw new MediatorException(msg);
        }
        this.sequence = sequence.getAttributeValue();
        if (priority == null) {
            String msg = "The 'priority' attribute is required for the configuration of a enqueue mediator";
            throw new MediatorException(msg);
        }
        this.priority = Integer.parseInt(priority.getAttributeValue());
        if (executor == null) {
            String msg = "The 'executor' attribute is required for the configuration of a enqueue mediator";
            throw new MediatorException(msg);
        }
        this.executor = executor.getAttributeValue();
        this.processAuditStatus((Mediator)this, elem);
    }

    public String getTagLocalName() {
        return "enqueue";
    }
}

