/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediator.conditionalrouter;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.synapse.commons.evaluators.Evaluator;
import org.apache.synapse.commons.evaluators.EvaluatorException;
import org.apache.synapse.commons.evaluators.config.EvaluatorFactoryFinder;
import org.apache.synapse.commons.evaluators.config.EvaluatorSerializer;
import org.apache.synapse.commons.evaluators.config.EvaluatorSerializerFinder;
import org.wso2.carbon.mediator.service.ui.AbstractListMediator;

public class ConditionalRouteMediator
extends AbstractListMediator {
    private boolean breakAfter = false;
    private boolean isAsynchronous = false;
    private Evaluator evaluator;
    private String targetSeq;
    private static final String ROUTE = "conditionalRoute";
    private static final String CONDITION = "condition";
    private static final String TARGET = "target";
    private static final String BREAK_ROUTE = "breakRoute";
    private static final String ASYNCHRONOUS = "asynchronous";
    private static final String TARGET_SEQ = "sequence";
    public static final QName BREAK_AFTER_Q = new QName("breakRoute");
    public static final QName ASYNCHRONOUS_Q = new QName("asynchronous");
    public static final QName CONDITION_Q = new QName("http://ws.apache.org/ns/synapse", "condition");
    public static final QName TARGET_Q = new QName("http://ws.apache.org/ns/synapse", "target");
    private static final QName SEQUENCE_Q = new QName("sequence");

    public OMElement serialize(OMElement parent) {
        EvaluatorSerializer evaluatorSerializer;
        OMElement routeElem = fac.createOMElement(ROUTE, synNS);
        if (this.evaluator != null && (evaluatorSerializer = EvaluatorSerializerFinder.getInstance().getSerializer(this.evaluator.getName())) != null) {
            OMElement conditionElem = fac.createOMElement(CONDITION, synNS);
            try {
                evaluatorSerializer.serialize(conditionElem, this.evaluator);
            }
            catch (EvaluatorException ee) {
                // empty catch block
            }
            routeElem.addChild((OMNode)conditionElem);
        }
        if (String.valueOf(this.breakAfter) != null) {
            routeElem.addAttribute(BREAK_ROUTE, String.valueOf(this.breakAfter), null);
        }
        if (String.valueOf(this.isAsynchronous) != null) {
            routeElem.addAttribute(ASYNCHRONOUS, String.valueOf(this.isAsynchronous), null);
        }
        if (this.targetSeq != null) {
            OMElement targetElem = fac.createOMElement(TARGET, synNS);
            targetElem.addAttribute(TARGET_SEQ, this.targetSeq, null);
            routeElem.addChild((OMNode)targetElem);
        }
        if (parent != null) {
            parent.addChild((OMNode)routeElem);
        }
        return routeElem;
    }

    public String getConditionString() {
        String conditionStr = "";
        EvaluatorSerializer evaluatorSerializer = EvaluatorSerializerFinder.getInstance().getSerializer(this.evaluator.getName());
        if (evaluatorSerializer != null) {
            OMElement conditionElem = fac.createOMElement(CONDITION, synNS);
            try {
                evaluatorSerializer.serialize(conditionElem, this.evaluator);
            }
            catch (EvaluatorException ee) {
                // empty catch block
            }
            conditionStr = conditionElem.toString();
        }
        return conditionStr;
    }

    public void build(OMElement omElement) {
        OMAttribute targetSeqAttr;
        OMElement targetElem;
        OMElement conditionElem;
        OMAttribute breakAfterAttr = omElement.getAttribute(BREAK_AFTER_Q);
        OMAttribute asynchronousAttr = omElement.getAttribute(ASYNCHRONOUS_Q);
        if (breakAfterAttr != null && breakAfterAttr.getAttributeValue() != null) {
            this.breakAfter = Boolean.parseBoolean(breakAfterAttr.getAttributeValue());
        }
        if (asynchronousAttr != null && asynchronousAttr.getAttributeValue() != null) {
            this.isAsynchronous = Boolean.parseBoolean(asynchronousAttr.getAttributeValue());
        }
        if ((conditionElem = omElement.getFirstChildWithName(CONDITION_Q)) != null) {
            try {
                this.evaluator = EvaluatorFactoryFinder.getInstance().getEvaluator(conditionElem.getFirstElement());
            }
            catch (EvaluatorException ee) {
                // empty catch block
            }
        }
        if ((targetElem = omElement.getFirstChildWithName(TARGET_Q)) != null && (targetSeqAttr = targetElem.getAttribute(SEQUENCE_Q)) != null && targetSeqAttr.getAttributeValue() != null) {
            this.targetSeq = targetSeqAttr.getAttributeValue();
        }
    }

    public String getTagLocalName() {
        return ROUTE;
    }

    public boolean isBreakAfter() {
        return this.breakAfter;
    }

    public void setBreakAfter(boolean breakAfter) {
        this.breakAfter = breakAfter;
    }

    public boolean isAsynchronous() {
        return this.isAsynchronous;
    }

    public void setAsynchronous(boolean asynchronous) {
        this.isAsynchronous = asynchronous;
    }

    public Evaluator getEvaluator() {
        return this.evaluator;
    }

    public void setEvaluator(Evaluator evaluator) {
        this.evaluator = evaluator;
    }

    public void setEvaluator(OMElement evaluatorElem) throws EvaluatorException {
        this.evaluator = EvaluatorFactoryFinder.getInstance().getEvaluator(evaluatorElem.getFirstElement());
    }

    public String getTargetSeq() {
        return this.targetSeq;
    }

    public void setTargetSeq(String targetSeq) {
        this.targetSeq = targetSeq;
    }
}

