/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediator.calltemplate.client;

import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Iterator;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.wso2.carbon.mediation.templates.stub.types.TemplateAdminServiceStub;
import org.wso2.carbon.mediation.templates.stub.types.common.TemplateInfo;
import org.wso2.carbon.mediator.calltemplate.client.CallTemplateUIException;
import org.wso2.carbon.ui.CarbonUIUtil;

public class TemplateAdminClient {
    public static final QName PARAMETER_Q = new QName("http://ws.apache.org/ns/synapse", "parameter");
    public static final QName NAME_Q = new QName("name");
    private TemplateAdminServiceStub templateAdminStub;

    public TemplateAdminClient(ServletConfig config, HttpSession session) throws AxisFault {
        String backendServerURL = CarbonUIUtil.getServerURL((ServletContext)config.getServletContext(), (HttpSession)session);
        ConfigurationContext configContext = (ConfigurationContext)config.getServletContext().getAttribute("ConfigurationContext");
        String cookie = (String)session.getAttribute("wso2carbon.admin.service.cookie");
        String serviceURL = backendServerURL + "TemplateAdminService";
        this.templateAdminStub = new TemplateAdminServiceStub(configContext, serviceURL);
        ServiceClient client = this.templateAdminStub._getServiceClient();
        Options option = client.getOptions();
        option.setManageSession(true);
        option.setProperty("Cookie", (Object)cookie);
    }

    public String[] getAllTempalateNames() throws CallTemplateUIException {
        String[] staticTemplateNames = new String[]{};
        String[] dynamicTemplateNames = new String[]{};
        try {
            staticTemplateNames = this.getStaticTemplateNames();
        }
        catch (Exception e) {
            this.handleException("CallTemplateUI Couldn't retrieve info on static Template Names ", e);
        }
        try {
            dynamicTemplateNames = this.getDynamicTemplateNames();
        }
        catch (Exception e) {
            this.handleException("CallTemplateUI Couldn't retrieve info on dynamic Tempalate Names ", e);
        }
        return TemplateAdminClient.merge(staticTemplateNames, dynamicTemplateNames);
    }

    public String getParameterStringForTemplate(String tempalteName) throws CallTemplateUIException {
        OMElement mediatorElement = null;
        try {
            mediatorElement = this.templateAdminStub.getTemplate(tempalteName).getFirstElement();
        }
        catch (Exception e) {
            this.handleException("CallTemplateUI Couldn't retrieve the template element with name '" + tempalteName + "'", e);
        }
        if (mediatorElement != null) {
            return TemplateAdminClient.getTempalateParamsString(mediatorElement);
        }
        try {
            mediatorElement = this.templateAdminStub.getDynamicTemplate(tempalteName).getFirstElement();
        }
        catch (Exception e) {
            this.handleException("CallTemplateUI Couldn't retrieve the template element with name '" + tempalteName + "'", e);
        }
        return TemplateAdminClient.getTempalateParamsString(mediatorElement);
    }

    private static String getTempalateParamsString(OMElement templateElem) {
        Iterator subElements = templateElem.getChildElements();
        String templateParamsStr = "";
        while (subElements.hasNext()) {
            OMAttribute paramNameAttr;
            OMElement child = (OMElement)subElements.next();
            if (!child.getQName().equals(PARAMETER_Q) || (paramNameAttr = child.getAttribute(NAME_Q)) == null) continue;
            templateParamsStr = templateParamsStr + paramNameAttr.getAttributeValue() + ";";
        }
        return templateParamsStr;
    }

    private static String[] merge(String[] first, String[] second) {
        String[] result = Arrays.copyOf(first, first.length + second.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    private String[] getStaticTemplateNames() throws RemoteException {
        String[] staticTemplateNames;
        int staticTemplateCount = this.templateAdminStub.getTemplatesCount();
        TemplateInfo[] temp1 = this.templateAdminStub.getTemplates(0, staticTemplateCount);
        if (temp1 == null || temp1.length == 0 || temp1[0] == null) {
            staticTemplateNames = new String[]{};
        } else {
            staticTemplateNames = new String[temp1.length];
            int i = 0;
            for (TemplateInfo templateInfo : temp1) {
                staticTemplateNames[i] = templateInfo.getName();
                ++i;
            }
        }
        return staticTemplateNames;
    }

    private String[] getDynamicTemplateNames() throws RemoteException {
        String[] dynamicTemplateNames;
        int dynamicTemplateCount = this.templateAdminStub.getDynamicTemplateCount();
        TemplateInfo[] temp1 = this.templateAdminStub.getDynamicTemplates(0, dynamicTemplateCount);
        if (temp1 == null || temp1.length == 0 || temp1[0] == null) {
            dynamicTemplateNames = new String[]{};
        } else {
            dynamicTemplateNames = new String[temp1.length];
            int i = 0;
            for (TemplateInfo templateInfo : temp1) {
                dynamicTemplateNames[i] = templateInfo.getName();
                ++i;
            }
        }
        return dynamicTemplateNames;
    }

    private void handleException(String message, Throwable e) throws CallTemplateUIException {
        throw new CallTemplateUIException(message, e);
    }
}

