/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediator.cache;

import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.wso2.caching.CachingConstants;
import org.wso2.carbon.mediator.service.MediatorException;
import org.wso2.carbon.mediator.service.ui.AbstractListMediator;
import org.wso2.carbon.mediator.service.ui.ListMediator;
import org.wso2.carbon.mediator.service.ui.Mediator;

public class CacheMediator
extends AbstractListMediator {
    private static final QName ATT_ID = new QName("id");
    private static final QName ATT_COLLECTOR = new QName("collector");
    private static final QName ATT_HASH_GENERATOR = new QName("hashGenerator");
    private static final QName ATT_MAX_MSG_SIZE = new QName("maxMessageSize");
    private static final QName ATT_TIMEOUT = new QName("timeout");
    private static final QName ATT_SCOPE = new QName("scope");
    private static final QName ATT_SEQUENCE = new QName("sequence");
    private static final QName ATT_TYPE = new QName("type");
    private static final QName ATT_SIZE = new QName("maxSize");
    private static final QName ON_CACHE_HIT_Q = new QName("http://ws.apache.org/ns/synapse", "onCacheHit");
    private static final QName IMPLEMENTATION_Q = new QName("http://ws.apache.org/ns/synapse", "implementation");
    private static final long DEFAULT_TIMEOUT = 5000L;
    private static final int DEFAULT_DISK_CACHE_SIZE = 200;
    private String id = null;
    private String scope = "per-host";
    private boolean collector = false;
    private String digestGenerator = CachingConstants.DEFAULT_XML_IDENTIFIER.getClass().toString();
    private int inMemoryCacheSize = 1000;
    private int diskCacheSize = 0;
    private long timeout = 0L;
    private String onCacheHitRef = null;
    private int maxMessageSize = 0;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public boolean isCollector() {
        return this.collector;
    }

    public void setCollector(boolean collector) {
        this.collector = collector;
    }

    public String getDigestGenerator() {
        return this.digestGenerator;
    }

    public void setDigestGenerator(String digestGenerator) {
        this.digestGenerator = digestGenerator;
    }

    public int getInMemoryCacheSize() {
        return this.inMemoryCacheSize;
    }

    public void setInMemoryCacheSize(int inMemoryCacheSize) {
        this.inMemoryCacheSize = inMemoryCacheSize;
    }

    public int getDiskCacheSize() {
        return this.diskCacheSize;
    }

    public void setDiskCacheSize(int diskCacheSize) {
        this.diskCacheSize = diskCacheSize;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public String getOnCacheHitRef() {
        return this.onCacheHitRef;
    }

    public void setOnCacheHitRef(String onCacheHitRef) {
        this.onCacheHitRef = onCacheHitRef;
    }

    public int getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public void setMaxMessageSize(int maxMessageSize) {
        this.maxMessageSize = maxMessageSize;
    }

    public String getTagLocalName() {
        return "cache";
    }

    public OMElement serialize(OMElement parent) {
        OMElement cache = fac.createOMElement("cache", synNS);
        CacheMediator.saveTracingState((OMElement)cache, (Mediator)this);
        if (this.id != null) {
            cache.addAttribute(fac.createOMAttribute("id", nullNS, this.id));
        }
        if (this.scope != null) {
            cache.addAttribute(fac.createOMAttribute("scope", nullNS, this.scope));
        }
        if (this.collector) {
            cache.addAttribute(fac.createOMAttribute("collector", nullNS, "true"));
        } else {
            OMElement implElem;
            OMElement onCacheHit;
            cache.addAttribute(fac.createOMAttribute("collector", nullNS, "false"));
            if (this.digestGenerator != null) {
                cache.addAttribute(fac.createOMAttribute("hashGenerator", nullNS, this.digestGenerator));
            }
            if (this.timeout != 0L) {
                cache.addAttribute(fac.createOMAttribute("timeout", nullNS, Long.toString(this.timeout)));
            }
            if (this.maxMessageSize != 0) {
                cache.addAttribute(fac.createOMAttribute("maxMessageSize", nullNS, Integer.toString(this.maxMessageSize)));
            }
            if (this.onCacheHitRef != null) {
                onCacheHit = fac.createOMElement("onCacheHit", synNS);
                onCacheHit.addAttribute(fac.createOMAttribute("sequence", nullNS, this.onCacheHitRef));
                cache.addChild((OMNode)onCacheHit);
            } else if (this.getList().size() > 0) {
                onCacheHit = fac.createOMElement("onCacheHit", synNS);
                this.serializeChildren(onCacheHit, this.getList());
                cache.addChild((OMNode)onCacheHit);
            }
            if (this.inMemoryCacheSize != 0) {
                implElem = fac.createOMElement("implementation", synNS);
                implElem.addAttribute(fac.createOMAttribute("type", nullNS, "memory"));
                implElem.addAttribute(fac.createOMAttribute("maxSize", nullNS, Integer.toString(this.inMemoryCacheSize)));
                cache.addChild((OMNode)implElem);
            }
            if (this.diskCacheSize != 0) {
                implElem = fac.createOMElement("implementation", synNS);
                implElem.addAttribute(fac.createOMAttribute("type", nullNS, "disk"));
                implElem.addAttribute(fac.createOMAttribute("maxSize", nullNS, Integer.toString(this.diskCacheSize)));
                cache.addChild((OMNode)implElem);
            }
        }
        if (parent != null) {
            parent.addChild((OMNode)cache);
        }
        return cache;
    }

    public void build(OMElement elem) {
        OMAttribute scopeAttr;
        OMAttribute idAttr = elem.getAttribute(ATT_ID);
        if (idAttr != null && idAttr.getAttributeValue() != null) {
            this.id = idAttr.getAttributeValue();
        }
        this.scope = (scopeAttr = elem.getAttribute(ATT_SCOPE)) != null && scopeAttr.getAttributeValue() != null && this.isValidScope(scopeAttr.getAttributeValue(), this.id) ? scopeAttr.getAttributeValue() : "per-host";
        OMAttribute collectorAttr = elem.getAttribute(ATT_COLLECTOR);
        if (collectorAttr != null && collectorAttr.getAttributeValue() != null && "true".equals(collectorAttr.getAttributeValue())) {
            this.collector = true;
        } else {
            OMElement onCacheHitElem;
            OMAttribute timeoutAttr;
            this.collector = false;
            OMAttribute hashGeneratorAttr = elem.getAttribute(ATT_HASH_GENERATOR);
            if (hashGeneratorAttr != null && hashGeneratorAttr.getAttributeValue() != null) {
                this.digestGenerator = hashGeneratorAttr.getAttributeValue();
            }
            this.timeout = (timeoutAttr = elem.getAttribute(ATT_TIMEOUT)) != null && timeoutAttr.getAttributeValue() != null ? Long.parseLong(timeoutAttr.getAttributeValue()) : 5000L;
            OMAttribute maxMessageSizeAttr = elem.getAttribute(ATT_MAX_MSG_SIZE);
            if (maxMessageSizeAttr != null && maxMessageSizeAttr.getAttributeValue() != null) {
                this.maxMessageSize = Integer.parseInt(maxMessageSizeAttr.getAttributeValue());
            }
            if ((onCacheHitElem = elem.getFirstChildWithName(ON_CACHE_HIT_Q)) != null) {
                OMAttribute sequenceAttr = onCacheHitElem.getAttribute(ATT_SEQUENCE);
                if (sequenceAttr != null && sequenceAttr.getAttributeValue() != null) {
                    this.onCacheHitRef = sequenceAttr.getAttributeValue();
                } else if (onCacheHitElem.getFirstElement() != null) {
                    this.addChildren(onCacheHitElem, (ListMediator)this);
                }
            }
            Iterator itr = elem.getChildrenWithName(IMPLEMENTATION_Q);
            while (itr.hasNext()) {
                OMElement implElem = (OMElement)itr.next();
                OMAttribute typeAttr = implElem.getAttribute(ATT_TYPE);
                OMAttribute sizeAttr = implElem.getAttribute(ATT_SIZE);
                if (typeAttr == null || typeAttr.getAttributeValue() == null) continue;
                String type = typeAttr.getAttributeValue();
                if ("memory".equals(type) && sizeAttr != null && sizeAttr.getAttributeValue() != null) {
                    this.inMemoryCacheSize = Integer.parseInt(sizeAttr.getAttributeValue());
                    continue;
                }
                if ("disk".equals(type)) {
                    if (sizeAttr != null && sizeAttr.getAttributeValue() != null) {
                        this.diskCacheSize = Integer.parseInt(sizeAttr.getAttributeValue());
                        continue;
                    }
                    this.diskCacheSize = 200;
                    continue;
                }
                throw new MediatorException("unknown implementation type for the Cache mediator");
            }
        }
    }

    private boolean isValidScope(String scope, String id) {
        if ("per-host".equals(scope)) {
            return true;
        }
        if ("per-mediator".equals(scope)) {
            if (id != null) {
                return true;
            }
            throw new MediatorException("Id is required for a cache wirth scope : " + scope);
        }
        if ("distributed".equals(scope)) {
            throw new MediatorException("Scope distributed is not supported yet by the Cache mediator");
        }
        throw new MediatorException("Unknown scope " + scope + " for the Cache mediator");
    }
}

