/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediator.bridge;

import java.io.File;
import java.io.FileFilter;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.wso2.carbon.server.CarbonLaunchExtension;
import org.wso2.carbon.server.util.Utils;

public class MediatorBundleCreator
implements CarbonLaunchExtension {
    private static final String MEDIATORS_DIR = "repository" + File.separator + "components" + File.separator + "mediators";

    public void perform() {
        String carbonHome = System.getProperty("carbon.home");
        if (carbonHome == null) {
            carbonHome = System.getenv("CARBON_HOME");
        }
        if (carbonHome == null || carbonHome.length() == 0) {
            return;
        }
        File carbonHomeFile = new File(carbonHome, MEDIATORS_DIR);
        if (!carbonHomeFile.exists()) {
            carbonHomeFile.mkdirs();
        }
        File dropinsFolder = new File(Utils.getCarbonComponentRepo(), "dropins");
        File[] files = carbonHomeFile.listFiles((FileFilter)new Utils.JarFileFilter());
        if (files != null) {
            for (File file : files) {
                try {
                    Manifest mf = new Manifest();
                    Attributes attribs = mf.getMainAttributes();
                    attribs.putValue("Fragment-Host", "synapse-core");
                    Utils.createBundle((File)file, (File)dropinsFolder, (Manifest)mf, (String)"synapse.mediator.");
                }
                catch (Throwable e) {
                    System.err.println("Cannot create mediator bundle from jar file " + file.getAbsolutePath());
                    e.printStackTrace();
                }
            }
        }
    }
}

