/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediator.bean;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.xml.ValueFactory;
import org.apache.synapse.config.xml.ValueSerializer;
import org.apache.synapse.mediators.Value;
import org.wso2.carbon.mediator.service.ui.AbstractMediator;
import org.wso2.carbon.mediator.service.ui.Mediator;

public class BeanMediator
extends AbstractMediator {
    private static final QName BEAN_Q = new QName("http://ws.apache.org/ns/synapse", "bean");
    private static final QName ATT_CLASS = new QName("class");
    private static final QName ATT_ACTION = new QName("action");
    private static final QName ATT_VAR = new QName("var");
    private static final QName ATT_PROPERTY = new QName("property");
    private static final QName ATT_VALUE = new QName("value");
    private static final QName ATT_TARGET = new QName("target");
    private String clazz;
    private String action;
    private String var;
    private String property;
    private Value value;
    private Value target;

    public String getTagLocalName() {
        return "bean";
    }

    public String getClazz() {
        return this.clazz;
    }

    public void setClazz(String clazz) {
        this.clazz = clazz;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getVar() {
        return this.var;
    }

    public void setVar(String var) {
        this.var = var;
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public Value getValue() {
        return this.value;
    }

    public void setValue(Value value) {
        this.value = value;
    }

    public Value getTarget() {
        return this.target;
    }

    public void setTarget(Value target) {
        this.target = target;
    }

    public OMElement serialize(OMElement parent) {
        OMElement beanElem = fac.createOMElement(BEAN_Q);
        if (this.clazz != null && !this.clazz.isEmpty()) {
            OMAttribute clazzAtt = fac.createOMAttribute("class", nullNS, this.clazz);
            beanElem.addAttribute(clazzAtt);
        }
        if (this.action != null && !this.action.isEmpty()) {
            OMAttribute beanstalkAtt = fac.createOMAttribute("action", nullNS, this.action);
            beanElem.addAttribute(beanstalkAtt);
        }
        if (this.var != null && !this.var.isEmpty()) {
            OMAttribute methodAtt = fac.createOMAttribute("var", nullNS, this.var);
            beanElem.addAttribute(methodAtt);
        }
        if (this.property != null && !this.property.isEmpty()) {
            OMAttribute targetAtt = fac.createOMAttribute("property", nullNS, this.property);
            beanElem.addAttribute(targetAtt);
        }
        if (this.value != null) {
            new ValueSerializer().serializeValue(this.value, "value", beanElem);
        }
        if (this.target != null) {
            new ValueSerializer().serializeValue(this.target, "target", beanElem);
        }
        if (parent != null) {
            parent.addChild((OMNode)beanElem);
        }
        return beanElem;
    }

    public void build(OMElement elem) {
        OMAttribute targetElm;
        OMAttribute value;
        OMAttribute propertyElm;
        OMAttribute varElm;
        OMAttribute actionElm;
        this.processAuditStatus((Mediator)this, elem);
        ValueFactory valueFactory = new ValueFactory();
        OMAttribute clazz = elem.getAttribute(ATT_CLASS);
        if (clazz != null) {
            this.clazz = clazz.getAttributeValue();
        }
        if ((actionElm = elem.getAttribute(ATT_ACTION)) != null) {
            this.action = actionElm.getAttributeValue();
        }
        if ((varElm = elem.getAttribute(ATT_VAR)) != null) {
            this.var = varElm.getAttributeValue();
        }
        if ((propertyElm = elem.getAttribute(ATT_PROPERTY)) != null) {
            this.property = propertyElm.getAttributeValue();
        }
        if ((value = elem.getAttribute(ATT_VALUE)) != null) {
            Value beanId;
            this.value = beanId = valueFactory.createValue("value", elem);
        }
        if ((targetElm = elem.getAttribute(ATT_TARGET)) != null) {
            Value target;
            this.target = target = valueFactory.createValue("target", elem);
        }
    }

    private void handleException(String msg) {
        LogFactory.getLog(((Object)((Object)this)).getClass()).error((Object)msg);
        throw new SynapseException(msg);
    }
}

