/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediator.bam.ui;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.mediator.bam.config.BamServerConfig;
import org.wso2.carbon.mediator.bam.config.BamServerConfigBuilder;
import org.wso2.carbon.mediator.bam.config.stream.StreamConfiguration;
import org.wso2.carbon.mediator.bam.ui.BamServerProfileConfigAdminClient;

public class DdlAjaxProcessorHelper {
    private static final Log log = LogFactory.getLog(DdlAjaxProcessorHelper.class);
    private BamServerProfileConfigAdminClient client;

    public DdlAjaxProcessorHelper(String cookie, String backendServerURL, ConfigurationContext configContext, Locale locale) {
        try {
            this.client = new BamServerProfileConfigAdminClient(cookie, backendServerURL, configContext, locale);
        }
        catch (AxisFault e) {
            String errorMsg = "Error while creating the BamServerProfileConfigAdminClient. " + e.getMessage();
            log.error((Object)errorMsg, (Throwable)e);
        }
    }

    private BamServerConfig getResource(String bamServerProfileLocation) {
        try {
            String resourceString = this.client.getResourceString(bamServerProfileLocation);
            OMElement resourceElement = new StAXOMBuilder((InputStream)new ByteArrayInputStream(resourceString.getBytes(Charset.forName("UTF-8")))).getDocumentElement();
            BamServerConfigBuilder bamServerConfigBuilder = new BamServerConfigBuilder();
            bamServerConfigBuilder.createBamServerConfig(resourceElement);
            return bamServerConfigBuilder.getBamServerConfig();
        }
        catch (RemoteException e) {
            String errorMsg = "Error while getting the resource. " + e.getMessage();
            log.error((Object)errorMsg, (Throwable)e);
        }
        catch (XMLStreamException e) {
            String errorMsg = "Error while creating OMElement from a string. " + e.getMessage();
            log.error((Object)errorMsg, (Throwable)e);
        }
        return null;
    }

    public boolean isNotNullOrEmpty(String string) {
        return string != null && !string.equals("");
    }

    public String getServerProfileNames(String serverProfilePath) {
        StringBuilder serverProfileNamesStringBuilder = new StringBuilder("");
        try {
            String[] serverProfileNames;
            for (String serverProfileName : serverProfileNames = this.client.getServerProfilePathList(serverProfilePath)) {
                serverProfileNamesStringBuilder.append("<option>" + serverProfileName.split("/")[serverProfileName.split("/").length - 1] + "</option>");
            }
        }
        catch (RemoteException e) {
            String errorMsg = "Error while getting Server Profile Names. " + e.getMessage();
            log.error((Object)errorMsg, (Throwable)e);
        }
        return serverProfileNamesStringBuilder.toString();
    }

    public String getStreamConfigurationNames(String serverProfilesLocation) {
        StringBuilder streamNamesBuilder = new StringBuilder("");
        BamServerConfig bamServerConfig = this.getResource(serverProfilesLocation);
        List streamConfigurations = bamServerConfig.getStreamConfigurations();
        ArrayList<String> foundStreamNames = new ArrayList<String>();
        for (StreamConfiguration configuration : streamConfigurations) {
            if (!foundStreamNames.contains(configuration.getName())) {
                streamNamesBuilder.append("<option>" + configuration.getName() + "</option>");
            }
            foundStreamNames.add(configuration.getName());
        }
        return streamNamesBuilder.toString();
    }

    public String getVersionListForStreamName(String serverProfilePath, String streamName) {
        StringBuilder streamVersionsBuilder = new StringBuilder("");
        BamServerConfig bamServerConfig = this.getResource(serverProfilePath);
        List streamConfigurations = bamServerConfig.getStreamConfigurations();
        for (StreamConfiguration configuration : streamConfigurations) {
            if (!configuration.getName().equals(streamName)) continue;
            streamVersionsBuilder.append("<option>" + configuration.getVersion() + "</option>");
        }
        return streamVersionsBuilder.toString();
    }
}

