/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediator.bam.ui;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.wso2.carbon.mediator.service.MediatorException;
import org.wso2.carbon.mediator.service.ui.AbstractMediator;
import org.wso2.carbon.mediator.service.ui.Mediator;

public class BamMediator
extends AbstractMediator {
    public static final QName NAME_Q = new QName("name");
    private String serverProfile = "";
    private String streamName = "";
    private String streamVersion = "";

    public String getServerProfile() {
        return this.serverProfile;
    }

    public void setServerProfile(String serverProfile1) {
        this.serverProfile = serverProfile1;
    }

    public String getStreamName() {
        return this.streamName;
    }

    public void setStreamName(String streamName) {
        this.streamName = streamName;
    }

    public String getStreamVersion() {
        return this.streamVersion;
    }

    public void setStreamVersion(String streamVersion) {
        this.streamVersion = streamVersion;
    }

    public String getTagLocalName() {
        return "bam";
    }

    public OMElement serialize(OMElement parent) {
        OMElement bamElement = fac.createOMElement("bam", synNS);
        BamMediator.saveTracingState((OMElement)bamElement, (Mediator)this);
        OMElement serverProfileElement = this.serializeServerProfile();
        serverProfileElement.addChild((OMNode)this.serializeStreamConfiguration());
        bamElement.addChild((OMNode)serverProfileElement);
        if (parent != null) {
            parent.addChild((OMNode)bamElement);
        }
        return bamElement;
    }

    public void build(OMElement omElement) {
        OMElement profileElement = omElement.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "serverProfile"));
        if (profileElement == null) {
            String msg = "The 'serverProfile' element is not specified";
            throw new MediatorException(msg);
        }
        this.processProfile(profileElement);
        this.processAuditStatus((Mediator)this, omElement);
    }

    private void processProfile(OMElement profile) {
        OMElement streamElement;
        OMAttribute pathAttr = profile.getAttribute(NAME_Q);
        if (pathAttr != null) {
            String pathValue = pathAttr.getAttributeValue();
            this.setServerProfile(pathValue);
            streamElement = profile.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "streamConfig"));
            if (streamElement == null) {
                String msg = "The 'streamConfig' element is not specified";
                throw new MediatorException(msg);
            }
        } else {
            String msg = "The 'name' attribute of Profile is not specified";
            throw new MediatorException(msg);
        }
        this.processStreamConfiguration(streamElement);
    }

    private void processStreamConfiguration(OMElement streamConfig) {
        OMAttribute streamNameAttr = streamConfig.getAttribute(NAME_Q);
        OMAttribute streamVersionAttr = streamConfig.getAttribute(new QName("version"));
        if (streamNameAttr == null || streamVersionAttr == null) {
            String msg = "The stream name or stream version attributes are not specified";
            throw new MediatorException(msg);
        }
        String nameValue = streamNameAttr.getAttributeValue();
        String versionValue = streamVersionAttr.getAttributeValue();
        this.setStreamName(nameValue);
        this.setStreamVersion(versionValue);
    }

    private OMElement serializeServerProfile() {
        OMElement profileElement = fac.createOMElement("serverProfile", synNS);
        profileElement.addAttribute("name", this.serverProfile, nullNS);
        return profileElement;
    }

    private OMElement serializeStreamConfiguration() {
        OMElement streamConfigElement = fac.createOMElement("streamConfig", synNS);
        streamConfigElement.addAttribute("name", this.streamName, nullNS);
        streamConfigElement.addAttribute("version", this.streamVersion, nullNS);
        return streamConfigElement;
    }
}

