/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediator.bam.config;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.common.services.RegistryAbstractAdmin;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;

public class RegistryManager
extends RegistryAbstractAdmin {
    private static final Log LOG = LogFactory.getLog(RegistryManager.class);
    private Registry registry = this.getConfigSystemRegistry();
    private Resource resource;

    public void saveResourceString(String resourceString, String gadgetResourcePath) {
        try {
            this.resource = this.registry.newResource();
            this.resource.setContent((Object)resourceString);
            this.registry.put(gadgetResourcePath, this.resource);
        }
        catch (RegistryException e) {
            String errorMsg = "Error while saving resource string from Registry. " + e.getMessage();
            LOG.error((Object)errorMsg, (Throwable)e);
        }
    }

    public boolean resourceAlreadyExists(String bamServerProfileLocation) {
        try {
            return this.registry.resourceExists(bamServerProfileLocation);
        }
        catch (RegistryException e) {
            String errorMsg = "Error while checking resource string from Registry. " + e.getMessage();
            LOG.error((Object)errorMsg, (Throwable)e);
            return true;
        }
    }

    public boolean removeResource(String path) {
        try {
            this.registry.delete(path);
            return true;
        }
        catch (RegistryException e) {
            String errorMsg = "Error while removing the resource from Registry. " + e.getMessage();
            LOG.error((Object)errorMsg, (Throwable)e);
            return false;
        }
    }

    public String getResourceString(String bamServerProfileLocation) {
        try {
            this.resource = this.registry.get(bamServerProfileLocation);
            return new String((byte[])this.resource.getContent());
        }
        catch (RegistryException e) {
            String errorMsg = "Error while getting the resource from Registry. " + e.getMessage();
            LOG.error((Object)errorMsg, (Throwable)e);
            return null;
        }
    }

    public boolean addCollection(String bamServerProfileCollectionLocation) {
        try {
            this.resource = this.registry.newCollection();
            this.registry.put(bamServerProfileCollectionLocation, this.resource);
            return true;
        }
        catch (RegistryException e) {
            String errorMsg = "Error while adding the collection to the Registry. " + e.getMessage();
            LOG.error((Object)errorMsg, (Throwable)e);
            return false;
        }
    }

    public String[] getServerProfileNameList(String bamServerProfileCollectionLocation) {
        try {
            return (String[])this.registry.get(bamServerProfileCollectionLocation).getContent();
        }
        catch (RegistryException e) {
            String errorMsg = "Error while getting the Server Profile Name List from the Registry. " + e.getMessage();
            LOG.error((Object)errorMsg, (Throwable)e);
            return new String[0];
        }
    }
}

