/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediator.bam.config;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.util.CryptoException;
import org.wso2.carbon.core.util.CryptoUtil;

public class CryptographyManager {
    private static final Log LOG = LogFactory.getLog(CryptographyManager.class);
    private CryptoUtil cryptoUtil = CryptoUtil.getDefaultCryptoUtil();

    public String encryptAndBase64Encode(String plainText) {
        try {
            return this.cryptoUtil.encryptAndBase64Encode(plainText.getBytes());
        }
        catch (CryptoException e) {
            String errorMsg = "Encryption and Base64 encoding error. " + e.getMessage();
            LOG.error((Object)errorMsg, (Throwable)e);
            return null;
        }
    }

    public String base64DecodeAndDecrypt(String cipherText) {
        try {
            return new String(this.cryptoUtil.base64DecodeAndDecrypt(cipherText));
        }
        catch (CryptoException e) {
            String errorMsg = "Base64 decoding and decryption error. " + e.getMessage();
            LOG.error((Object)errorMsg, (Throwable)e);
            return null;
        }
    }
}

