/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediator.bam;

import java.util.List;
import org.wso2.carbon.mediator.bam.config.stream.Property;
import org.wso2.carbon.mediator.bam.config.stream.StreamEntry;

public class StreamIDBuilder {
    private List<Property> properties;
    private List<StreamEntry> streamEntries;

    public String createStreamID(String streamName, String streamVersion, String streamNickName, String streamDescription, List<Property> properties, List<StreamEntry> streamEntries) {
        this.properties = properties;
        this.streamEntries = streamEntries;
        return "{  'name':'" + streamName + "'," + "  '" + "version" + "':'" + streamVersion + "'," + "  '" + "nickName" + "': '" + streamNickName + "'," + "  '" + "description" + "': '" + streamDescription + "'," + "  'correlationData':[" + "          {'name':'" + "activityID" + "','type':'STRING'}" + "  ]," + "  'metaData':[" + "          {'name':'tenantId','type':'INT'}" + "  ]," + "  'payloadData':[" + this.getConstantStreamDefinitionString() + this.getPropertyStreamDefinitionString() + this.getEntityStreamDefinitionString() + "  ]" + "}";
    }

    private String getConstantStreamDefinitionString() {
        String[] nameStrings = new String[]{"service_name", "operation_name", "message_id", "request_received_time", "http_method", "character_set_encoding", "remote_address", "transport_in_url", "message_type", "remote_host", "service_prefix"};
        String outputString = "          {'name':'message_direction','type':'STRING'}";
        for (String nameString : nameStrings) {
            outputString = outputString + "," + this.getStreamDefinitionEntryString(nameString, "STRING");
        }
        return outputString;
    }

    private String getPropertyStreamDefinitionString() {
        String propertyString = "";
        for (Property property : this.properties) {
            propertyString = propertyString + "," + this.getStreamDefinitionEntryString(property.getKey(), "STRING");
        }
        return propertyString;
    }

    private String getEntityStreamDefinitionString() {
        String entityString = "";
        for (StreamEntry streamEntry : this.streamEntries) {
            entityString = entityString + "," + this.getStreamDefinitionEntryString(streamEntry.getName(), streamEntry.getType());
        }
        return entityString;
    }

    private String getStreamDefinitionEntryString(String name, String type) {
        return "        {'name':'" + name + "','type':'" + type + "'}";
    }
}

