/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediator.bam.xml;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.Mediator;
import org.apache.synapse.config.xml.AbstractMediatorFactory;
import org.wso2.carbon.mediator.bam.BamMediator;
import org.wso2.carbon.mediator.bam.config.BamServerConfig;
import org.wso2.carbon.mediator.bam.config.BamServerConfigBuilder;
import org.wso2.carbon.mediator.bam.config.CryptographyManager;
import org.wso2.carbon.mediator.bam.config.RegistryManager;

public class BamMediatorFactory
extends AbstractMediatorFactory {
    private static final Log LOG = LogFactory.getLog(BamMediatorFactory.class);
    public static final QName BAM_Q = new QName("http://ws.apache.org/ns/synapse", "bam");
    public static final String SERVER_PROFILE_LOCATION = "bamServerProfiles";

    public Mediator createSpecificMediator(OMElement omElement, Properties properties) {
        RegistryManager registryManager;
        BamMediator bam = new BamMediator();
        BamServerConfigBuilder bamServerConfigBuilder = new BamServerConfigBuilder();
        String serverProfilePath = "bamServerProfiles/" + this.getServerProfileName(omElement);
        String streamName = this.getStreamName(omElement);
        String streamVersion = this.getStreamVersion(omElement);
        if (this.isNotNullOrEmpty(serverProfilePath) && this.isNotNullOrEmpty(streamName) && this.isNotNullOrEmpty(streamVersion)) {
            bam.setServerProfile(serverProfilePath);
            bam.getStream().setStreamName(streamName);
            bam.getStream().setStreamVersion(streamVersion);
        }
        if ((registryManager = new RegistryManager()).resourceAlreadyExists(serverProfilePath)) {
            String resourceString = registryManager.getResourceString(serverProfilePath);
            try {
                OMElement resourceElement = new StAXOMBuilder((InputStream)new ByteArrayInputStream(resourceString.getBytes())).getDocumentElement();
                boolean bamServerConfigCreated = bamServerConfigBuilder.createBamServerConfig(resourceElement);
                if (bamServerConfigCreated) {
                    this.updateBamMediator(bamServerConfigBuilder, bam, streamName, streamVersion);
                }
            }
            catch (XMLStreamException e) {
                String errorMsg = "Failed to create XML OMElement from the String. " + e.getMessage();
                LOG.error((Object)errorMsg, (Throwable)e);
            }
        }
        return bam;
    }

    public QName getTagQName() {
        return BAM_Q;
    }

    private String getServerProfileName(OMElement omElement) {
        OMElement serverProfileElement = omElement.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "serverProfile"));
        if (serverProfileElement != null) {
            OMAttribute serverProfileAttr = serverProfileElement.getAttribute(new QName("name"));
            if (serverProfileAttr != null) {
                return serverProfileAttr.getAttributeValue();
            }
            return null;
        }
        return null;
    }

    private String getStreamName(OMElement omElement) {
        OMElement streamConfigElement = omElement.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "streamConfig"));
        if (streamConfigElement != null) {
            OMAttribute streamNameAttr = streamConfigElement.getAttribute(new QName("name"));
            if (streamNameAttr != null) {
                return streamNameAttr.getAttributeValue();
            }
            return null;
        }
        return null;
    }

    private String getStreamVersion(OMElement omElement) {
        OMElement streamConfigElement = omElement.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "streamConfig"));
        if (streamConfigElement != null) {
            OMAttribute streamVersionAttr = streamConfigElement.getAttribute(new QName("version"));
            if (streamVersionAttr != null) {
                return streamVersionAttr.getAttributeValue();
            }
            return null;
        }
        return null;
    }

    private void updateBamMediator(BamServerConfigBuilder bamServerConfigBuilder, BamMediator bamMediator, String streamName, String streamVersion) {
        BamServerConfig bamServerConfig = bamServerConfigBuilder.getBamServerConfig();
        CryptographyManager cryptographyManager = new CryptographyManager();
        bamMediator.getStream().setStreamNickName(bamServerConfig.getAUniqueStreamConfiguration(streamName, streamVersion).getNickname());
        bamMediator.getStream().setStreamDescription(bamServerConfig.getAUniqueStreamConfiguration(streamName, streamVersion).getDescription());
        bamMediator.getStream().setUserName(bamServerConfig.getUsername());
        bamMediator.getStream().setPassword(cryptographyManager.base64DecodeAndDecrypt(bamServerConfig.getPassword()));
        bamMediator.getStream().setServerIp(bamServerConfig.getIp());
        bamMediator.getStream().setSecurity(bamServerConfig.isSecure());
        bamMediator.getStream().setAuthenticationPort(bamServerConfig.getAuthenticationPort());
        bamMediator.getStream().setReceiverPort(bamServerConfig.getReceiverPort());
        bamMediator.getStream().setKsLocation(bamServerConfig.getKeyStoreLocation());
        bamMediator.getStream().setKsPassword(cryptographyManager.base64DecodeAndDecrypt(bamServerConfig.getKeyStorePassword()));
        bamMediator.getStream().setProperties(bamServerConfig.getAUniqueStreamConfiguration(streamName, streamVersion).getProperties());
        bamMediator.getStream().setStreamEntries(bamServerConfig.getAUniqueStreamConfiguration(streamName, streamVersion).getEntries());
    }

    private boolean isNotNullOrEmpty(String string) {
        return string != null && !string.equals("");
    }
}

