/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediator.bam;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.util.xpath.SynapseXPath;
import org.jaxen.JaxenException;
import org.wso2.carbon.core.multitenancy.SuperTenantCarbonContext;
import org.wso2.carbon.databridge.agent.thrift.Agent;
import org.wso2.carbon.databridge.agent.thrift.DataPublisher;
import org.wso2.carbon.databridge.agent.thrift.conf.AgentConfiguration;
import org.wso2.carbon.databridge.agent.thrift.exception.AgentException;
import org.wso2.carbon.databridge.commons.Event;
import org.wso2.carbon.databridge.commons.exception.AuthenticationException;
import org.wso2.carbon.databridge.commons.exception.DifferentStreamDefinitionAlreadyDefinedException;
import org.wso2.carbon.databridge.commons.exception.MalformedStreamDefinitionException;
import org.wso2.carbon.databridge.commons.exception.StreamDefinitionException;
import org.wso2.carbon.databridge.commons.exception.TransportException;
import org.wso2.carbon.mediator.bam.StreamIDBuilder;
import org.wso2.carbon.mediator.bam.config.BamMediatorException;
import org.wso2.carbon.mediator.bam.config.stream.Property;
import org.wso2.carbon.mediator.bam.config.stream.StreamEntry;

public class Stream {
    private static final Log LOG = LogFactory.getLog(Stream.class);
    private String streamName = "";
    private String streamVersion = "";
    private String streamNickName = "";
    private String streamDescription = "";
    private List<Property> properties = new ArrayList<Property>();
    private List<StreamEntry> streamEntries = new ArrayList<StreamEntry>();
    private String streamId = null;
    private DataPublisher dataPublisher = null;
    private boolean security = true;
    private String ksLocation = "";
    private String ksPassword = "";
    private String serverIp = "";
    private String authenticationPort = "";
    private String receiverPort = "";
    private String userName = "";
    private String password = "";

    public void sendEvents(org.apache.synapse.MessageContext messageContext) {
        this.setActivityIdInSOAPHeader(messageContext);
        try {
            this.logMessage(messageContext);
        }
        catch (BamMediatorException e) {
            String errorMsg = "Problem occurred while logging in the BAM Mediator. " + e.getMessage();
            LOG.error((Object)errorMsg, (Throwable)e);
        }
    }

    private void setActivityIdInSOAPHeader(org.apache.synapse.MessageContext synapseContext) {
        UUID uuid = UUID.randomUUID();
        String uuidString = uuid.toString();
        Axis2MessageContext axis2smc = (Axis2MessageContext)synapseContext;
        MessageContext axis2MessageContext = axis2smc.getAxis2MessageContext();
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace omNs = fac.createOMNamespace("http://wso2.org/ns/2010/10/bam", "ns");
        SOAPEnvelope soapEnvelope = axis2MessageContext.getEnvelope();
        String soapNamespaceURI = soapEnvelope.getNamespace().getNamespaceURI();
        SOAPFactory soapFactory = null;
        if (soapNamespaceURI.equals("http://schemas.xmlsoap.org/soap/envelope/")) {
            soapFactory = OMAbstractFactory.getSOAP11Factory();
        } else if (soapNamespaceURI.equals("http://www.w3.org/2003/05/soap-envelope")) {
            soapFactory = OMAbstractFactory.getSOAP12Factory();
        } else {
            LOG.error((Object)"Not a standard soap message");
        }
        this.setActivityIDInSOAPHeaderWithConditioning(soapEnvelope, omNs, synapseContext, uuidString, soapFactory);
    }

    private void setActivityIDInSOAPHeaderWithConditioning(SOAPEnvelope soapEnvelope, OMNamespace omNs, org.apache.synapse.MessageContext synapseContext, String uuidString, SOAPFactory soapFactory) {
        try {
            if (soapEnvelope.getHeader() != null) {
                Iterator itr = soapEnvelope.getHeader().getChildrenWithName(new QName("http://wso2.org/ns/2010/10/bam", "BAMEvent"));
                if (!itr.hasNext()) {
                    SOAPHeaderBlock soapHeaderBlock = soapEnvelope.getHeader().addHeaderBlock("BAMEvent", omNs);
                    if (synapseContext.getProperty("bam_activity_id") == null) {
                        soapHeaderBlock.addAttribute("activityID", uuidString, null);
                        synapseContext.setProperty("bam_activity_id", (Object)uuidString);
                    } else {
                        soapHeaderBlock.addAttribute("activityID", (String)synapseContext.getProperty("bam_activity_id"), null);
                    }
                } else {
                    OMElement bamHeader = (OMElement)itr.next();
                    OMAttribute activityIdAttr = bamHeader.getAttribute(new QName("activityID"));
                    if (activityIdAttr != null) {
                        String activityId = activityIdAttr.getAttributeValue();
                        synapseContext.setProperty("bam_activity_id", (Object)activityId);
                    } else {
                        bamHeader.addAttribute("activityID", uuidString, null);
                        synapseContext.setProperty("bam_activity_id", (Object)uuidString);
                    }
                }
            } else {
                if (soapFactory != null) {
                    soapFactory.createSOAPHeader(soapEnvelope);
                }
                if (soapEnvelope.getHeader() != null) {
                    SOAPHeaderBlock soapHeaderBlock = soapEnvelope.getHeader().addHeaderBlock("BAMEvent", omNs);
                    if (synapseContext.getProperty("bam_activity_id") == null) {
                        soapHeaderBlock.addAttribute("activityID", uuidString, null);
                        synapseContext.setProperty("bam_activity_id", (Object)uuidString);
                    } else {
                        soapHeaderBlock.addAttribute("activityID", (String)synapseContext.getProperty("bam_activity_id"), null);
                    }
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while processing MessageHeaderMediator...", (Throwable)e);
        }
    }

    private void logMessage(org.apache.synapse.MessageContext messageContext) throws BamMediatorException {
        MessageContext msgCtx = ((Axis2MessageContext)messageContext).getAxis2MessageContext();
        AxisConfiguration axisConfiguration = msgCtx.getConfigurationContext().getAxisConfiguration();
        int tenantId = SuperTenantCarbonContext.getCurrentContext((AxisConfiguration)axisConfiguration).getTenantId();
        boolean direction = !messageContext.isResponse() && !messageContext.isFaultResponse();
        String service = msgCtx.getAxisService().getName();
        String operation = msgCtx.getAxisOperation().getName().getLocalPart();
        if (this.streamId == null) {
            Agent agent = this.createAgent();
            this.createDataPublisher(agent);
            this.defineEventStream();
        }
        if (this.streamId != null && !this.streamId.isEmpty()) {
            LOG.info((Object)("Stream ID: " + this.streamId));
            Event event = new Event(this.streamId, System.currentTimeMillis(), this.createMetadata(tenantId), this.createCorrelationData(messageContext), this.createPayloadData(messageContext, direction, service, operation));
            try {
                this.dataPublisher.publish(event);
            }
            catch (AgentException e) {
                String errorMsg = "Problem with Agent while publishing. " + e.getMessage();
                LOG.error((Object)errorMsg, (Throwable)e);
                throw new BamMediatorException(errorMsg, (Throwable)e);
            }
        } else {
            LOG.info((Object)"streamId is empty.");
        }
    }

    private void createDataPublisher(Agent agent) throws BamMediatorException {
        try {
            this.dataPublisher = this.security ? new DataPublisher("ssl://" + this.serverIp + ":" + this.authenticationPort, "ssl://" + this.serverIp + ":" + this.authenticationPort, this.userName, this.password, agent) : new DataPublisher("ssl://" + this.serverIp + ":" + this.authenticationPort, "tcp://" + this.serverIp + ":" + this.receiverPort, this.userName, this.password, agent);
        }
        catch (MalformedURLException e) {
            String errorMsg = "Given URLs are incorrect. " + e.getMessage();
            LOG.error((Object)errorMsg, (Throwable)e);
            throw new BamMediatorException(errorMsg, (Throwable)e);
        }
        catch (AgentException e) {
            String errorMsg = "Problem while creating the Agent. " + e.getMessage();
            LOG.error((Object)errorMsg, (Throwable)e);
            throw new BamMediatorException(errorMsg, (Throwable)e);
        }
        catch (AuthenticationException e) {
            String errorMsg = "Authentication failed. " + e.getMessage();
            LOG.error((Object)errorMsg, (Throwable)e);
            throw new BamMediatorException(errorMsg, (Throwable)e);
        }
        catch (TransportException e) {
            String errorMsg = "Transport layer problem. " + e.getMessage();
            LOG.error((Object)errorMsg, (Throwable)e);
            throw new BamMediatorException(errorMsg, (Throwable)e);
        }
        LOG.info((Object)"Data Publisher Created.");
    }

    private void defineEventStream() throws BamMediatorException {
        StreamIDBuilder streamIDBuilder = new StreamIDBuilder();
        try {
            this.streamId = this.dataPublisher.defineStream(streamIDBuilder.createStreamID(this.streamName, this.streamVersion, this.streamNickName, this.streamDescription, this.properties, this.streamEntries));
        }
        catch (AgentException e) {
            String errorMsg = "Problem while creating the Agent. " + e.getMessage();
            LOG.error((Object)errorMsg, (Throwable)e);
            throw new BamMediatorException(errorMsg, (Throwable)e);
        }
        catch (MalformedStreamDefinitionException e) {
            String errorMsg = "Stream definition is incorrect. " + e.getMessage();
            LOG.error((Object)errorMsg, (Throwable)e);
            throw new BamMediatorException(errorMsg, (Throwable)e);
        }
        catch (StreamDefinitionException e) {
            String errorMsg = "Problem with Stream Definition. " + e.getMessage();
            LOG.error((Object)errorMsg, (Throwable)e);
            throw new BamMediatorException(errorMsg, (Throwable)e);
        }
        catch (DifferentStreamDefinitionAlreadyDefinedException e) {
            String errorMsg = "Already there is a different Stream Definition exists for the Name and Version. " + e.getMessage();
            LOG.error((Object)errorMsg, (Throwable)e);
            throw new BamMediatorException(errorMsg, (Throwable)e);
        }
        LOG.info((Object)"Event Stream Defined.");
    }

    private Object[] createPayloadData(org.apache.synapse.MessageContext messageContext, boolean direction, String service, String operation) throws BamMediatorException {
        int i;
        int numOfProperties = this.properties.size();
        int numOfEntities = this.streamEntries.size();
        Object[] payloadData = new Object[numOfProperties + numOfEntities + 12];
        payloadData[0] = direction ? "IN" : "OUT";
        payloadData[1] = service;
        payloadData[2] = operation;
        payloadData[3] = messageContext.getMessageID();
        payloadData[4] = this.getHttpIp(messageContext, "wso2statistics.request.received.time");
        payloadData[5] = this.getHttpIp(messageContext, "HTTP_METHOD");
        payloadData[6] = this.getHttpIp(messageContext, "CHARACTER_SET_ENCODING");
        payloadData[7] = this.getHttpIp(messageContext, "REMOTE_ADDR");
        payloadData[8] = this.getHttpIp(messageContext, "TransportInURL");
        payloadData[9] = this.getHttpIp(messageContext, "messageType");
        payloadData[10] = this.getHttpIp(messageContext, "REMOTE_HOST");
        payloadData[11] = this.getHttpIp(messageContext, "SERVICE_PREFIX");
        for (i = 0; i < numOfProperties; ++i) {
            payloadData[12 + i] = this.producePropertyValue(this.properties.get(i), messageContext);
        }
        for (i = 0; i < numOfEntities; ++i) {
            payloadData[12 + numOfProperties + i] = this.produceEntityValue(this.streamEntries.get(i).getValue(), messageContext);
        }
        return payloadData;
    }

    private Agent createAgent() {
        AgentConfiguration agentConfiguration = new AgentConfiguration();
        String keyStorePath = this.ksLocation;
        String keyStorePassword = this.ksPassword;
        agentConfiguration.setTrustStore(keyStorePath);
        agentConfiguration.setTrustStorePassword(keyStorePassword);
        System.setProperty("javax.net.ssl.trustStore", keyStorePath);
        System.setProperty("javax.net.ssl.trustStorePassword", keyStorePassword);
        return new Agent(agentConfiguration);
    }

    private Object getHttpIp(org.apache.synapse.MessageContext messageContext, String propertyName) {
        MessageContext msgCtx = ((Axis2MessageContext)messageContext).getAxis2MessageContext();
        String output = (String)msgCtx.getLocalProperty(propertyName);
        if (output != null && !output.equals("")) {
            return output;
        }
        return "";
    }

    private Object[] createMetadata(int tenantId) {
        Object[] metaData = new Object[]{tenantId};
        return metaData;
    }

    private Object[] createCorrelationData(org.apache.synapse.MessageContext messageContext) {
        Object[] correlationData = new Object[]{messageContext.getProperty("bam_activity_id")};
        return correlationData;
    }

    private Object producePropertyValue(Property property, org.apache.synapse.MessageContext messageContext) {
        try {
            if (property.isExpression()) {
                SynapseXPath synapseXPath = new SynapseXPath(property.getValue());
                return synapseXPath.stringValueOf(messageContext);
            }
            return property.getValue();
        }
        catch (JaxenException e) {
            String errorMsg = "SynapseXPath cannot be created for the Stream Property. " + e.getMessage();
            LOG.error((Object)errorMsg, (Throwable)e);
            return "";
        }
    }

    private Object produceEntityValue(String valueName, org.apache.synapse.MessageContext messageContext) {
        if (valueName.startsWith("$")) {
            if ("$SOAPHeader".equals(valueName)) {
                return messageContext.getEnvelope().getHeader().toString();
            }
            if ("$SOAPBody".equals(valueName)) {
                return messageContext.getEnvelope().getBody().toString();
            }
            return "Invalid Entity Parameter !";
        }
        return valueName;
    }

    public String getStreamName() {
        return this.streamName;
    }

    public void setStreamName(String streamName) {
        this.streamName = streamName;
    }

    public String getStreamVersion() {
        return this.streamVersion;
    }

    public void setStreamVersion(String streamVersion) {
        this.streamVersion = streamVersion;
    }

    public void setStreamNickName(String streamNickName) {
        this.streamNickName = streamNickName;
    }

    public void setStreamDescription(String streamDescription) {
        this.streamDescription = streamDescription;
    }

    public void setProperties(List<Property> properties) {
        this.properties = properties;
    }

    public void setStreamEntries(List<StreamEntry> streamEntries) {
        this.streamEntries = streamEntries;
    }

    public void setSecurity(boolean security) {
        this.security = security;
    }

    public void setKsLocation(String ksLocation) {
        this.ksLocation = ksLocation;
    }

    public void setKsPassword(String ksPassword) {
        this.ksPassword = ksPassword;
    }

    public void setAuthenticationPort(String authenticationPort) {
        this.authenticationPort = authenticationPort;
    }

    public void setReceiverPort(String receiverPort) {
        this.receiverPort = receiverPort;
    }

    public void setServerIp(String serverIp) {
        this.serverIp = serverIp;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

