/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediator.bam.ui;

import java.rmi.RemoteException;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.mediator.bam.config.stub.BAMMediatorConfigAdminStub;

public class BamServerProfileConfigAdminClient {
    private static final Log LOG = LogFactory.getLog(BamServerProfileConfigAdminClient.class);
    private static final String BUNDLE = "org.wso2.carbon.mediator.bam.ui.i18n.Resources";
    private BAMMediatorConfigAdminStub stub;
    private ResourceBundle bundle;

    public BamServerProfileConfigAdminClient(String cookie, String backendServerURL, ConfigurationContext configCtx, Locale locale) throws AxisFault {
        String serviceURL = backendServerURL + "BAMMediatorConfigAdmin";
        this.bundle = ResourceBundle.getBundle(BUNDLE, locale);
        this.stub = new BAMMediatorConfigAdminStub(configCtx, serviceURL);
        ServiceClient client = this.stub._getServiceClient();
        Options option = client.getOptions();
        option.setManageSession(true);
        option.setProperty("Cookie", (Object)cookie);
    }

    public String getResourceString(String bamServerProfileLocation) throws RemoteException {
        try {
            return this.stub.getResourceString(bamServerProfileLocation);
        }
        catch (RemoteException e) {
            this.handleException(this.bundle.getString("cannot.get.bam.server.location"), e);
            return null;
        }
    }

    public String[] getServerProfilePathList(String bamServerProfileLocation) throws RemoteException {
        return this.stub.getServerProfileNameList(bamServerProfileLocation);
    }

    private void handleException(String msg, Exception e) throws RemoteException {
        LOG.error((Object)msg, (Throwable)e);
        throw new RemoteException(msg, e);
    }
}

