/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediator.bam.config.ui;

import java.rmi.RemoteException;
import java.util.Locale;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.mediator.bam.config.ui.BamServerProfileConfigAdminClient;

public class DdlAjaxProcessorHelper {
    private static final Log log = LogFactory.getLog(DdlAjaxProcessorHelper.class);
    private BamServerProfileConfigAdminClient client;

    public DdlAjaxProcessorHelper(String cookie, String backendServerURL, ConfigurationContext configContext, Locale locale) {
        try {
            this.client = new BamServerProfileConfigAdminClient(cookie, backendServerURL, configContext, locale);
        }
        catch (AxisFault e) {
            String errorMsg = "Error while creating the BamServerProfileConfigAdminClient. " + e.getMessage();
            log.error((Object)errorMsg, (Throwable)e);
        }
    }

    public boolean isNotNullOrEmpty(String string) {
        return string != null && !string.equals("");
    }

    public String getServerProfileNames(String serverProfilePath) {
        String serverProfileNamesString = "";
        try {
            String[] serverProfileNames;
            for (String serverProfileName : serverProfileNames = this.client.getServerProfilePathList(serverProfilePath)) {
                serverProfileNamesString = serverProfileNamesString + "<option>" + serverProfileName.split("/")[serverProfileName.split("/").length - 1] + "</option>";
            }
        }
        catch (RemoteException e) {
            String errorMsg = "Error while getting Server Profile Path List. " + e.getMessage();
            log.error((Object)errorMsg, (Throwable)e);
        }
        return serverProfileNamesString;
    }
}

