/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediator.bam.config.ui;

import java.rmi.RemoteException;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.mediator.bam.config.stub.BAMMediatorConfigAdminStub;

public class BamServerProfileConfigAdminClient {
    private static final Log log = LogFactory.getLog(BamServerProfileConfigAdminClient.class);
    private static final String BUNDLE = "org.wso2.carbon.mediator.bam.config.ui.i18n.Resources";
    private BAMMediatorConfigAdminStub stub;
    private ResourceBundle bundle;

    public BamServerProfileConfigAdminClient(String cookie, String backendServerURL, ConfigurationContext configCtx, Locale locale) throws AxisFault {
        String serviceURL = backendServerURL + "BAMMediatorConfigAdmin";
        this.bundle = ResourceBundle.getBundle(BUNDLE, locale);
        this.stub = new BAMMediatorConfigAdminStub(configCtx, serviceURL);
        ServiceClient client = this.stub._getServiceClient();
        Options option = client.getOptions();
        option.setManageSession(true);
        option.setProperty("Cookie", (Object)cookie);
    }

    public void saveResourceString(String resourceString, String bamServerProfileLocation) throws RemoteException {
        try {
            this.stub.saveResourceString(resourceString, bamServerProfileLocation);
        }
        catch (RemoteException e) {
            this.handleException(this.bundle.getString("cannot.save.resource.string"), e);
        }
    }

    public String getResourceString(String bamServerProfileLocation) throws RemoteException {
        try {
            return this.stub.getResourceString(bamServerProfileLocation);
        }
        catch (RemoteException e) {
            this.handleException(this.bundle.getString("cannot.get.resource.string"), e);
            return null;
        }
    }

    public boolean resourceAlreadyExists(String bamServerProfileLocation) throws RemoteException {
        try {
            return this.stub.resourceAlreadyExists(bamServerProfileLocation);
        }
        catch (RemoteException e) {
            this.handleException(this.bundle.getString("cannot.check.resource.exists"), e);
            return true;
        }
    }

    public boolean addCollection(String path) throws RemoteException {
        try {
            return this.stub.addCollection(path);
        }
        catch (RemoteException e) {
            this.handleException(this.bundle.getString("cannot.add.collection"), e);
            return false;
        }
    }

    public boolean removeResource(String path) throws RemoteException {
        try {
            return this.stub.removeResource(path);
        }
        catch (RemoteException e) {
            this.handleException(this.bundle.getString("cannot.remove.resource"), e);
            return false;
        }
    }

    public String[] getServerProfilePathList(String bamServerProfileLocation) throws RemoteException {
        return this.stub.getServerProfileNameList(bamServerProfileLocation);
    }

    public String encryptAndBase64Encode(String plainText) throws RemoteException {
        try {
            return this.stub.encryptAndBase64Encode(plainText);
        }
        catch (RemoteException e) {
            this.handleException(this.bundle.getString("cannot.encrypt.encode.string"), e);
            return "";
        }
    }

    public String base64DecodeAndDecrypt(String cipherText) throws RemoteException {
        try {
            return this.stub.base64DecodeAndDecrypt(cipherText);
        }
        catch (RemoteException e) {
            this.handleException(this.bundle.getString("cannot.decode.decrypt.string"), e);
            return "";
        }
    }

    private void handleException(String msg, Exception e) throws RemoteException {
        log.error((Object)msg, (Throwable)e);
        throw new RemoteException(msg, e);
    }
}

