/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediator.bam.config.services;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.mediator.bam.config.BamServerConfig;
import org.wso2.carbon.mediator.bam.config.BamServerConfigBuilder;
import org.wso2.carbon.mediator.bam.config.CryptographyManager;
import org.wso2.carbon.mediator.bam.config.RegistryManager;

public class BamServerProfileConfigAdmin
extends AbstractAdmin {
    private static final Log LOG = LogFactory.getLog(BamServerProfileConfigAdmin.class);
    private RegistryManager registryManager = new RegistryManager();
    private CryptographyManager cryptographyManager = new CryptographyManager();

    public boolean saveResourceString(String resourceString, String bamServerProfileLocation) {
        this.registryManager.saveResourceString(resourceString, bamServerProfileLocation);
        return true;
    }

    public String getResourceString(String bamServerProfileLocation) {
        return this.registryManager.getResourceString(bamServerProfileLocation);
    }

    public boolean resourceAlreadyExists(String bamServerProfileLocation) {
        return this.registryManager.resourceAlreadyExists(bamServerProfileLocation);
    }

    public boolean removeResource(String path) {
        return this.registryManager.removeResource(path);
    }

    public BamServerConfig getBamServerConfig(String bamServerConfigLocation) {
        String resourceString = this.registryManager.getResourceString(bamServerConfigLocation);
        BamServerConfigBuilder bamServerConfigBuilder = new BamServerConfigBuilder();
        try {
            OMElement resourceElement = new StAXOMBuilder((InputStream)new ByteArrayInputStream(resourceString.getBytes())).getDocumentElement();
            bamServerConfigBuilder.createBamServerConfig(resourceElement);
            return bamServerConfigBuilder.getBamServerConfig();
        }
        catch (XMLStreamException e) {
            String errorMsg = "Failed to create XML OMElement from the String. " + e.getMessage();
            LOG.error((Object)errorMsg, (Throwable)e);
            return null;
        }
    }

    public boolean saveBamServerConfig(BamServerConfig bamServerConfig) {
        return true;
    }

    public boolean bamServerConfigExists(String bamServerConfigLocation) {
        return this.registryManager.resourceAlreadyExists(bamServerConfigLocation);
    }

    public boolean addCollection(String bamServerProfileCollectionLocation) {
        return this.registryManager.addCollection(bamServerProfileCollectionLocation);
    }

    public String[] getServerProfileNameList(String bamServerProfileCollectionLocation) {
        return this.registryManager.getServerProfileNameList(bamServerProfileCollectionLocation);
    }

    public String encryptAndBase64Encode(String plainText) {
        return this.cryptographyManager.encryptAndBase64Encode(plainText);
    }

    public String base64DecodeAndDecrypt(String cipherText) {
        return this.cryptographyManager.base64DecodeAndDecrypt(cipherText);
    }
}

