/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediator.bam.config;

import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.synapse.SynapseConstants;
import org.wso2.carbon.mediator.bam.config.stream.Property;
import org.wso2.carbon.mediator.bam.config.stream.StreamConfiguration;
import org.wso2.carbon.mediator.bam.config.stream.StreamEntry;

public class BamServerConfigXml {
    private OMFactory fac = OMAbstractFactory.getOMFactory();
    private OMNamespace synNS = SynapseConstants.SYNAPSE_OMNAMESPACE;

    public OMElement buildServerProfile(String ip, String authenticationPort, String receiverPort, String userName, String password, String secure, String ksLocation, String ksPassword, List<StreamConfiguration> streamConfigurations) {
        OMElement serverProfileElement = this.serializeServerProfile();
        serverProfileElement.addChild((OMNode)this.serializeConnection(secure, ip, authenticationPort, receiverPort));
        serverProfileElement.addChild((OMNode)this.serializeCredential(userName, password));
        serverProfileElement.addChild((OMNode)this.serializeKeyStore(ksLocation, ksPassword));
        serverProfileElement.addChild((OMNode)this.serializeStreams(streamConfigurations));
        return serverProfileElement;
    }

    private OMElement serializeConnection(String secure, String ip, String authenticationPort, String receiverPort) {
        OMElement credentialElement = this.fac.createOMElement("connection", this.synNS);
        credentialElement.addAttribute("secure", secure, null);
        credentialElement.addAttribute("ip", ip, null);
        credentialElement.addAttribute("authPort", authenticationPort, null);
        credentialElement.addAttribute("receiverPort", receiverPort, null);
        return credentialElement;
    }

    private OMElement serializeCredential(String userName, String password) {
        OMElement credentialElement = this.fac.createOMElement("credential", this.synNS);
        credentialElement.addAttribute("userName", userName, null);
        credentialElement.addAttribute("password", password, null);
        return credentialElement;
    }

    private OMElement serializeKeyStore(String location, String password) {
        OMElement keyStoreElement = this.fac.createOMElement("keyStore", this.synNS);
        keyStoreElement.addAttribute("location", location, null);
        keyStoreElement.addAttribute("password", password, null);
        return keyStoreElement;
    }

    private OMElement serializeServerProfile() {
        return this.fac.createOMElement("serverProfile", this.synNS);
    }

    private OMElement serializeStreams(List<StreamConfiguration> streamConfigurations) {
        OMElement streamsElement = this.fac.createOMElement("streams", this.synNS);
        if (streamConfigurations != null) {
            for (StreamConfiguration streamConfiguration : streamConfigurations) {
                streamsElement.addChild((OMNode)this.serializeStream(streamConfiguration));
            }
        }
        return streamsElement;
    }

    private OMElement serializeStream(StreamConfiguration streamConfiguration) {
        OMElement propertiesElement;
        List<StreamEntry> streamEntries;
        OMElement streamElement = this.fac.createOMElement("stream", this.synNS);
        streamElement.addAttribute("name", streamConfiguration.getName(), null);
        streamElement.addAttribute("version", streamConfiguration.getVersion(), null);
        streamElement.addAttribute("nickName", streamConfiguration.getNickname(), null);
        streamElement.addAttribute("description", streamConfiguration.getDescription(), null);
        OMElement payloadElement = streamElement.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "payload"));
        if (payloadElement == null) {
            streamElement.addChild((OMNode)this.serializePayload());
        }
        if ((payloadElement = streamElement.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "payload"))) == null) {
            streamElement.addChild((OMNode)this.serializePayload());
        }
        if ((streamEntries = streamConfiguration.getEntries()) != null) {
            for (StreamEntry streamEntry : streamEntries) {
                String tmpEntryName = streamEntry.getName();
                String tmpEntryValue = streamEntry.getValue();
                String tmpEntryType = streamEntry.getType();
                if (payloadElement == null) continue;
                payloadElement.addChild((OMNode)this.serializeEntry(tmpEntryName, tmpEntryValue, tmpEntryType));
            }
        }
        if ((propertiesElement = streamElement.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "properties"))) == null) {
            streamElement.addChild((OMNode)this.serializeProperties());
        }
        propertiesElement = streamElement.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "properties"));
        List<Property> properties = streamConfiguration.getProperties();
        if (properties != null) {
            for (Property property : properties) {
                String tmpEntryName = property.getKey();
                String tmpEntryValue = property.getValue();
                boolean tmpIsExpression = property.isExpression();
                propertiesElement.addChild((OMNode)this.serializeProperty(tmpEntryName, tmpEntryValue, tmpIsExpression));
            }
        }
        return streamElement;
    }

    private OMElement serializePayload() {
        return this.fac.createOMElement("payload", this.synNS);
    }

    private OMElement serializeEntry(String name, String value, String type) {
        OMElement entryElement = this.fac.createOMElement("entry", this.synNS);
        entryElement.addAttribute("name", name, null);
        entryElement.addAttribute("value", value, null);
        entryElement.addAttribute("type", type, null);
        return entryElement;
    }

    private OMElement serializeProperties() {
        return this.fac.createOMElement("properties", this.synNS);
    }

    private OMElement serializeProperty(String name, String value, boolean isExpression) {
        OMElement propertyElement = this.fac.createOMElement("property", this.synNS);
        propertyElement.addAttribute("name", name, null);
        propertyElement.addAttribute("value", value, null);
        if (isExpression) {
            propertyElement.addAttribute("isExpression", "true", null);
        } else {
            propertyElement.addAttribute("isExpression", "false", null);
        }
        return propertyElement;
    }
}

