/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediator.bam.config;

import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.wso2.carbon.mediator.bam.config.BamServerConfig;
import org.wso2.carbon.mediator.bam.config.stream.Property;
import org.wso2.carbon.mediator.bam.config.stream.StreamConfiguration;
import org.wso2.carbon.mediator.bam.config.stream.StreamEntry;

public class BamServerConfigBuilder {
    private BamServerConfig bamServerConfig = new BamServerConfig();

    public boolean createBamServerConfig(OMElement bamServerConfigElement) {
        boolean credentialsOk = this.processCredentialElement(bamServerConfigElement);
        boolean connectionOk = this.processConnectionElement(bamServerConfigElement);
        boolean keyStoreOk = this.processKeyStoreElement(bamServerConfigElement);
        boolean streamsOk = this.processStreamsElement(bamServerConfigElement);
        return credentialsOk && connectionOk && keyStoreOk && streamsOk;
    }

    private boolean processCredentialElement(OMElement bamServerConfig) {
        OMElement credentialElement = bamServerConfig.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "credential"));
        if (credentialElement != null) {
            OMAttribute userNameAttr = credentialElement.getAttribute(new QName("userName"));
            OMAttribute passwordAttr = credentialElement.getAttribute(new QName("password"));
            if (this.isNotNullOrEmpty(userNameAttr) && this.isNotNullOrEmpty(passwordAttr)) {
                this.bamServerConfig.setUsername(userNameAttr.getAttributeValue());
                this.bamServerConfig.setPassword(passwordAttr.getAttributeValue());
            } else {
                return false;
            }
        }
        return true;
    }

    private boolean processConnectionElement(OMElement bamServerConfig) {
        OMElement connectionElement = bamServerConfig.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "connection"));
        if (connectionElement != null) {
            OMAttribute secureAttr = connectionElement.getAttribute(new QName("secure"));
            OMAttribute ipAttr = connectionElement.getAttribute(new QName("ip"));
            OMAttribute authenticationPortAttr = connectionElement.getAttribute(new QName("authPort"));
            OMAttribute receiverPortAttr = connectionElement.getAttribute(new QName("receiverPort"));
            if (this.isNotNullOrEmpty(ipAttr) && this.isNotNullOrEmpty(secureAttr) && this.isNotNullOrEmpty(authenticationPortAttr)) {
                this.bamServerConfig.setIp(ipAttr.getAttributeValue());
                if ("true".equals(secureAttr.getAttributeValue())) {
                    this.bamServerConfig.setSecurity(true);
                } else if ("false".equals(secureAttr.getAttributeValue())) {
                    this.bamServerConfig.setSecurity(false);
                } else {
                    return false;
                }
                this.bamServerConfig.setAuthenticationPort(authenticationPortAttr.getAttributeValue());
                if (receiverPortAttr.getAttributeValue() != null && !receiverPortAttr.getAttributeValue().equals("")) {
                    this.bamServerConfig.setReceiverPort(receiverPortAttr.getAttributeValue());
                } else {
                    this.bamServerConfig.setReceiverPort("");
                }
            } else {
                return false;
            }
        }
        return true;
    }

    private boolean processKeyStoreElement(OMElement bamServerConfig) {
        OMElement keyStoreElement = bamServerConfig.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "keyStore"));
        if (keyStoreElement != null) {
            OMAttribute locationAttr = keyStoreElement.getAttribute(new QName("location"));
            OMAttribute passwordAttr = keyStoreElement.getAttribute(new QName("password"));
            if (this.isNotNullOrEmpty(locationAttr) && this.isNotNullOrEmpty(passwordAttr)) {
                this.bamServerConfig.setKeyStoreLocation(locationAttr.getAttributeValue());
                this.bamServerConfig.setKeyStorePassword(passwordAttr.getAttributeValue());
            } else {
                return false;
            }
        }
        return true;
    }

    private boolean processStreamsElement(OMElement bamServerConfigElement) {
        OMElement streamsElement = bamServerConfigElement.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "streams"));
        return streamsElement != null && this.processStreamElements(streamsElement);
    }

    private boolean processStreamElements(OMElement streamsElement) {
        Iterator itr = streamsElement.getChildrenWithName(new QName("stream"));
        while (itr.hasNext()) {
            OMElement streamElement = (OMElement)itr.next();
            StreamConfiguration streamConfiguration = new StreamConfiguration();
            if (streamElement != null && this.processStreamElement(streamElement, streamConfiguration)) {
                this.bamServerConfig.getStreamConfigurations().add(streamConfiguration);
                continue;
            }
            return false;
        }
        return true;
    }

    private boolean processStreamElement(OMElement streamElement, StreamConfiguration streamConfiguration) {
        OMAttribute nameAttr = streamElement.getAttribute(new QName("name"));
        OMAttribute versionAttr = streamElement.getAttribute(new QName("version"));
        OMAttribute nickNameAttr = streamElement.getAttribute(new QName("nickName"));
        OMAttribute descriptionAttr = streamElement.getAttribute(new QName("description"));
        if (this.isNotNullOrEmpty(nameAttr) && this.isNotNullOrEmpty(nickNameAttr) && this.isNotNullOrEmpty(descriptionAttr)) {
            streamConfiguration.setName(nameAttr.getAttributeValue());
            streamConfiguration.setVersion(versionAttr.getAttributeValue());
            streamConfiguration.setNickname(nickNameAttr.getAttributeValue());
            streamConfiguration.setDescription(descriptionAttr.getAttributeValue());
            boolean payloadElementOk = this.processPayloadElement(streamElement, streamConfiguration);
            boolean propertiesElementOk = this.processPropertiesElement(streamElement, streamConfiguration);
            return payloadElementOk & propertiesElementOk;
        }
        return false;
    }

    private boolean processPayloadElement(OMElement streamElement, StreamConfiguration streamConfiguration) {
        OMElement payloadElement = streamElement.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "payload"));
        return payloadElement != null && this.processEntryElements(payloadElement, streamConfiguration);
    }

    private boolean processEntryElements(OMElement payloadElement, StreamConfiguration streamConfiguration) {
        Iterator itr = payloadElement.getChildrenWithName(new QName("entry"));
        while (itr.hasNext()) {
            OMElement entryElement = (OMElement)itr.next();
            if (entryElement != null && this.processEntryElement(entryElement, streamConfiguration)) continue;
            return false;
        }
        return true;
    }

    private boolean processEntryElement(OMElement entryElement, StreamConfiguration streamConfiguration) {
        OMAttribute nameAttr = entryElement.getAttribute(new QName("name"));
        OMAttribute valueAttr = entryElement.getAttribute(new QName("value"));
        OMAttribute typeAttr = entryElement.getAttribute(new QName("type"));
        if (this.isNotNullOrEmpty(nameAttr) && this.isNotNullOrEmpty(valueAttr) && this.isNotNullOrEmpty(typeAttr)) {
            StreamEntry streamEntry = new StreamEntry();
            streamEntry.setName(nameAttr.getAttributeValue());
            streamEntry.setValue(valueAttr.getAttributeValue());
            streamEntry.setType(typeAttr.getAttributeValue());
            streamConfiguration.getEntries().add(streamEntry);
            return true;
        }
        return false;
    }

    private boolean processPropertiesElement(OMElement streamElement, StreamConfiguration streamConfiguration) {
        OMElement propertiesElement = streamElement.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "properties"));
        return propertiesElement == null || this.processPropertyElements(propertiesElement, streamConfiguration);
    }

    private boolean processPropertyElements(OMElement propertiesElement, StreamConfiguration streamConfiguration) {
        Iterator itr = propertiesElement.getChildrenWithName(new QName("property"));
        while (itr.hasNext()) {
            OMElement propertyElement = (OMElement)itr.next();
            if (propertyElement != null && this.processPropertyElement(propertyElement, streamConfiguration)) continue;
            return false;
        }
        return true;
    }

    private boolean processPropertyElement(OMElement propertyElement, StreamConfiguration streamConfiguration) {
        OMAttribute nameAttr = propertyElement.getAttribute(new QName("name"));
        OMAttribute valueAttr = propertyElement.getAttribute(new QName("value"));
        OMAttribute isExpressionAttr = propertyElement.getAttribute(new QName("isExpression"));
        if (this.isNotNullOrEmpty(nameAttr) && this.isNotNullOrEmpty(valueAttr) && this.isNotNullOrEmpty(isExpressionAttr)) {
            Property property = new Property();
            property.setKey(nameAttr.getAttributeValue());
            property.setValue(valueAttr.getAttributeValue());
            property.setExpression("true".equals(isExpressionAttr.getAttributeValue()));
            streamConfiguration.getProperties().add(property);
            return true;
        }
        return false;
    }

    private boolean isNotNullOrEmpty(OMAttribute omAttribute) {
        return omAttribute != null && !omAttribute.getAttributeValue().equals("");
    }

    public BamServerConfig getBamServerConfig() {
        return this.bamServerConfig;
    }
}

