/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.tracer.ui.client;

import java.rmi.RemoteException;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.mediation.tracer.stub.client.MediationTracerExceptionException;
import org.wso2.carbon.mediation.tracer.stub.client.MediationTracerServiceStub;

public class MediationTracerServiceClient {
    private static final Log log = LogFactory.getLog(MediationTracerServiceClient.class);
    private static final String BUNDLE = "org.wso2.carbon.mediation.tracer.ui.i18n.Resources";
    private ResourceBundle bundle;
    public MediationTracerServiceStub stub;

    public MediationTracerServiceClient(String cookie, String backendServerURL, ConfigurationContext configCtx, Locale locale) throws AxisFault {
        String serviceURL = backendServerURL + "MediationTracerService";
        this.bundle = ResourceBundle.getBundle(BUNDLE, locale);
        this.stub = new MediationTracerServiceStub(configCtx, serviceURL);
        ServiceClient client = this.stub._getServiceClient();
        Options option = client.getOptions();
        option.setManageSession(true);
        option.setProperty("Cookie", (Object)cookie);
    }

    public String[] getTraceLogs() throws AxisFault {
        try {
            return this.stub.getTraceLogs();
        }
        catch (RemoteException e) {
            String msg = this.bundle.getString("cannot.get.service.binding");
            this.handleException(msg, e);
            return null;
        }
    }

    public void clearLogs() throws AxisFault {
        try {
            this.stub.clearTraceLogs();
        }
        catch (RemoteException e) {
            String msg = this.bundle.getString("Cannot clear the logs");
            this.handleException(msg, e);
        }
    }

    public String[] searchLogs(String key, boolean ignoreCase) throws AxisFault {
        try {
            return this.stub.searchTraceLog(key, ignoreCase);
        }
        catch (RemoteException e) {
            String msg = this.bundle.getString("Cannot search the logs");
            this.handleException(msg, e);
        }
        catch (MediationTracerExceptionException e) {
            String msg = this.bundle.getString("Cannot search the logs");
            this.handleException(msg, (Exception)((Object)e));
        }
        return null;
    }

    private void handleException(String msg, Exception e) throws AxisFault {
        log.error((Object)msg, (Throwable)e);
        throw new AxisFault(msg, (Throwable)e);
    }
}

