/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.tracer;

import java.util.ArrayList;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;
import org.wso2.carbon.logging.appenders.MemoryAppender;
import org.wso2.carbon.mediation.tracer.MediationTracerException;

public class MediationTracerService {
    private static final Log log = LogFactory.getLog(MediationTracerService.class);

    public String[] getTraceLogs() {
        int DEFAULT_NO_OF_LOGS = 100;
        Logger logger = Logger.getLogger((String)"TRACE_LOGGER");
        Appender appender = logger.getAppender("TRACE_MEMORYAPPENDER");
        if (appender instanceof MemoryAppender) {
            MemoryAppender memoryAppender = (MemoryAppender)appender;
            if (memoryAppender.getCircularQueue() == null) {
                return new String[]{"--- No trace entries found. You can enable tracing on sequences, proxies or endpoints by vising the relevant pages ---"};
            }
            int amount = memoryAppender.getBufferSize();
            if (memoryAppender.getCircularQueue().getObjects(amount) == null || memoryAppender.getCircularQueue().getObjects(amount).length == 0) {
                return new String[]{"--- No trace entries found. You can enable tracing on sequences, proxies or endpoints by vising the relevant pages ---"};
            }
            Object[] objects = amount < 1 ? memoryAppender.getCircularQueue().getObjects(DEFAULT_NO_OF_LOGS) : memoryAppender.getCircularQueue().getObjects(amount);
            String[] resp = new String[objects.length];
            Layout layout = memoryAppender.getLayout();
            for (int i = 0; i < objects.length; ++i) {
                LoggingEvent logEvt = (LoggingEvent)objects[i];
                if (logEvt == null) continue;
                resp[i] = StringEscapeUtils.escapeHtml((String)layout.format(logEvt));
            }
            return resp;
        }
        return new String[]{"The trace log must be configured to use the org.wso2.carbon.logging.appenders.MemoryAppender to view entries through the admin console"};
    }

    public boolean clearTraceLogs() {
        Logger logger = Logger.getLogger((String)"TRACE_LOGGER");
        Appender appender = logger.getAppender("TRACE_MEMORYAPPENDER");
        if (appender instanceof MemoryAppender) {
            try {
                MemoryAppender memoryAppender = (MemoryAppender)appender;
                if (memoryAppender.getCircularQueue() != null) {
                    memoryAppender.getCircularQueue().clear();
                }
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public String[] searchTraceLog(String keyword, boolean ignoreCase) throws MediationTracerException {
        int DEFAULT_NO_OF_LOGS = 100;
        if (keyword == null) {
            this.handleException("Key word can not be null");
        }
        if ("ALL".equals(keyword) || "".equals(keyword)) {
            return this.getTraceLogs();
        }
        Logger logger = Logger.getLogger((String)"TRACE_LOGGER");
        Appender appender = logger.getAppender("TRACE_MEMORYAPPENDER");
        if (appender instanceof MemoryAppender) {
            MemoryAppender memoryAppender = (MemoryAppender)appender;
            if (memoryAppender.getCircularQueue() == null) {
                return new String[]{"--- No trace entries found for  " + keyword + " ---"};
            }
            int definedamonut = memoryAppender.getBufferSize();
            if (memoryAppender.getCircularQueue().getObjects(definedamonut) == null || memoryAppender.getCircularQueue().getObjects(definedamonut).length == 0) {
                return new String[]{"--- No trace entries found for the " + keyword + " ---"};
            }
            Object[] objects = definedamonut < 1 ? memoryAppender.getCircularQueue().getObjects(DEFAULT_NO_OF_LOGS) : memoryAppender.getCircularQueue().getObjects(definedamonut);
            Layout layout = memoryAppender.getLayout();
            ArrayList<String> resultList = new ArrayList<String>();
            for (Object object : objects) {
                String result;
                LoggingEvent logEvt = (LoggingEvent)object;
                if (logEvt == null || (result = layout.format(logEvt)) == null) continue;
                if (!ignoreCase) {
                    if (result.indexOf(keyword) <= -1) continue;
                    resultList.add(StringEscapeUtils.escapeHtml((String)result));
                    continue;
                }
                if (keyword == null || result.toLowerCase().indexOf(keyword.toLowerCase()) <= -1) continue;
                resultList.add(StringEscapeUtils.escapeHtml((String)result));
            }
            if (resultList.isEmpty()) {
                return new String[]{"--- No trace entries found for the  " + keyword + " ---"};
            }
            return resultList.toArray(new String[resultList.size()]);
        }
        return new String[]{"The trace log must be configured to use the org.wso2.carbon.logging.appenders.MemoryAppender to view entries through the admin console"};
    }

    public String[] getLogs() {
        int DEFAULT_NO_OF_LOGS = 100;
        Appender appender = Logger.getRootLogger().getAppender("LOG_MEMORYAPPENDER");
        if (appender instanceof MemoryAppender) {
            MemoryAppender memoryAppender = (MemoryAppender)appender;
            if (memoryAppender.getCircularQueue() == null) {
                return new String[]{"--- No log entries found. You may try increasing the log level ---"};
            }
            int definedamount = memoryAppender.getBufferSize();
            if (memoryAppender.getCircularQueue().getObjects(definedamount) == null || memoryAppender.getCircularQueue().getObjects(definedamount).length == 0) {
                return new String[]{"--- No log entries found. You may try increasing the log level ---"};
            }
            Object[] objects = definedamount < 1 ? memoryAppender.getCircularQueue().getObjects(DEFAULT_NO_OF_LOGS) : memoryAppender.getCircularQueue().getObjects(definedamount);
            String[] resp = new String[objects.length];
            Layout layout = memoryAppender.getLayout();
            for (int i = 0; i < objects.length; ++i) {
                LoggingEvent logEvt = (LoggingEvent)objects[i];
                if (logEvt == null) continue;
                resp[i] = StringEscapeUtils.escapeHtml((String)layout.format(logEvt));
            }
            return resp;
        }
        return new String[]{"The log must be configured to use the org.wso2.carbon.logging.appenders.MemoryAppender to view entries on the admin console"};
    }

    private void handleException(String msg) throws MediationTracerException {
        log.error((Object)msg);
        throw new MediationTracerException(msg);
    }
}

