/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.templates.ui;

import java.util.ArrayList;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.mediation.service.templates.TemplateMediator;
import org.wso2.carbon.mediation.templates.stub.types.TemplateAdminServiceStub;
import org.wso2.carbon.mediation.templates.stub.types.common.TemplateInfo;
import org.wso2.carbon.mediator.service.builtin.SequenceMediator;
import org.wso2.carbon.sequences.common.SequenceEditorException;
import org.wso2.carbon.sequences.common.to.SequenceInfo;
import org.wso2.carbon.sequences.ui.client.SequenceAdminClient;
import org.wso2.carbon.ui.CarbonUIUtil;

public class TemplateAdminClientAdapter
extends SequenceAdminClient {
    private static final Log log = LogFactory.getLog(TemplateAdminClientAdapter.class);
    private TemplateAdminServiceStub templateAdminStub;

    public TemplateAdminClientAdapter(ServletConfig config, HttpSession session) throws AxisFault {
        super(config, session);
        String backendServerURL = CarbonUIUtil.getServerURL((ServletContext)config.getServletContext(), (HttpSession)session);
        ConfigurationContext configContext = (ConfigurationContext)config.getServletContext().getAttribute("ConfigurationContext");
        String cookie = (String)session.getAttribute("wso2carbon.admin.service.cookie");
        String serviceURL = backendServerURL + "TemplateAdminService";
        this.templateAdminStub = new TemplateAdminServiceStub(configContext, serviceURL);
        ServiceClient client = this.templateAdminStub._getServiceClient();
        Options option = client.getOptions();
        option.setManageSession(true);
        option.setProperty("Cookie", (Object)cookie);
    }

    public SequenceInfo[] getSequences(int pageNumber, int sequencePerPage) throws SequenceEditorException {
        return this.getTemplates(pageNumber, sequencePerPage);
    }

    public SequenceInfo[] getTemplates(int pageNumber, int templatesPerPage) throws SequenceEditorException {
        ArrayList<SequenceInfo> sequences = new ArrayList<SequenceInfo>();
        try {
            TemplateInfo[] temp = this.templateAdminStub.getTemplates(pageNumber, templatesPerPage);
            if (temp == null || temp.length == 0 || temp[0] == null) {
                return null;
            }
            for (TemplateInfo info : temp) {
                SequenceInfo seqInfo = new SequenceInfo();
                seqInfo.setEnableStatistics(info.getEnableStatistics());
                seqInfo.setEnableTracing(info.getEnableTracing());
                seqInfo.setName(info.getName());
                seqInfo.setDescription(info.getDescription());
                sequences.add(seqInfo);
            }
        }
        catch (Exception e) {
            this.handleException("Couldn't retrieve the information of the templates", e);
        }
        if (sequences.size() > 0) {
            return sequences.toArray(new SequenceInfo[sequences.size()]);
        }
        return null;
    }

    public int getSequencesCount() throws SequenceEditorException {
        return this.getTemplatesCount();
    }

    public int getTemplatesCount() throws SequenceEditorException {
        try {
            return this.templateAdminStub.getTemplatesCount();
        }
        catch (Exception e) {
            this.handleException("Couldn't retrieve the template element count", e);
            return 0;
        }
    }

    private OMElement getTemplate(String templateName) throws SequenceEditorException {
        OMElement element = null;
        try {
            element = this.templateAdminStub.getTemplate(templateName).getFirstElement();
        }
        catch (Exception e) {
            this.handleException("Couldn't retrieve the template element with name '" + templateName + "'", e);
        }
        return element;
    }

    public void saveSequence(SequenceMediator sequence) throws SequenceEditorException {
        this.saveTemplate(sequence);
    }

    public void saveTemplate(SequenceMediator template) throws SequenceEditorException {
        OMElement sequenceElem = template.serialize(null);
        try {
            this.templateAdminStub.saveTemplate(sequenceElem);
        }
        catch (Exception e) {
            this.handleException("Error in saving the template with the configuration '" + sequenceElem + "'", e);
        }
    }

    public void addSequence(SequenceMediator sequence) throws SequenceEditorException {
        this.addTemplate(sequence);
    }

    public void addTemplate(SequenceMediator template) throws SequenceEditorException {
        OMElement sequenceElem = template.serialize(null);
        try {
            this.templateAdminStub.addTemplate(sequenceElem);
        }
        catch (Exception e) {
            this.handleException("Error in adding the template with the configuration '" + sequenceElem + "'", e);
        }
    }

    public void addDynamicSequence(String key, SequenceMediator sequence) throws SequenceEditorException {
        this.addDynamicTemplate(key, sequence);
    }

    public void addDynamicTemplate(String key, SequenceMediator sequence) throws SequenceEditorException {
        OMElement sequenceElem = sequence.serialize(null);
        try {
            this.templateAdminStub.addDynamicTemplate(key, sequenceElem);
        }
        catch (Exception e) {
            this.handleException("Error in adding dynamic template with configuration '" + sequenceElem + "' to the registry with key '" + key + "'", e);
        }
    }

    public OMElement getDynamicSequence(String key) throws SequenceEditorException {
        return this.getDynamicTemplate(key);
    }

    public OMElement getDynamicTemplate(String key) throws SequenceEditorException {
        OMElement dynamicSequence = null;
        try {
            dynamicSequence = this.templateAdminStub.getDynamicTemplate(key);
        }
        catch (Exception e) {
            this.handleException("Couldn't get dynamic template with key '" + key + "'", e);
        }
        return dynamicSequence;
    }

    public void saveDynamicSequence(String key, SequenceMediator sequence) throws SequenceEditorException {
        this.saveDynamicTemplate(key, sequence);
    }

    public void saveDynamicTemplate(String key, SequenceMediator template) throws SequenceEditorException {
        OMElement sequenceElem = template.serialize(null);
        try {
            this.templateAdminStub.saveDynamicTemplate(key, sequenceElem);
        }
        catch (Exception e) {
            this.handleException("Error in saving dynamic template with configuration '" + sequenceElem + "' for key '" + key + "'", e);
        }
    }

    public String enableTracing(String templateName) throws SequenceEditorException {
        String state = null;
        try {
            state = this.templateAdminStub.enableTracing(templateName);
        }
        catch (Exception e) {
            this.handleException("Couldn't enable tracing for the template '" + templateName + "'", e);
        }
        return state;
    }

    public String disableTracing(String templateName) throws SequenceEditorException {
        String state = null;
        try {
            state = this.templateAdminStub.disableTracing(templateName);
        }
        catch (Exception e) {
            this.handleException("Couldn't disable tracing for the template '" + templateName + "'", e);
        }
        return state;
    }

    public String enableStatistics(String templateName) throws SequenceEditorException {
        String state = null;
        try {
            state = this.templateAdminStub.enableStatistics(templateName);
        }
        catch (Exception e) {
            this.handleException("Couldn't enable statistics for the template '" + templateName + "'", e);
        }
        return state;
    }

    public String disableStatistics(String templateName) throws SequenceEditorException {
        String state = null;
        try {
            state = this.templateAdminStub.disableStatistics(templateName);
        }
        catch (Exception e) {
            this.handleException("Couldn't disable statistics for the template '" + templateName + "'", e);
        }
        return state;
    }

    public void deleteSequence(String sequenceName) throws SequenceEditorException {
        this.deleteTemplate(sequenceName);
    }

    public void deleteTemplate(String templateName) throws SequenceEditorException {
        try {
            this.templateAdminStub.deleteTemplate(templateName);
        }
        catch (Exception e) {
            this.handleException("Couldn't delete the sequence '" + templateName + "'", e);
        }
    }

    public void updateDynamicSequence(String key, SequenceMediator sequence) throws SequenceEditorException {
        this.updateDynamicTemplate(key, sequence);
    }

    public void updateDynamicTemplate(String key, SequenceMediator template) throws SequenceEditorException {
        try {
            OMElement templateElem = template.serialize(null);
            this.templateAdminStub.updateDynamicTemplate(key, templateElem);
        }
        catch (Exception e) {
            this.handleException("Couldn't update template with key '" + key + "'", e);
        }
    }

    public void deleteDynamicSequence(String key) throws SequenceEditorException {
        this.deleteDynamicTemplate(key);
    }

    public void deleteDynamicTemplate(String key) throws SequenceEditorException {
        try {
            this.templateAdminStub.deleteDynamicTemplate(key);
        }
        catch (Exception e) {
            this.handleException("Couldn't delete template with key '" + key + "'", e);
        }
    }

    public SequenceInfo[] getDynamicSequences(int pageNumber, int sequencePerPage) throws SequenceEditorException {
        return this.getDynamicTemplates(pageNumber, sequencePerPage);
    }

    public SequenceInfo[] getDynamicTemplates(int pageNumber, int sequencePerPage) throws SequenceEditorException {
        ArrayList<SequenceInfo> sequences = new ArrayList<SequenceInfo>();
        try {
            TemplateInfo[] temp = this.templateAdminStub.getDynamicTemplates(pageNumber, sequencePerPage);
            if (temp == null || temp.length == 0 || temp[0] == null) {
                return null;
            }
            for (TemplateInfo info : temp) {
                SequenceInfo seqInfo = new SequenceInfo();
                seqInfo.setName(info.getName());
                sequences.add(seqInfo);
            }
        }
        catch (Exception e) {
            this.handleException("Couldn't retrieve the information of the templates", e);
        }
        if (sequences.size() > 0) {
            return sequences.toArray(new SequenceInfo[sequences.size()]);
        }
        return null;
    }

    public int getDynamicSequenceCount() throws SequenceEditorException {
        return this.getDynamicTemplateCount();
    }

    public int getDynamicTemplateCount() throws SequenceEditorException {
        try {
            return this.templateAdminStub.getDynamicTemplateCount();
        }
        catch (Exception e) {
            this.handleException("Couldn't retrieve the dynamic template element count", e);
            return 0;
        }
    }

    public SequenceMediator getSequenceMediator(String sequenceName) throws SequenceEditorException {
        return this.getTemplateMediator(sequenceName);
    }

    public SequenceMediator getTemplateMediator(String templateName) throws SequenceEditorException {
        OMElement ele = this.getTemplate(templateName);
        if (ele != null) {
            TemplateMediator sequence = new TemplateMediator();
            sequence.build(ele);
            return sequence;
        }
        return null;
    }

    private void handleException(String message, Throwable e) throws SequenceEditorException {
        log.error((Object)message, e);
        throw new SequenceEditorException(message, e);
    }
}

