/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.templates.common.factory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.synapse.endpoints.Template;
import org.apache.synapse.mediators.template.TemplateMediator;
import org.wso2.carbon.mediation.templates.common.EndpointTemplateInfo;
import org.wso2.carbon.mediation.templates.common.TemplateInfo;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class TemplateInfoFactory {
    public static TemplateInfo createTemplateInfo(TemplateMediator sequenceMediator) {
        TemplateInfo templateInfo = new TemplateInfo();
        templateInfo.setName(sequenceMediator.getName());
        templateInfo.setDescription(sequenceMediator.getDescription());
        if (sequenceMediator.isStatisticsEnable()) {
            templateInfo.setEnableStatistics(true);
        } else {
            templateInfo.setEnableStatistics(false);
        }
        if (sequenceMediator.getTraceState() == 1) {
            templateInfo.setEnableTracing(true);
        } else {
            templateInfo.setEnableTracing(false);
        }
        return templateInfo;
    }

    public static EndpointTemplateInfo createTemplateInfo(Template endpointTemplate) {
        EndpointTemplateInfo templateInfo = new EndpointTemplateInfo();
        templateInfo.setTemplateName(endpointTemplate.getName());
        templateInfo.setDescription(endpointTemplate.getDescription());
        templateInfo.setEndpointType(TemplateInfoFactory.getEndpointTypeFromTemplate(endpointTemplate.getElement()));
        return templateInfo;
    }

    public static String getEndpointTypeFromTemplate(OMElement templateEl) {
        String type = "none";
        OMElement addressElement = templateEl.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "address"));
        if (addressElement != null) {
            type = "address";
            return type;
        }
        OMElement wsdlElement = templateEl.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "wsdl"));
        if (wsdlElement != null) {
            type = "wsdl";
            return type;
        }
        OMElement defaultElement = templateEl.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "default"));
        if (defaultElement != null) {
            type = "default";
            return type;
        }
        OMElement lbElement = templateEl.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "loadbalance"));
        if (lbElement != null) {
            type = "loadbalance";
            return type;
        }
        return type;
    }

    public static TemplateInfo[] getSortedTemplateInfoArray(Collection<TemplateMediator> templateMediators) {
        ArrayList<TemplateInfo> templateInfoList = new ArrayList<TemplateInfo>();
        for (TemplateMediator templateMediator : templateMediators) {
            templateInfoList.add(TemplateInfoFactory.createTemplateInfo(templateMediator));
        }
        Collections.sort(templateInfoList, new Comparator<TemplateInfo>(){

            @Override
            public int compare(TemplateInfo info1, TemplateInfo info2) {
                return info1.getName().compareToIgnoreCase(info2.getName());
            }
        });
        return templateInfoList.toArray(new TemplateInfo[templateInfoList.size()]);
    }

    public static EndpointTemplateInfo[] getSortedTemplateInfoArray(Collection<Template> templateMediators) {
        ArrayList<EndpointTemplateInfo> templateInfoList = new ArrayList<EndpointTemplateInfo>();
        for (Template templateMediator : templateMediators) {
            templateInfoList.add(TemplateInfoFactory.createTemplateInfo(templateMediator));
        }
        Collections.sort(templateInfoList, new Comparator<EndpointTemplateInfo>(){

            @Override
            public int compare(EndpointTemplateInfo info1, EndpointTemplateInfo info2) {
                return info1.getTemplateName().compareToIgnoreCase(info2.getTemplateName());
            }
        });
        return templateInfoList.toArray(new EndpointTemplateInfo[templateInfoList.size()]);
    }
}

