/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.statistics;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.synapse.aspects.ComponentType;
import org.wso2.carbon.mediation.initializer.AbstractServiceBusAdmin;
import org.wso2.carbon.mediation.statistics.GraphData;
import org.wso2.carbon.mediation.statistics.InOutStatisticsRecord;
import org.wso2.carbon.mediation.statistics.MediationStatisticsException;
import org.wso2.carbon.mediation.statistics.MediationStatisticsStore;
import org.wso2.carbon.mediation.statistics.StatisticsRecord;
import org.wso2.carbon.mediation.statistics.StatisticsUtil;

public class MediationStatisticsAdmin
extends AbstractServiceBusAdmin {
    public String[] listServers() {
        String host;
        try {
            host = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            host = "127.0.0.1";
        }
        return new String[]{host};
    }

    public String[] listSequence() {
        return ((MediationStatisticsStore)this.getConfigContext().getProperty("MediationStatisticsStore")).getResourceNames(ComponentType.SEQUENCE);
    }

    public String[] listProxyServices() {
        return ((MediationStatisticsStore)this.getConfigContext().getProperty("MediationStatisticsStore")).getResourceNames(ComponentType.PROXYSERVICE);
    }

    public String[] listEndPoint() {
        return ((MediationStatisticsStore)this.getConfigContext().getProperty("MediationStatisticsStore")).getResourceNames(ComponentType.ENDPOINT);
    }

    public InOutStatisticsRecord getCategoryStatistics(int category) {
        ComponentType type = StatisticsUtil.getComponentType(category);
        return this.getCategoryStatistics(type);
    }

    private InOutStatisticsRecord getCategoryStatistics(ComponentType type) {
        InOutStatisticsRecord record = new InOutStatisticsRecord();
        record.setInRecord(((MediationStatisticsStore)this.getConfigContext().getProperty("MediationStatisticsStore")).getRecordByCategory(type, true));
        record.setOutRecord(((MediationStatisticsStore)this.getConfigContext().getProperty("MediationStatisticsStore")).getRecordByCategory(type, false));
        return record;
    }

    public GraphData getDataForGraph() throws MediationStatisticsException {
        String host;
        GraphData graphData = new GraphData();
        HashMap<String, Integer> serverData = new HashMap<String, Integer>();
        try {
            host = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            host = "127.0.0.1";
        }
        StatisticsRecord serverRecord = this.getServerStatistics().getInRecord();
        if (serverRecord != null) {
            serverData.put(host, serverRecord.getTotalCount());
        }
        Map<String, Integer> psData = ((MediationStatisticsStore)this.getConfigContext().getProperty("MediationStatisticsStore")).getTotalCounts(ComponentType.PROXYSERVICE);
        Map<String, Integer> epData = ((MediationStatisticsStore)this.getConfigContext().getProperty("MediationStatisticsStore")).getTotalCounts(ComponentType.ENDPOINT);
        Map<String, Integer> sequenceData = ((MediationStatisticsStore)this.getConfigContext().getProperty("MediationStatisticsStore")).getTotalCounts(ComponentType.SEQUENCE);
        StringBuffer serverDataStr = new StringBuffer();
        StringBuffer psDataStr = new StringBuffer();
        StringBuffer epDataStr = new StringBuffer();
        StringBuffer sequenceDataStr = new StringBuffer();
        for (Map.Entry entry : serverData.entrySet()) {
            serverDataStr.append((String)entry.getKey() + "-[" + entry.getValue() + "]-," + entry.getValue() + ";");
        }
        for (Map.Entry<Object, Object> entry : psData.entrySet()) {
            psDataStr.append((String)entry.getKey() + "-[" + entry.getValue() + "]-," + entry.getValue() + ";");
        }
        for (Map.Entry<Object, Object> entry : epData.entrySet()) {
            epDataStr.append((String)entry.getKey() + "-[" + entry.getValue() + "]-," + entry.getValue() + ";");
        }
        for (Map.Entry<Object, Object> entry : sequenceData.entrySet()) {
            sequenceDataStr.append((String)entry.getKey() + "-[" + entry.getValue() + "]-," + entry.getValue() + ";");
        }
        graphData.setEndPointData(epDataStr.toString());
        graphData.setProxyServiceData(psDataStr.toString());
        graphData.setSequenceData(sequenceDataStr.toString());
        graphData.setServerData(serverDataStr.toString());
        return graphData;
    }

    public InOutStatisticsRecord getProxyServiceStatistics(String proxyName) {
        InOutStatisticsRecord record = new InOutStatisticsRecord();
        record.setInRecord(((MediationStatisticsStore)this.getConfigContext().getProperty("MediationStatisticsStore")).getRecordByResource(proxyName, ComponentType.PROXYSERVICE, true));
        record.setOutRecord(((MediationStatisticsStore)this.getConfigContext().getProperty("MediationStatisticsStore")).getRecordByResource(proxyName, ComponentType.PROXYSERVICE, false));
        return record;
    }

    public InOutStatisticsRecord getServerStatistics() {
        StatisticsRecord seqOutStats;
        StatisticsRecord proxyOutStats;
        StatisticsRecord seqInStats;
        ArrayList<StatisticsRecord> inRecords = new ArrayList<StatisticsRecord>();
        ArrayList<StatisticsRecord> outRecords = new ArrayList<StatisticsRecord>();
        StatisticsRecord proxyInStats = this.getCategoryStatistics(ComponentType.PROXYSERVICE).getInRecord();
        if (proxyInStats != null) {
            inRecords.add(proxyInStats);
        }
        if ((seqInStats = this.getSequenceStatistics("main").getInRecord()) != null) {
            inRecords.add(seqInStats);
        }
        if ((proxyOutStats = this.getCategoryStatistics(ComponentType.PROXYSERVICE).getOutRecord()) != null) {
            outRecords.add(proxyOutStats);
        }
        if ((seqOutStats = this.getSequenceStatistics("main").getOutRecord()) != null) {
            outRecords.add(seqOutStats);
        }
        InOutStatisticsRecord inOutRecord = new InOutStatisticsRecord();
        inOutRecord.setInRecord(StatisticsUtil.getCombinedRecord(inRecords));
        inOutRecord.setOutRecord(StatisticsUtil.getCombinedRecord(outRecords));
        return inOutRecord;
    }

    public InOutStatisticsRecord getSequenceStatistics(String sequenceName) {
        InOutStatisticsRecord record = new InOutStatisticsRecord();
        record.setInRecord(((MediationStatisticsStore)this.getConfigContext().getProperty("MediationStatisticsStore")).getRecordByResource(sequenceName, ComponentType.SEQUENCE, true));
        record.setOutRecord(((MediationStatisticsStore)this.getConfigContext().getProperty("MediationStatisticsStore")).getRecordByResource(sequenceName, ComponentType.SEQUENCE, false));
        return record;
    }

    public InOutStatisticsRecord getEndPointStatistics(String endpointName) {
        InOutStatisticsRecord record = new InOutStatisticsRecord();
        if (endpointName.contains("__")) {
            record.setInRecord(((MediationStatisticsStore)this.getConfigContext().getProperty("MediationStatisticsStore")).getRecordByResource(endpointName, ComponentType.ENDPOINT, true));
        } else {
            String[] endpoints = this.listEndPoint();
            StatisticsRecord fullRecord = null;
            for (String endpoint : endpoints) {
                if (!endpoint.equals(endpointName) && !endpoint.startsWith(endpointName + "__")) continue;
                StatisticsRecord currentRecord = ((MediationStatisticsStore)this.getConfigContext().getProperty("MediationStatisticsStore")).getRecordByResource(endpoint, ComponentType.ENDPOINT, true);
                if (fullRecord == null) {
                    fullRecord = new StatisticsRecord(currentRecord);
                    continue;
                }
                fullRecord.updateRecord(currentRecord);
            }
            record.setInRecord(fullRecord);
        }
        return record;
    }
}

