/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.statistics.persistence;

import java.util.LinkedList;
import java.util.Queue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.mediation.statistics.MediationStatisticsObserver;
import org.wso2.carbon.mediation.statistics.MediationStatisticsSnapshot;
import org.wso2.carbon.mediation.statistics.MessageTraceLog;
import org.wso2.carbon.mediation.statistics.ServiceReferenceHolder;
import org.wso2.carbon.mediation.statistics.StatisticsRecord;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;

public final class PersistingStatisticsObserver
implements MediationStatisticsObserver {
    private static final Log log = LogFactory.getLog(MediationStatisticsObserver.class);
    private Queue<StatisticsRecord> dataQueue = new LinkedList<StatisticsRecord>();
    private RegistryWriter writerTask;
    private Registry registry;
    private boolean proceed;
    private final String rootPath;
    private static final String PROXY = "/proxy-services";
    private static final String SEQUENCES = "/sequences";
    private static final String ENDPOINTS = "/endpoints";

    public PersistingStatisticsObserver(String rootPath) {
        this.rootPath = rootPath == null ? "/repository/mediation-stats/" : rootPath;
        this.proceed = true;
        try {
            this.registry = ServiceReferenceHolder.getInstance().getGovernanceRegistry();
            this.writerTask = new RegistryWriter();
            this.writerTask.start();
        }
        catch (RegistryException e) {
            log.error((Object)"Error while obtaining a registry instance. The persisting statistics observer will not function.", (Throwable)e);
        }
    }

    @Override
    public void destroy() {
        this.proceed = false;
    }

    @Override
    public void updateStatistics(MediationStatisticsSnapshot snapshot) {
        StatisticsRecord latestRecord;
        if (!this.proceed) {
            return;
        }
        if (snapshot.getEntitySnapshot() != null) {
            latestRecord = new StatisticsRecord(snapshot.getEntitySnapshot());
            latestRecord.updateRecord(snapshot.getUpdate());
        } else {
            latestRecord = snapshot.getUpdate();
        }
        this.dataQueue.add(latestRecord);
    }

    @Override
    public void notifyTraceLogs(MessageTraceLog[] logs) {
    }

    private void persistRecord(StatisticsRecord record) throws RegistryException {
        String path = this.calculatePath(record);
        Resource recordResource = this.registry.newResource();
        recordResource.setProperty("totalCount", String.valueOf(record.getTotalCount()));
        recordResource.setProperty("faultCount", String.valueOf(record.getFaultCount()));
        recordResource.setProperty("maxTime", String.valueOf(record.getMaxTime()));
        recordResource.setProperty("minTime", String.valueOf(record.getMinTime()));
        recordResource.setProperty("avgTime", String.valueOf(record.getAvgTime()));
        this.registry.put(path, recordResource);
        recordResource.discard();
    }

    private String calculatePath(StatisticsRecord entityRecord) {
        String type = "";
        switch (entityRecord.getType()) {
            case PROXYSERVICE: {
                type = PROXY;
                break;
            }
            case SEQUENCE: {
                type = SEQUENCES;
                break;
            }
            case ENDPOINT: {
                type = ENDPOINTS;
            }
        }
        String direction = "/in";
        if (!entityRecord.isInStatistic()) {
            direction = "/out";
        }
        return this.rootPath + type + "/" + entityRecord.getResourceId() + direction;
    }

    private class RegistryWriter
    extends Thread {
        private RegistryWriter() {
        }

        @Override
        public void run() {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Mediation statistics persisting thread has started");
            }
            while (PersistingStatisticsObserver.this.proceed || PersistingStatisticsObserver.this.dataQueue.size() > 0) {
                StatisticsRecord record = (StatisticsRecord)PersistingStatisticsObserver.this.dataQueue.poll();
                if (record == null) {
                    try {
                        RegistryWriter.sleep(5000L);
                    }
                    catch (InterruptedException e) {}
                    continue;
                }
                try {
                    PersistingStatisticsObserver.this.persistRecord(record);
                }
                catch (Throwable t) {
                    log.error((Object)"Error while accessing the registry for statistics persistence", t);
                }
            }
        }
    }
}

