/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.statistics.jmx;

import java.util.HashMap;
import java.util.Map;
import org.apache.synapse.aspects.ComponentType;
import org.apache.synapse.commons.jmx.MBeanRegistrar;
import org.wso2.carbon.mediation.statistics.MediationStatisticsObserver;
import org.wso2.carbon.mediation.statistics.MediationStatisticsSnapshot;
import org.wso2.carbon.mediation.statistics.MessageTraceLog;
import org.wso2.carbon.mediation.statistics.StatisticsRecord;
import org.wso2.carbon.mediation.statistics.jmx.StatisticsView;

public class JMXObserver
implements MediationStatisticsObserver {
    private Map<ComponentType, Map<String, StatisticsView>> inDataStore = new HashMap<ComponentType, Map<String, StatisticsView>>();
    private Map<ComponentType, Map<String, StatisticsView>> outDataStore = new HashMap<ComponentType, Map<String, StatisticsView>>();
    private Map<String, String> registeredMbeanIds = new HashMap<String, String>();

    public JMXObserver() {
        this.inDataStore = new HashMap<ComponentType, Map<String, StatisticsView>>();
        this.inDataStore.put(ComponentType.ENDPOINT, new HashMap());
        this.inDataStore.put(ComponentType.SEQUENCE, new HashMap());
        this.inDataStore.put(ComponentType.PROXYSERVICE, new HashMap());
        this.inDataStore.put(ComponentType.ANY, new HashMap());
        this.outDataStore = new HashMap<ComponentType, Map<String, StatisticsView>>();
        this.outDataStore.put(ComponentType.ENDPOINT, new HashMap());
        this.outDataStore.put(ComponentType.SEQUENCE, new HashMap());
        this.outDataStore.put(ComponentType.PROXYSERVICE, new HashMap());
        this.outDataStore.put(ComponentType.ANY, new HashMap());
    }

    @Override
    public void destroy() {
        for (String key : this.registeredMbeanIds.keySet()) {
            MBeanRegistrar.getInstance().unRegisterMBean(key, this.registeredMbeanIds.get(key));
        }
    }

    @Override
    public void updateStatistics(MediationStatisticsSnapshot snapshot) {
        StatisticsRecord update = snapshot.getUpdate();
        if (update.isInStatistic()) {
            StatisticsView view;
            Map<String, StatisticsView> map = this.inDataStore.get(update.getType());
            if (!map.containsKey(update.getResourceId())) {
                view = new StatisticsView();
                MBeanRegistrar.getInstance().registerMBean((Object)view, this.getCatagoryForType(update.getType()), update.getResourceId() + "-in");
                this.registeredMbeanIds.put(this.getCatagoryForType(update.getType()), update.getResourceId() + "-in");
                map.put(update.getResourceId(), view);
            } else {
                view = map.get(update.getResourceId());
            }
            this.updateView(view, update);
        } else {
            StatisticsView view;
            Map<String, StatisticsView> map = this.outDataStore.get(update.getType());
            if (!map.containsKey(update.getResourceId())) {
                view = new StatisticsView();
                MBeanRegistrar.getInstance().registerMBean((Object)view, this.getCatagoryForType(update.getType()), update.getResourceId() + "-out");
                this.registeredMbeanIds.put(this.getCatagoryForType(update.getType()), update.getResourceId() + "-out");
                map.put(update.getResourceId(), view);
            } else {
                view = map.get(update.getResourceId());
            }
            this.updateView(view, update);
        }
    }

    private void updateView(StatisticsView view, StatisticsRecord update) {
        long updatedTotalCount = view.getTotalCount() + (long)update.getTotalCount();
        if (updatedTotalCount > 0L) {
            view.setFaultCount((long)update.getFaultCount() + view.getFaultCount());
            view.setAvgTime((view.getAvgTime() * (double)view.getTotalCount() + update.getAvgTime() * (double)update.getTotalCount()) / (double)updatedTotalCount);
            if (update.getMaxTime() > view.getMaxTime()) {
                view.setMaxTime(update.getMaxTime());
            }
            if (view.getMinTime() == -1L || update.getMinTime() < view.getMinTime()) {
                view.setMinTime(update.getMinTime());
            }
            view.setTotalCount(updatedTotalCount);
        }
    }

    private String getCatagoryForType(ComponentType type) {
        if (type == ComponentType.ENDPOINT) {
            return "Endpoint-Statistics";
        }
        if (type == ComponentType.PROXYSERVICE) {
            return "ProxyService-Statistics";
        }
        if (type == ComponentType.SEQUENCE) {
            return "Sequence-Statistics";
        }
        if (type == ComponentType.ANY) {
            return "Any-Statistics";
        }
        return "";
    }

    @Override
    public void notifyTraceLogs(MessageTraceLog[] logs) {
    }
}

