/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.statistics;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.synapse.aspects.ComponentType;
import org.apache.synapse.aspects.statistics.StatisticsCollector;
import org.apache.synapse.aspects.statistics.StatisticsLog;
import org.apache.synapse.aspects.statistics.StatisticsRecord;
import org.apache.synapse.aspects.statistics.view.InOutStatisticsView;
import org.apache.synapse.aspects.statistics.view.StatisticsViewStrategy;
import org.apache.synapse.aspects.statistics.view.SystemViewStrategy;
import org.wso2.carbon.mediation.initializer.services.SynapseEnvironmentService;
import org.wso2.carbon.mediation.statistics.MediationStatisticsStore;
import org.wso2.carbon.mediation.statistics.MessageTraceLog;

public class StatisticsReporterThread
extends Thread {
    private static Logger log = Logger.getLogger(StatisticsReporterThread.class);
    private boolean shutdownRequested = false;
    private boolean tracingEnabled = false;
    private MediationStatisticsStore mediationStatisticsStore;
    private SynapseEnvironmentService synapseEnvironmentService;
    private long delay = 5000L;
    private final StatisticsViewStrategy systemViewStrategy = new SystemViewStrategy();

    public StatisticsReporterThread(SynapseEnvironmentService synEnvSvc, MediationStatisticsStore mediationStatStore) {
        this.synapseEnvironmentService = synEnvSvc;
        this.mediationStatisticsStore = mediationStatStore;
    }

    public void setDelay(long delay) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Mediation statistics reporter delay set to " + delay + " ms"));
        }
        this.delay = delay;
    }

    public void setTracingEnabled(boolean tracingEnabled) {
        this.tracingEnabled = tracingEnabled;
    }

    private void reportStatistics(Map<String, Map<String, InOutStatisticsView>> statsMap) {
        for (Map<String, InOutStatisticsView> viewMap : statsMap.values()) {
            for (InOutStatisticsView view : viewMap.values()) {
                if (view == null) continue;
                this.mediationStatisticsStore.updateStatistics(view);
            }
        }
    }

    private void delay() {
        if (this.delay <= 0L) {
            return;
        }
        try {
            StatisticsReporterThread.sleep(this.delay);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        while (!this.shutdownRequested) {
            try {
                this.collectDataAndReport();
            }
            catch (Throwable t) {
                log.error((Object)"Error while collecting and reporting mediation statistics", t);
            }
        }
    }

    private void collectDataAndReport() {
        List<MessageTraceLog> traceLogs;
        StatisticsCollector statisticsCollector;
        if (log.isDebugEnabled()) {
            log.trace((Object)"Starting new mediation statistics collection cycle");
        }
        if ((statisticsCollector = this.synapseEnvironmentService.getSynapseEnvironment().getStatisticsCollector()) == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Statistics collector is not available in the Synapse environment");
            }
            this.delay();
            return;
        }
        List records = statisticsCollector.getAndClearStatisticsRecords();
        if (records == null || records.size() == 0) {
            this.delay();
            return;
        }
        if (this.tracingEnabled && (traceLogs = this.getTraceLogs(records)) != null) {
            this.mediationStatisticsStore.notifyTraceLogs(traceLogs.toArray(new MessageTraceLog[traceLogs.size()]));
        }
        this.reportStatistics(this.systemViewStrategy.determineView(records, ComponentType.SEQUENCE));
        this.reportStatistics(this.systemViewStrategy.determineView(records, ComponentType.ENDPOINT));
        this.reportStatistics(this.systemViewStrategy.determineView(records, ComponentType.PROXYSERVICE));
    }

    private List<MessageTraceLog> getTraceLogs(List<StatisticsRecord> records) {
        ArrayList<MessageTraceLog> traceLogs = new ArrayList<MessageTraceLog>();
        for (StatisticsRecord record : records) {
            if (record == null) continue;
            MessageTraceLog traceLog = new MessageTraceLog(record.getId());
            List logs = record.getAllStatisticsLogs();
            StatisticsLog startLog = null;
            StatisticsLog endLog = null;
            for (StatisticsLog log : logs) {
                if (log == null) continue;
                if (startLog == null && log.getComponentType() != ComponentType.ANY) {
                    startLog = log;
                    continue;
                }
                if (startLog == null) continue;
                endLog = log;
                break;
            }
            if (startLog == null || endLog == null) continue;
            traceLog.setType(startLog.getComponentType());
            traceLog.setResourceId(startLog.getId());
            switch (startLog.getComponentType()) {
                case PROXYSERVICE: {
                    traceLog.setRequestFaultStatus(startLog.isFault() ? 1 : 0);
                    if (endLog.isEndAnyLog()) break;
                    StatisticsLog lastLog = (StatisticsLog)logs.get(logs.size() - 1);
                    traceLog.setResponseFaultStatus(lastLog.isFault() ? 1 : 0);
                    break;
                }
                case SEQUENCE: {
                    if (endLog.isResponse()) {
                        traceLog.setResponseFaultStatus(endLog.isFault() ? 1 : 0);
                        if (startLog.isResponse()) break;
                        traceLog.setRequestFaultStatus(startLog.isFault() ? 1 : 0);
                        break;
                    }
                    traceLog.setRequestFaultStatus(endLog.isFault() ? 1 : 0);
                    break;
                }
                case ENDPOINT: {
                    traceLog.setRequestFaultStatus(endLog.isFault() ? 1 : 0);
                }
            }
            traceLogs.add(traceLog);
        }
        if (traceLogs.size() > 0) {
            return traceLogs;
        }
        return null;
    }

    public void shutdown() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Statistics reporter thread is being stopped");
        }
        this.shutdownRequested = true;
    }
}

