/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.library.service.upload;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import javax.activation.DataHandler;
import org.apache.axis2.AxisFault;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.mediation.library.service.upload.LibraryFileItem;
import org.wso2.carbon.utils.CarbonUtils;

public class LibraryUploader
extends AbstractAdmin {
    private static final Log log = LogFactory.getLog(LibraryUploader.class);

    public void uploadLibrary(LibraryFileItem[] fileItems) throws AxisFault {
        try {
            AxisConfiguration axisConfig = this.getAxisConfig();
            String repo = axisConfig.getRepository().getPath();
            String carbonAppDir = repo + File.separator + "synapse-libs";
            this.createDir(carbonAppDir);
            String carbonHomeTmp = CarbonUtils.getCarbonHome() + File.separator + "tmp";
            this.createDir(carbonHomeTmp);
            String carbonAppDirTemp = carbonHomeTmp + File.separator + "synapse-libsuploads";
            this.createDir(carbonAppDirTemp);
            for (LibraryFileItem libraryFile : fileItems) {
                String fileName = libraryFile.getFileName();
                if (fileName == null || fileName.equals("")) {
                    throw new AxisFault("Invalid file name");
                }
                if (!libraryFile.getFileType().equals("zip")) {
                    throw new AxisFault("Invalid file type : " + libraryFile.getFileType());
                }
                this.writeResource(libraryFile.getDataHandler(), carbonAppDirTemp, carbonAppDir, fileName);
            }
        }
        catch (Exception e) {
            String msg = "Error occurred while uploading Carbon App artifacts";
            log.error((Object)msg, (Throwable)e);
            throw new AxisFault(msg, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeResource(DataHandler dataHandler, String tempDestPath, String destPath, String fileName) throws IOException {
        File tempDestFile = new File(tempDestPath, fileName);
        AbstractInterruptibleChannel out = null;
        AbstractInterruptibleChannel in = null;
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(tempDestFile);
            dataHandler.writeTo((OutputStream)fos);
            fos.flush();
            dataHandler.writeTo((OutputStream)fos);
            out = new FileOutputStream(destPath + File.separator + fileName).getChannel();
            in = new FileInputStream(tempDestFile).getChannel();
            ((FileChannel)out).write(((FileChannel)in).map(FileChannel.MapMode.READ_ONLY, 0L, ((FileChannel)in).size()));
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                log.warn((Object)"Can't close file streams.", (Throwable)e);
            }
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                log.warn((Object)"Can't close file streams.", (Throwable)e);
            }
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                log.warn((Object)"Can't close file streams.", (Throwable)e);
            }
        }
        if (!tempDestFile.delete()) {
            log.warn((Object)("temp file: " + tempDestFile.getAbsolutePath() + " deletion failed, scheduled deletion on server exit."));
            tempDestFile.deleteOnExit();
        }
    }

    private void createDir(String path) throws Exception {
        File temp = new File(path);
        if (!temp.exists() && !temp.mkdir()) {
            String msg = "Error while creating directory : " + path;
            log.error((Object)msg);
            throw new Exception(msg);
        }
    }
}

