/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.library.service;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.AxisFault;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.config.xml.SynapseImportFactory;
import org.apache.synapse.config.xml.SynapseImportSerializer;
import org.apache.synapse.libraries.imports.SynapseImport;
import org.apache.synapse.libraries.model.Library;
import org.apache.synapse.libraries.util.LibDeployerUtils;
import org.wso2.carbon.core.multitenancy.SuperTenantCarbonContext;
import org.wso2.carbon.mediation.initializer.AbstractServiceBusAdmin;
import org.wso2.carbon.mediation.initializer.ServiceBusUtils;
import org.wso2.carbon.mediation.initializer.persistence.MediationPersistenceManager;
import org.wso2.carbon.mediation.library.service.LibraryInfo;
import org.wso2.carbon.mediation.library.util.ConfigHolder;

public class MediationLibraryAdminService
extends AbstractServiceBusAdmin {
    private static Log log = LogFactory.getLog(MediationLibraryAdminService.class);
    public static final int MSGS_PER_PAGE = 10;

    public void addImport(String xml) throws AxisFault {
        try {
            OMElement imprtElem = this.createElement(xml);
            SynapseImport synapseImport = SynapseImportFactory.createImport((OMElement)imprtElem, null);
            if (synapseImport != null && synapseImport.getName() != null) {
                SynapseConfiguration synapseConfiguration = this.getSynapseConfiguration();
                String fileName = ServiceBusUtils.generateFileName((String)synapseImport.getName());
                synapseImport.setFileName(fileName);
                synapseConfiguration.addSynapseImport(synapseImport.getName(), synapseImport);
                String synImportQualfiedName = LibDeployerUtils.getQualifiedName((SynapseImport)synapseImport);
                Library synLib = (Library)this.getSynapseConfiguration().getSynapseLibraries().get(synImportQualfiedName);
                if (synLib != null) {
                    LibDeployerUtils.loadLibArtifacts((SynapseImport)synapseImport, (Library)synLib);
                }
                MediationPersistenceManager mp = this.getMediationPersistenceManager();
                mp.saveItem(synapseImport.getName(), 14);
            } else {
                String message = "Unable to create a Synapse Import for :  " + xml;
                this.handleException(log, message, null);
            }
        }
        catch (XMLStreamException e) {
            String message = "Unable to create a Synapse Import for :  " + xml;
            this.handleException(log, message, e);
        }
    }

    public void addImport(String libName, String packageName) throws AxisFault {
        SynapseImport synImport = new SynapseImport();
        synImport.setLibName(libName);
        synImport.setLibPackage(packageName);
        OMElement impEl = SynapseImportSerializer.serializeImport((SynapseImport)synImport);
        if (impEl != null) {
            try {
                this.addImport(impEl.toString());
            }
            catch (AxisFault axisFault) {
                this.handleException(log, "Could not add Synapse Import", (Exception)((Object)axisFault));
            }
        } else {
            this.handleException(log, "Could not add Synapse Import. Invalid import params for libName : " + libName + " packageName : " + packageName, null);
        }
    }

    public String getImport(String qualifiedName) throws AxisFault {
        SynapseConfiguration configuration = this.getSynapseConfiguration();
        assert (configuration != null);
        SynapseImport synapseImport = (SynapseImport)configuration.getSynapseImports().get(qualifiedName);
        String xml = null;
        if (synapseImport != null) {
            xml = SynapseImportSerializer.serializeImport((SynapseImport)synapseImport).toString();
        } else {
            this.handleException(log, "Library Import " + synapseImport + " does not exist", null);
        }
        return xml;
    }

    public void deleteImport(String importQualifiedName) throws AxisFault {
        SynapseConfiguration configuration = this.getSynapseConfiguration();
        assert (configuration != null);
        if (configuration.getSynapseImports().containsKey(importQualifiedName)) {
            SynapseImport synapseImport = configuration.removeSynapseImport(importQualifiedName);
            String fileName = synapseImport.getFileName();
            Library synLib = (Library)this.getSynapseConfiguration().getSynapseLibraries().get(importQualifiedName);
            if (synLib != null) {
                synLib.unLoadLibrary();
            }
            MediationPersistenceManager pm = this.getMediationPersistenceManager();
            pm.deleteItem(synapseImport.getName(), fileName, 14);
        } else {
            this.handleException(log, "Library Import " + importQualifiedName + " does not exist", null);
        }
    }

    public void deleteLibrary(String libQualifiedName) throws Exception {
        if (libQualifiedName == null) {
            this.handleException(log, "Library name can't be null", null);
            return;
        }
        Library currentMediationLib = null;
        int tenantId = MediationLibraryAdminService.getTenantId(this.getAxisConfig());
        SynapseConfiguration synConfigForTenant = ConfigHolder.getInstance().getSynapseEnvironmentService(tenantId).getSynapseEnvironment().getSynapseConfiguration();
        Collection appList = synConfigForTenant.getSynapseLibraries().values();
        for (Library mediationLib : appList) {
            if (!libQualifiedName.equals(mediationLib.getQName().toString())) continue;
            currentMediationLib = mediationLib;
        }
        if (currentMediationLib == null) {
            this.handleException(log, "No Mediation Library found of the name : " + libQualifiedName, null);
            return;
        }
        String libFilePath = currentMediationLib.getFileName();
        File file = new File(libFilePath);
        if (file.exists() && !file.delete()) {
            log.error((Object)("Artifact file couldn't be deleted for Mediation Library : " + currentMediationLib.getQName().toString()));
        }
    }

    public String[] getAllImports() throws AxisFault {
        SynapseConfiguration configuration = this.getSynapseConfiguration();
        assert (configuration != null);
        Set names = configuration.getSynapseImports().keySet();
        return names.toArray(new String[names.size()]);
    }

    public String[] getAllLibraries() throws AxisFault {
        SynapseConfiguration configuration = this.getSynapseConfiguration();
        assert (configuration != null);
        Set names = configuration.getSynapseLibraries().keySet();
        return names.toArray(new String[names.size()]);
    }

    public LibraryInfo[] getAllLibraryInfo() throws AxisFault {
        SynapseConfiguration configuration = this.getSynapseConfiguration();
        assert (configuration != null);
        ArrayList<LibraryInfo> librarySet = new ArrayList<LibraryInfo>();
        Collection libraries = configuration.getSynapseLibraries().values();
        for (Library library : libraries) {
            LibraryInfo libInfo = new LibraryInfo();
            libInfo.setLibName(library.getQName().getLocalPart());
            libInfo.setPackageName(library.getPackage());
            libInfo.setDescription(library.getDescription());
            librarySet.add(libInfo);
        }
        return librarySet.toArray(new LibraryInfo[libraries.size()]);
    }

    private void handleException(Log log, String message, Exception e) throws AxisFault {
        if (e == null) {
            AxisFault exception = new AxisFault(message);
            log.error((Object)message, (Throwable)exception);
            throw exception;
        }
        message = message + " :: " + e.getMessage();
        log.error((Object)message, (Throwable)e);
        throw new AxisFault(message, (Throwable)e);
    }

    private OMElement createElement(String str) throws XMLStreamException {
        ByteArrayInputStream in = new ByteArrayInputStream(str.getBytes());
        return new StAXOMBuilder((InputStream)in).getDocumentElement();
    }

    private static String getTenantIdString(AxisConfiguration axisConfig) {
        return String.valueOf(MediationLibraryAdminService.getTenantId(axisConfig));
    }

    private static int getTenantId(AxisConfiguration axisConfig) {
        SuperTenantCarbonContext carbonContext = SuperTenantCarbonContext.getCurrentContext((AxisConfiguration)axisConfig);
        return carbonContext.getTenantId();
    }
}

