/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.library.ui;

import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.mediation.library.stub.MediationLibraryAdminServiceStub;
import org.wso2.carbon.mediation.library.stub.types.carbon.LibraryInfo;

public class LibraryAdminClient {
    private static final Log log = LogFactory.getLog(LibraryAdminClient.class);
    private static final String BUNDLE = "org.wso2.carbon.application.mgt.ui.i18n.Resources";
    private ResourceBundle bundle;
    public MediationLibraryAdminServiceStub stub;

    public LibraryAdminClient(String cookie, String backendServerURL, ConfigurationContext configCtx, Locale locale) throws AxisFault {
        String serviceURL = backendServerURL + "MediationLibraryAdminService";
        this.bundle = ResourceBundle.getBundle(BUNDLE, locale);
        this.stub = new MediationLibraryAdminServiceStub(configCtx, serviceURL);
        ServiceClient client = this.stub._getServiceClient();
        Options option = client.getOptions();
        option.setManageSession(true);
        option.setProperty("Cookie", (Object)cookie);
        option.setProperty("enableMTOM", (Object)"true");
    }

    public String[] getAllImports() throws AxisFault {
        try {
            return this.stub.getAllImports();
        }
        catch (Exception e) {
            this.handleException(this.bundle.getString("cannot.get.service.data"), e);
            return null;
        }
    }

    public LibraryInfo[] getAllLibraryInfo() throws AxisFault {
        try {
            return this.stub.getAllLibraryInfo();
        }
        catch (Exception e) {
            this.handleException(this.bundle.getString("cannot.get.service.data"), e);
            return null;
        }
    }

    public void deleteImport(String importQualifiedName) throws AxisFault {
        try {
            this.stub.deleteImport(importQualifiedName);
        }
        catch (Exception e) {
            this.handleException(this.bundle.getString("cannot.delete.artifact"), e);
        }
    }

    public void addImport(String libName, String packageName) throws AxisFault {
        try {
            this.stub.addImport(libName, packageName);
        }
        catch (Exception e) {
            this.handleException(this.bundle.getString("cannot.delete.artifact"), e);
        }
    }

    public String getImport(String qualifiedName) throws AxisFault {
        try {
            return this.stub.getImport(qualifiedName);
        }
        catch (Exception e) {
            this.handleException(this.bundle.getString("cannot.delete.artifact"), e);
            return null;
        }
    }

    public void deleteLibrary(String libQualifiedName) throws Exception {
        try {
            this.stub.deleteLibrary(libQualifiedName);
        }
        catch (Exception e) {
            this.handleException(this.bundle.getString("cannot.delete.artifact"), e);
        }
    }

    private void handleException(String msg, Exception e) throws AxisFault {
        log.error((Object)msg, (Throwable)e);
        throw new AxisFault(msg, (Throwable)e);
    }
}

