/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.initializer.persistence.registry;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.axiom.om.OMElement;
import org.apache.synapse.config.xml.XMLConfigConstants;
import org.wso2.carbon.mediation.initializer.persistence.registry.AbstractRegistryStore;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;

public class ExecutorRegistryStore
extends AbstractRegistryStore {
    public ExecutorRegistryStore(UserRegistry registry, String configName) {
        super(registry, configName);
        this.createCollection(this.getConfigurationPath());
    }

    @Override
    public Collection<OMElement> getElements() {
        ArrayList<OMElement> executorElements = new ArrayList();
        try {
            executorElements = this.getChildElementsInPath(this.getConfigurationPath());
        }
        catch (RegistryException e) {
            this.handleException("Couldn't get the list of executors from the registry in path : " + this.getConfigurationPath(), (Exception)((Object)e));
        }
        return executorElements;
    }

    @Override
    public OMElement getElement(String name) {
        return null;
    }

    @Override
    public void persistElement(String name, OMElement element, String fileName) {
        if (element.getLocalName().equals(XMLConfigConstants.EXECUTOR_ELT.getLocalPart())) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Persisting executor : " + name + " to the registry"));
            }
            String executorPath = this.getConfigurationPath() + "/" + name;
            try {
                this.persistElement(element, executorPath, fileName);
            }
            catch (RegistryException e) {
                this.handleException("Unable to persist the executor in the path : " + executorPath, (Exception)((Object)e));
            }
        } else {
            this.handleException("The element provided to persist is not a sequence");
        }
    }

    @Override
    public void deleteElement(String name) {
        String executorPath = this.getConfigurationPath() + "/" + name;
        try {
            if (this.registry.resourceExists(executorPath)) {
                this.registry.delete(executorPath);
            }
        }
        catch (RegistryException e) {
            this.handleException("Error in deleting the executor at path : " + executorPath, (Exception)((Object)e));
        }
    }

    @Override
    protected String getConfigurationPath() {
        return this.getConfigurationRoot() + "/" + "synapse-executors";
    }
}

