/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.initializer.persistence;

import java.io.File;
import org.apache.axiom.om.OMElement;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.config.xml.RegistrySerializer;
import org.apache.synapse.registry.Registry;
import org.wso2.carbon.mediation.initializer.persistence.AbstractStore;
import org.wso2.carbon.mediation.initializer.persistence.registry.SynapseRegistriesRegistryStore;
import org.wso2.carbon.registry.core.session.UserRegistry;

public class SynapseRegistryStore
extends AbstractStore<Registry> {
    public SynapseRegistryStore(String configPath, UserRegistry registry, String configName) {
        super(configPath);
        if (registry != null) {
            this.registryStore = new SynapseRegistriesRegistryStore(registry, configName);
        }
    }

    @Override
    public void save(String name, SynapseConfiguration config) {
        if (name == null) {
            this.log.warn((Object)"Name of the configuration item is not given");
            return;
        }
        Registry registry = this.getObjectToPersist(name, config);
        if (registry == null) {
            this.log.warn((Object)"Unable to find the Synapse registry for persistence");
            return;
        }
        OMElement element = null;
        String fileName = null;
        try {
            if (!Boolean.valueOf(config.getProperty("__separateRegDef")).booleanValue()) {
                this.serializer.serializeSynapseXML(config);
            } else {
                element = this.serializer.serializeSynapseRegistry(registry, config, null);
                fileName = "registry.xml";
            }
        }
        catch (Exception e) {
            this.handleException("Error while saving the mediation registry to the file system", e);
        }
        if (this.registryStore != null) {
            if (element == null) {
                element = this.serialize(registry);
            }
            this.saveToRegistry(name, element, fileName);
        }
    }

    @Override
    protected void deleteFile(String fileName, SynapseConfiguration synapseConfiguration) {
        File rootDir = new File(this.configPath);
        if (!rootDir.exists()) {
            return;
        }
        File registryFile = new File(this.configPath, fileName);
        registryFile.delete();
    }

    @Override
    protected String getFileName(Registry registry) {
        return null;
    }

    @Override
    protected Registry getObjectToPersist(String name, SynapseConfiguration config) {
        return config.getRegistry();
    }

    @Override
    protected OMElement saveToFile(Registry registry, SynapseConfiguration synapseConfiguration) {
        return null;
    }

    @Override
    protected OMElement serialize(Registry registry) {
        return RegistrySerializer.serializeRegistry(null, (Registry)registry);
    }

    @Override
    protected void saveToRegistry(String name, OMElement element, String fileName) {
        SynapseRegistriesRegistryStore synapseRegStore = (SynapseRegistriesRegistryStore)this.registryStore;
        synapseRegStore.persistElement(element, fileName);
    }
}

